/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.clouddirectory.model.transform.PathToObjectIdentifiersMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PathToObjectIdentifiers
implements Serializable,
Cloneable,
StructuredPojo {
    private String path;
    private List<String> objectIdentifiers;

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public PathToObjectIdentifiers withPath(String path) {
        this.setPath(path);
        return this;
    }

    public List<String> getObjectIdentifiers() {
        return this.objectIdentifiers;
    }

    public void setObjectIdentifiers(Collection<String> objectIdentifiers) {
        if (objectIdentifiers == null) {
            this.objectIdentifiers = null;
            return;
        }
        this.objectIdentifiers = new ArrayList<String>(objectIdentifiers);
    }

    public PathToObjectIdentifiers withObjectIdentifiers(String ... objectIdentifiers) {
        if (this.objectIdentifiers == null) {
            this.setObjectIdentifiers(new ArrayList<String>(objectIdentifiers.length));
        }
        for (String ele : objectIdentifiers) {
            this.objectIdentifiers.add(ele);
        }
        return this;
    }

    public PathToObjectIdentifiers withObjectIdentifiers(Collection<String> objectIdentifiers) {
        this.setObjectIdentifiers(objectIdentifiers);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPath() != null) {
            sb.append("Path: ").append(this.getPath()).append(",");
        }
        if (this.getObjectIdentifiers() != null) {
            sb.append("ObjectIdentifiers: ").append(this.getObjectIdentifiers());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PathToObjectIdentifiers)) {
            return false;
        }
        PathToObjectIdentifiers other = (PathToObjectIdentifiers)obj;
        if (other.getPath() == null ^ this.getPath() == null) {
            return false;
        }
        if (other.getPath() != null && !other.getPath().equals(this.getPath())) {
            return false;
        }
        if (other.getObjectIdentifiers() == null ^ this.getObjectIdentifiers() == null) {
            return false;
        }
        return other.getObjectIdentifiers() == null || other.getObjectIdentifiers().equals(this.getObjectIdentifiers());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPath() == null ? 0 : this.getPath().hashCode());
        hashCode = 31 * hashCode + (this.getObjectIdentifiers() == null ? 0 : this.getObjectIdentifiers().hashCode());
        return hashCode;
    }

    public PathToObjectIdentifiers clone() {
        try {
            return (PathToObjectIdentifiers)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PathToObjectIdentifiersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

