/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cleanrooms.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cleanrooms.model.AggregateFunctionName;
import com.amazonaws.services.cleanrooms.model.transform.AggregateColumnMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AggregateColumn
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> columnNames;
    private String function;

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(Collection<String> columnNames) {
        if (columnNames == null) {
            this.columnNames = null;
            return;
        }
        this.columnNames = new ArrayList<String>(columnNames);
    }

    public AggregateColumn withColumnNames(String ... columnNames) {
        if (this.columnNames == null) {
            this.setColumnNames(new ArrayList<String>(columnNames.length));
        }
        for (String ele : columnNames) {
            this.columnNames.add(ele);
        }
        return this;
    }

    public AggregateColumn withColumnNames(Collection<String> columnNames) {
        this.setColumnNames(columnNames);
        return this;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public String getFunction() {
        return this.function;
    }

    public AggregateColumn withFunction(String function) {
        this.setFunction(function);
        return this;
    }

    public AggregateColumn withFunction(AggregateFunctionName function) {
        this.function = function.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getColumnNames() != null) {
            sb.append("ColumnNames: ").append(this.getColumnNames()).append(",");
        }
        if (this.getFunction() != null) {
            sb.append("Function: ").append(this.getFunction());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateColumn)) {
            return false;
        }
        AggregateColumn other = (AggregateColumn)obj;
        if (other.getColumnNames() == null ^ this.getColumnNames() == null) {
            return false;
        }
        if (other.getColumnNames() != null && !other.getColumnNames().equals(this.getColumnNames())) {
            return false;
        }
        if (other.getFunction() == null ^ this.getFunction() == null) {
            return false;
        }
        return other.getFunction() == null || other.getFunction().equals(this.getFunction());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getColumnNames() == null ? 0 : this.getColumnNames().hashCode());
        hashCode = 31 * hashCode + (this.getFunction() == null ? 0 : this.getFunction().hashCode());
        return hashCode;
    }

    public AggregateColumn clone() {
        try {
            return (AggregateColumn)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AggregateColumnMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

