/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.budgets.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.budgets.model.transform.ScpActionDefinitionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ScpActionDefinition
implements Serializable,
Cloneable,
StructuredPojo {
    private String policyId;
    private List<String> targetIds;

    public void setPolicyId(String policyId) {
        this.policyId = policyId;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public ScpActionDefinition withPolicyId(String policyId) {
        this.setPolicyId(policyId);
        return this;
    }

    public List<String> getTargetIds() {
        return this.targetIds;
    }

    public void setTargetIds(Collection<String> targetIds) {
        if (targetIds == null) {
            this.targetIds = null;
            return;
        }
        this.targetIds = new ArrayList<String>(targetIds);
    }

    public ScpActionDefinition withTargetIds(String ... targetIds) {
        if (this.targetIds == null) {
            this.setTargetIds(new ArrayList<String>(targetIds.length));
        }
        for (String ele : targetIds) {
            this.targetIds.add(ele);
        }
        return this;
    }

    public ScpActionDefinition withTargetIds(Collection<String> targetIds) {
        this.setTargetIds(targetIds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPolicyId() != null) {
            sb.append("PolicyId: ").append(this.getPolicyId()).append(",");
        }
        if (this.getTargetIds() != null) {
            sb.append("TargetIds: ").append(this.getTargetIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScpActionDefinition)) {
            return false;
        }
        ScpActionDefinition other = (ScpActionDefinition)obj;
        if (other.getPolicyId() == null ^ this.getPolicyId() == null) {
            return false;
        }
        if (other.getPolicyId() != null && !other.getPolicyId().equals(this.getPolicyId())) {
            return false;
        }
        if (other.getTargetIds() == null ^ this.getTargetIds() == null) {
            return false;
        }
        return other.getTargetIds() == null || other.getTargetIds().equals(this.getTargetIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPolicyId() == null ? 0 : this.getPolicyId().hashCode());
        hashCode = 31 * hashCode + (this.getTargetIds() == null ? 0 : this.getTargetIds().hashCode());
        return hashCode;
    }

    public ScpActionDefinition clone() {
        try {
            return (ScpActionDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScpActionDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

