/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockruntime.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.bedrockruntime.model.GuardrailContentBlock;
import com.amazonaws.services.bedrockruntime.model.GuardrailContentSource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ApplyGuardrailRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String guardrailIdentifier;
    private String guardrailVersion;
    private String source;
    private List<GuardrailContentBlock> content;

    public void setGuardrailIdentifier(String guardrailIdentifier) {
        this.guardrailIdentifier = guardrailIdentifier;
    }

    public String getGuardrailIdentifier() {
        return this.guardrailIdentifier;
    }

    public ApplyGuardrailRequest withGuardrailIdentifier(String guardrailIdentifier) {
        this.setGuardrailIdentifier(guardrailIdentifier);
        return this;
    }

    public void setGuardrailVersion(String guardrailVersion) {
        this.guardrailVersion = guardrailVersion;
    }

    public String getGuardrailVersion() {
        return this.guardrailVersion;
    }

    public ApplyGuardrailRequest withGuardrailVersion(String guardrailVersion) {
        this.setGuardrailVersion(guardrailVersion);
        return this;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public ApplyGuardrailRequest withSource(String source) {
        this.setSource(source);
        return this;
    }

    public ApplyGuardrailRequest withSource(GuardrailContentSource source) {
        this.source = source.toString();
        return this;
    }

    public List<GuardrailContentBlock> getContent() {
        return this.content;
    }

    public void setContent(Collection<GuardrailContentBlock> content) {
        if (content == null) {
            this.content = null;
            return;
        }
        this.content = new ArrayList<GuardrailContentBlock>(content);
    }

    public ApplyGuardrailRequest withContent(GuardrailContentBlock ... content) {
        if (this.content == null) {
            this.setContent(new ArrayList<GuardrailContentBlock>(content.length));
        }
        for (GuardrailContentBlock ele : content) {
            this.content.add(ele);
        }
        return this;
    }

    public ApplyGuardrailRequest withContent(Collection<GuardrailContentBlock> content) {
        this.setContent(content);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGuardrailIdentifier() != null) {
            sb.append("GuardrailIdentifier: ").append(this.getGuardrailIdentifier()).append(",");
        }
        if (this.getGuardrailVersion() != null) {
            sb.append("GuardrailVersion: ").append(this.getGuardrailVersion()).append(",");
        }
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource()).append(",");
        }
        if (this.getContent() != null) {
            sb.append("Content: ").append(this.getContent());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplyGuardrailRequest)) {
            return false;
        }
        ApplyGuardrailRequest other = (ApplyGuardrailRequest)obj;
        if (other.getGuardrailIdentifier() == null ^ this.getGuardrailIdentifier() == null) {
            return false;
        }
        if (other.getGuardrailIdentifier() != null && !other.getGuardrailIdentifier().equals(this.getGuardrailIdentifier())) {
            return false;
        }
        if (other.getGuardrailVersion() == null ^ this.getGuardrailVersion() == null) {
            return false;
        }
        if (other.getGuardrailVersion() != null && !other.getGuardrailVersion().equals(this.getGuardrailVersion())) {
            return false;
        }
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getContent() == null ^ this.getContent() == null) {
            return false;
        }
        return other.getContent() == null || other.getContent().equals(this.getContent());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGuardrailIdentifier() == null ? 0 : this.getGuardrailIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getGuardrailVersion() == null ? 0 : this.getGuardrailVersion().hashCode());
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getContent() == null ? 0 : this.getContent().hashCode());
        return hashCode;
    }

    public ApplyGuardrailRequest clone() {
        return (ApplyGuardrailRequest)super.clone();
    }
}

