/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockagent.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrockagent.model.MemoryType;
import com.amazonaws.services.bedrockagent.model.transform.MemoryConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MemoryConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> enabledMemoryTypes;
    private Integer storageDays;

    public List<String> getEnabledMemoryTypes() {
        return this.enabledMemoryTypes;
    }

    public void setEnabledMemoryTypes(Collection<String> enabledMemoryTypes) {
        if (enabledMemoryTypes == null) {
            this.enabledMemoryTypes = null;
            return;
        }
        this.enabledMemoryTypes = new ArrayList<String>(enabledMemoryTypes);
    }

    public MemoryConfiguration withEnabledMemoryTypes(String ... enabledMemoryTypes) {
        if (this.enabledMemoryTypes == null) {
            this.setEnabledMemoryTypes(new ArrayList<String>(enabledMemoryTypes.length));
        }
        for (String ele : enabledMemoryTypes) {
            this.enabledMemoryTypes.add(ele);
        }
        return this;
    }

    public MemoryConfiguration withEnabledMemoryTypes(Collection<String> enabledMemoryTypes) {
        this.setEnabledMemoryTypes(enabledMemoryTypes);
        return this;
    }

    public MemoryConfiguration withEnabledMemoryTypes(MemoryType ... enabledMemoryTypes) {
        ArrayList<String> enabledMemoryTypesCopy = new ArrayList<String>(enabledMemoryTypes.length);
        for (MemoryType value : enabledMemoryTypes) {
            enabledMemoryTypesCopy.add(value.toString());
        }
        if (this.getEnabledMemoryTypes() == null) {
            this.setEnabledMemoryTypes(enabledMemoryTypesCopy);
        } else {
            this.getEnabledMemoryTypes().addAll(enabledMemoryTypesCopy);
        }
        return this;
    }

    public void setStorageDays(Integer storageDays) {
        this.storageDays = storageDays;
    }

    public Integer getStorageDays() {
        return this.storageDays;
    }

    public MemoryConfiguration withStorageDays(Integer storageDays) {
        this.setStorageDays(storageDays);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEnabledMemoryTypes() != null) {
            sb.append("EnabledMemoryTypes: ").append(this.getEnabledMemoryTypes()).append(",");
        }
        if (this.getStorageDays() != null) {
            sb.append("StorageDays: ").append(this.getStorageDays());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemoryConfiguration)) {
            return false;
        }
        MemoryConfiguration other = (MemoryConfiguration)obj;
        if (other.getEnabledMemoryTypes() == null ^ this.getEnabledMemoryTypes() == null) {
            return false;
        }
        if (other.getEnabledMemoryTypes() != null && !other.getEnabledMemoryTypes().equals(this.getEnabledMemoryTypes())) {
            return false;
        }
        if (other.getStorageDays() == null ^ this.getStorageDays() == null) {
            return false;
        }
        return other.getStorageDays() == null || other.getStorageDays().equals(this.getStorageDays());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEnabledMemoryTypes() == null ? 0 : this.getEnabledMemoryTypes().hashCode());
        hashCode = 31 * hashCode + (this.getStorageDays() == null ? 0 : this.getStorageDays().hashCode());
        return hashCode;
    }

    public MemoryConfiguration clone() {
        try {
            return (MemoryConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MemoryConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

