/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockagent.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.bedrockagent.model.IngestionJobFilter;
import com.amazonaws.services.bedrockagent.model.IngestionJobSortBy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListIngestionJobsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String dataSourceId;
    private List<IngestionJobFilter> filters;
    private String knowledgeBaseId;
    private Integer maxResults;
    private String nextToken;
    private IngestionJobSortBy sortBy;

    public void setDataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public ListIngestionJobsRequest withDataSourceId(String dataSourceId) {
        this.setDataSourceId(dataSourceId);
        return this;
    }

    public List<IngestionJobFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<IngestionJobFilter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<IngestionJobFilter>(filters);
    }

    public ListIngestionJobsRequest withFilters(IngestionJobFilter ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<IngestionJobFilter>(filters.length));
        }
        for (IngestionJobFilter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public ListIngestionJobsRequest withFilters(Collection<IngestionJobFilter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setKnowledgeBaseId(String knowledgeBaseId) {
        this.knowledgeBaseId = knowledgeBaseId;
    }

    public String getKnowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public ListIngestionJobsRequest withKnowledgeBaseId(String knowledgeBaseId) {
        this.setKnowledgeBaseId(knowledgeBaseId);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListIngestionJobsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListIngestionJobsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setSortBy(IngestionJobSortBy sortBy) {
        this.sortBy = sortBy;
    }

    public IngestionJobSortBy getSortBy() {
        return this.sortBy;
    }

    public ListIngestionJobsRequest withSortBy(IngestionJobSortBy sortBy) {
        this.setSortBy(sortBy);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDataSourceId() != null) {
            sb.append("DataSourceId: ").append(this.getDataSourceId()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getKnowledgeBaseId() != null) {
            sb.append("KnowledgeBaseId: ").append(this.getKnowledgeBaseId()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getSortBy() != null) {
            sb.append("SortBy: ").append(this.getSortBy());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIngestionJobsRequest)) {
            return false;
        }
        ListIngestionJobsRequest other = (ListIngestionJobsRequest)obj;
        if (other.getDataSourceId() == null ^ this.getDataSourceId() == null) {
            return false;
        }
        if (other.getDataSourceId() != null && !other.getDataSourceId().equals(this.getDataSourceId())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getKnowledgeBaseId() == null ^ this.getKnowledgeBaseId() == null) {
            return false;
        }
        if (other.getKnowledgeBaseId() != null && !other.getKnowledgeBaseId().equals(this.getKnowledgeBaseId())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getSortBy() == null ^ this.getSortBy() == null) {
            return false;
        }
        return other.getSortBy() == null || other.getSortBy().equals(this.getSortBy());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDataSourceId() == null ? 0 : this.getDataSourceId().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getKnowledgeBaseId() == null ? 0 : this.getKnowledgeBaseId().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getSortBy() == null ? 0 : this.getSortBy().hashCode());
        return hashCode;
    }

    public ListIngestionJobsRequest clone() {
        return (ListIngestionJobsRequest)super.clone();
    }
}

