/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockagent.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrockagent.model.FlowNodeConfiguration;
import com.amazonaws.services.bedrockagent.model.FlowNodeInput;
import com.amazonaws.services.bedrockagent.model.FlowNodeOutput;
import com.amazonaws.services.bedrockagent.model.FlowNodeType;
import com.amazonaws.services.bedrockagent.model.transform.FlowNodeMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FlowNode
implements Serializable,
Cloneable,
StructuredPojo {
    private FlowNodeConfiguration configuration;
    private List<FlowNodeInput> inputs;
    private String name;
    private List<FlowNodeOutput> outputs;
    private String type;

    public void setConfiguration(FlowNodeConfiguration configuration) {
        this.configuration = configuration;
    }

    public FlowNodeConfiguration getConfiguration() {
        return this.configuration;
    }

    public FlowNode withConfiguration(FlowNodeConfiguration configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    public List<FlowNodeInput> getInputs() {
        return this.inputs;
    }

    public void setInputs(Collection<FlowNodeInput> inputs) {
        if (inputs == null) {
            this.inputs = null;
            return;
        }
        this.inputs = new ArrayList<FlowNodeInput>(inputs);
    }

    public FlowNode withInputs(FlowNodeInput ... inputs) {
        if (this.inputs == null) {
            this.setInputs(new ArrayList<FlowNodeInput>(inputs.length));
        }
        for (FlowNodeInput ele : inputs) {
            this.inputs.add(ele);
        }
        return this;
    }

    public FlowNode withInputs(Collection<FlowNodeInput> inputs) {
        this.setInputs(inputs);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public FlowNode withName(String name) {
        this.setName(name);
        return this;
    }

    public List<FlowNodeOutput> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Collection<FlowNodeOutput> outputs) {
        if (outputs == null) {
            this.outputs = null;
            return;
        }
        this.outputs = new ArrayList<FlowNodeOutput>(outputs);
    }

    public FlowNode withOutputs(FlowNodeOutput ... outputs) {
        if (this.outputs == null) {
            this.setOutputs(new ArrayList<FlowNodeOutput>(outputs.length));
        }
        for (FlowNodeOutput ele : outputs) {
            this.outputs.add(ele);
        }
        return this;
    }

    public FlowNode withOutputs(Collection<FlowNodeOutput> outputs) {
        this.setOutputs(outputs);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public FlowNode withType(String type) {
        this.setType(type);
        return this;
    }

    public FlowNode withType(FlowNodeType type) {
        this.type = type.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConfiguration() != null) {
            sb.append("Configuration: ").append(this.getConfiguration()).append(",");
        }
        if (this.getInputs() != null) {
            sb.append("Inputs: ").append(this.getInputs()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getOutputs() != null) {
            sb.append("Outputs: ").append(this.getOutputs()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowNode)) {
            return false;
        }
        FlowNode other = (FlowNode)obj;
        if (other.getConfiguration() == null ^ this.getConfiguration() == null) {
            return false;
        }
        if (other.getConfiguration() != null && !other.getConfiguration().equals(this.getConfiguration())) {
            return false;
        }
        if (other.getInputs() == null ^ this.getInputs() == null) {
            return false;
        }
        if (other.getInputs() != null && !other.getInputs().equals(this.getInputs())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getOutputs() == null ^ this.getOutputs() == null) {
            return false;
        }
        if (other.getOutputs() != null && !other.getOutputs().equals(this.getOutputs())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        return other.getType() == null || other.getType().equals(this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getInputs() == null ? 0 : this.getInputs().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getOutputs() == null ? 0 : this.getOutputs().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        return hashCode;
    }

    public FlowNode clone() {
        try {
            return (FlowNode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FlowNodeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

