/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrock.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.bedrock.model.transform.S3ConfigMarshaller;
import java.io.Serializable;

public class S3Config
implements Serializable,
Cloneable,
StructuredPojo {
    private String bucketName;
    private String keyPrefix;

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public S3Config withBucketName(String bucketName) {
        this.setBucketName(bucketName);
        return this;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public S3Config withKeyPrefix(String keyPrefix) {
        this.setKeyPrefix(keyPrefix);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucketName() != null) {
            sb.append("BucketName: ").append(this.getBucketName()).append(",");
        }
        if (this.getKeyPrefix() != null) {
            sb.append("KeyPrefix: ").append(this.getKeyPrefix());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Config)) {
            return false;
        }
        S3Config other = (S3Config)obj;
        if (other.getBucketName() == null ^ this.getBucketName() == null) {
            return false;
        }
        if (other.getBucketName() != null && !other.getBucketName().equals(this.getBucketName())) {
            return false;
        }
        if (other.getKeyPrefix() == null ^ this.getKeyPrefix() == null) {
            return false;
        }
        return other.getKeyPrefix() == null || other.getKeyPrefix().equals(this.getKeyPrefix());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucketName() == null ? 0 : this.getBucketName().hashCode());
        hashCode = 31 * hashCode + (this.getKeyPrefix() == null ? 0 : this.getKeyPrefix().hashCode());
        return hashCode;
    }

    public S3Config clone() {
        try {
            return (S3Config)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

