/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.batch.model.KeyValuePair;
import com.amazonaws.services.batch.model.ResourceRequirement;
import com.amazonaws.services.batch.model.transform.TaskContainerOverridesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TaskContainerOverrides
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> command;
    private List<KeyValuePair> environment;
    private String name;
    private List<ResourceRequirement> resourceRequirements;

    public List<String> getCommand() {
        return this.command;
    }

    public void setCommand(Collection<String> command) {
        if (command == null) {
            this.command = null;
            return;
        }
        this.command = new ArrayList<String>(command);
    }

    public TaskContainerOverrides withCommand(String ... command) {
        if (this.command == null) {
            this.setCommand(new ArrayList<String>(command.length));
        }
        for (String ele : command) {
            this.command.add(ele);
        }
        return this;
    }

    public TaskContainerOverrides withCommand(Collection<String> command) {
        this.setCommand(command);
        return this;
    }

    public List<KeyValuePair> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Collection<KeyValuePair> environment) {
        if (environment == null) {
            this.environment = null;
            return;
        }
        this.environment = new ArrayList<KeyValuePair>(environment);
    }

    public TaskContainerOverrides withEnvironment(KeyValuePair ... environment) {
        if (this.environment == null) {
            this.setEnvironment(new ArrayList<KeyValuePair>(environment.length));
        }
        for (KeyValuePair ele : environment) {
            this.environment.add(ele);
        }
        return this;
    }

    public TaskContainerOverrides withEnvironment(Collection<KeyValuePair> environment) {
        this.setEnvironment(environment);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public TaskContainerOverrides withName(String name) {
        this.setName(name);
        return this;
    }

    public List<ResourceRequirement> getResourceRequirements() {
        return this.resourceRequirements;
    }

    public void setResourceRequirements(Collection<ResourceRequirement> resourceRequirements) {
        if (resourceRequirements == null) {
            this.resourceRequirements = null;
            return;
        }
        this.resourceRequirements = new ArrayList<ResourceRequirement>(resourceRequirements);
    }

    public TaskContainerOverrides withResourceRequirements(ResourceRequirement ... resourceRequirements) {
        if (this.resourceRequirements == null) {
            this.setResourceRequirements(new ArrayList<ResourceRequirement>(resourceRequirements.length));
        }
        for (ResourceRequirement ele : resourceRequirements) {
            this.resourceRequirements.add(ele);
        }
        return this;
    }

    public TaskContainerOverrides withResourceRequirements(Collection<ResourceRequirement> resourceRequirements) {
        this.setResourceRequirements(resourceRequirements);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCommand() != null) {
            sb.append("Command: ").append(this.getCommand()).append(",");
        }
        if (this.getEnvironment() != null) {
            sb.append("Environment: ").append(this.getEnvironment()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getResourceRequirements() != null) {
            sb.append("ResourceRequirements: ").append(this.getResourceRequirements());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskContainerOverrides)) {
            return false;
        }
        TaskContainerOverrides other = (TaskContainerOverrides)obj;
        if (other.getCommand() == null ^ this.getCommand() == null) {
            return false;
        }
        if (other.getCommand() != null && !other.getCommand().equals(this.getCommand())) {
            return false;
        }
        if (other.getEnvironment() == null ^ this.getEnvironment() == null) {
            return false;
        }
        if (other.getEnvironment() != null && !other.getEnvironment().equals(this.getEnvironment())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getResourceRequirements() == null ^ this.getResourceRequirements() == null) {
            return false;
        }
        return other.getResourceRequirements() == null || other.getResourceRequirements().equals(this.getResourceRequirements());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCommand() == null ? 0 : this.getCommand().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironment() == null ? 0 : this.getEnvironment().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getResourceRequirements() == null ? 0 : this.getResourceRequirements().hashCode());
        return hashCode;
    }

    public TaskContainerOverrides clone() {
        try {
            return (TaskContainerOverrides)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TaskContainerOverridesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

