/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.batch.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * An object that represents an Batch job.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/batch-2016-08-10/JobDetail" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class JobDetail implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the job.
     * </p>
     */
    private String jobArn;
    /**
     * <p>
     * The job name.
     * </p>
     */
    private String jobName;
    /**
     * <p>
     * The job ID.
     * </p>
     */
    private String jobId;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the job queue that the job is associated with.
     * </p>
     */
    private String jobQueue;
    /**
     * <p>
     * The current status for the job.
     * </p>
     * <note>
     * <p>
     * If your jobs don't progress to <code>STARTING</code>, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#job_stuck_in_runnable">Jobs stuck
     * in RUNNABLE status</a> in the troubleshooting section of the <i>Batch User Guide</i>.
     * </p>
     * </note>
     */
    private String status;
    /**
     * <p>
     * The share identifier for the job.
     * </p>
     */
    private String shareIdentifier;
    /**
     * <p>
     * The scheduling policy of the job definition. This only affects jobs in job queues with a fair share policy. Jobs
     * with a higher scheduling priority are scheduled before jobs with a lower scheduling priority.
     * </p>
     */
    private Integer schedulingPriority;
    /**
     * <p>
     * A list of job attempts that are associated with this job.
     * </p>
     */
    private java.util.List<AttemptDetail> attempts;
    /**
     * <p>
     * A short, human-readable string to provide more details for the current status of the job.
     * </p>
     */
    private String statusReason;
    /**
     * <p>
     * The Unix timestamp (in milliseconds) for when the job was created. For non-array jobs and parent array jobs, this
     * is when the job entered the <code>SUBMITTED</code> state. This is specifically at the time <a>SubmitJob</a> was
     * called. For array child jobs, this is when the child job was spawned by its parent and entered the
     * <code>PENDING</code> state.
     * </p>
     */
    private Long createdAt;
    /**
     * <p>
     * The retry strategy to use for this job if an attempt fails.
     * </p>
     */
    private RetryStrategy retryStrategy;
    /**
     * <p>
     * The Unix timestamp (in milliseconds) for when the job was started. More specifically, it's when the job
     * transitioned from the <code>STARTING</code> state to the <code>RUNNING</code> state. This parameter isn't
     * provided for child jobs of array jobs or multi-node parallel jobs.
     * </p>
     */
    private Long startedAt;
    /**
     * <p>
     * The Unix timestamp (in milliseconds) for when the job was stopped. More specifically, it's when the job
     * transitioned from the <code>RUNNING</code> state to a terminal state, such as <code>SUCCEEDED</code> or
     * <code>FAILED</code>.
     * </p>
     */
    private Long stoppedAt;
    /**
     * <p>
     * A list of job IDs that this job depends on.
     * </p>
     */
    private java.util.List<JobDependency> dependsOn;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the job definition that this job uses.
     * </p>
     */
    private String jobDefinition;
    /**
     * <p>
     * Additional parameters that are passed to the job that replace parameter substitution placeholders or override any
     * corresponding parameter defaults from the job definition.
     * </p>
     */
    private java.util.Map<String, String> parameters;
    /**
     * <p>
     * An object that represents the details for the container that's associated with the job.
     * </p>
     */
    private ContainerDetail container;
    /**
     * <p>
     * An object that represents the details of a node that's associated with a multi-node parallel job.
     * </p>
     */
    private NodeDetails nodeDetails;
    /**
     * <p>
     * An object that represents the node properties of a multi-node parallel job.
     * </p>
     * <note>
     * <p>
     * This isn't applicable to jobs that are running on Fargate resources.
     * </p>
     * </note>
     */
    private NodeProperties nodeProperties;
    /**
     * <p>
     * The array properties of the job, if it's an array job.
     * </p>
     */
    private ArrayPropertiesDetail arrayProperties;
    /**
     * <p>
     * The timeout configuration for the job.
     * </p>
     */
    private JobTimeout timeout;
    /**
     * <p>
     * The tags that are applied to the job.
     * </p>
     */
    private java.util.Map<String, String> tags;
    /**
     * <p>
     * Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task. If
     * no value is specified, the tags aren't propagated. Tags can only be propagated to the tasks when the tasks are
     * created. For tags with the same name, job tags are given priority over job definitions tags. If the total number
     * of combined tags from the job and job definition is over 50, the job is moved to the <code>FAILED</code> state.
     * </p>
     */
    private Boolean propagateTags;
    /**
     * <p>
     * The platform capabilities required by the job definition. If no value is specified, it defaults to
     * <code>EC2</code>. Jobs run on Fargate resources specify <code>FARGATE</code>.
     * </p>
     */
    private java.util.List<String> platformCapabilities;
    /**
     * <p>
     * An object with various properties that are specific to Amazon EKS based jobs. Only one of <code>container</code>,
     * <code>eksProperties</code>, or <code>nodeDetails</code> is specified.
     * </p>
     */
    private EksPropertiesDetail eksProperties;
    /**
     * <p>
     * A list of job attempts that are associated with this job.
     * </p>
     */
    private java.util.List<EksAttemptDetail> eksAttempts;
    /**
     * <p>
     * Indicates whether the job is canceled.
     * </p>
     */
    private Boolean isCancelled;
    /**
     * <p>
     * Indicates whether the job is terminated.
     * </p>
     */
    private Boolean isTerminated;

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the job.
     * </p>
     * 
     * @param jobArn
     *        The Amazon Resource Name (ARN) of the job.
     */

    public void setJobArn(String jobArn) {
        this.jobArn = jobArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the job.
     */

    public String getJobArn() {
        return this.jobArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the job.
     * </p>
     * 
     * @param jobArn
     *        The Amazon Resource Name (ARN) of the job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail withJobArn(String jobArn) {
        setJobArn(jobArn);
        return this;
    }

    /**
     * <p>
     * The job name.
     * </p>
     * 
     * @param jobName
     *        The job name.
     */

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    /**
     * <p>
     * The job name.
     * </p>
     * 
     * @return The job name.
     */

    public String getJobName() {
        return this.jobName;
    }

    /**
     * <p>
     * The job name.
     * </p>
     * 
     * @param jobName
     *        The job name.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail withJobName(String jobName) {
        setJobName(jobName);
        return this;
    }

    /**
     * <p>
     * The job ID.
     * </p>
     * 
     * @param jobId
     *        The job ID.
     */

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    /**
     * <p>
     * The job ID.
     * </p>
     * 
     * @return The job ID.
     */

    public String getJobId() {
        return this.jobId;
    }

    /**
     * <p>
     * The job ID.
     * </p>
     * 
     * @param jobId
     *        The job ID.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail withJobId(String jobId) {
        setJobId(jobId);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the job queue that the job is associated with.
     * </p>
     * 
     * @param jobQueue
     *        The Amazon Resource Name (ARN) of the job queue that the job is associated with.
     */

    public void setJobQueue(String jobQueue) {
        this.jobQueue = jobQueue;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the job queue that the job is associated with.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the job queue that the job is associated with.
     */

    public String getJobQueue() {
        return this.jobQueue;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the job queue that the job is associated with.
     * </p>
     * 
     * @param jobQueue
     *        The Amazon Resource Name (ARN) of the job queue that the job is associated with.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail withJobQueue(String jobQueue) {
        setJobQueue(jobQueue);
        return this;
    }

    /**
     * <p>
     * The current status for the job.
     * </p>
     * <note>
     * <p>
     * If your jobs don't progress to <code>STARTING</code>, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#job_stuck_in_runnable">Jobs stuck
     * in RUNNABLE status</a> in the troubleshooting section of the <i>Batch User Guide</i>.
     * </p>
     * </note>
     * 
     * @param status
     *        The current status for the job.</p> <note>
     *        <p>
     *        If your jobs don't progress to <code>STARTING</code>, see <a
     *        href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#job_stuck_in_runnable">Jobs
     *        stuck in RUNNABLE status</a> in the troubleshooting section of the <i>Batch User Guide</i>.
     *        </p>
     * @see JobStatus
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * The current status for the job.
     * </p>
     * <note>
     * <p>
     * If your jobs don't progress to <code>STARTING</code>, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#job_stuck_in_runnable">Jobs stuck
     * in RUNNABLE status</a> in the troubleshooting section of the <i>Batch User Guide</i>.
     * </p>
     * </note>
     * 
     * @return The current status for the job.</p> <note>
     *         <p>
     *         If your jobs don't progress to <code>STARTING</code>, see <a
     *         href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#job_stuck_in_runnable">Jobs
     *         stuck in RUNNABLE status</a> in the troubleshooting section of the <i>Batch User Guide</i>.
     *         </p>
     * @see JobStatus
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * The current status for the job.
     * </p>
     * <note>
     * <p>
     * If your jobs don't progress to <code>STARTING</code>, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#job_stuck_in_runnable">Jobs stuck
     * in RUNNABLE status</a> in the troubleshooting section of the <i>Batch User Guide</i>.
     * </p>
     * </note>
     * 
     * @param status
     *        The current status for the job.</p> <note>
     *        <p>
     *        If your jobs don't progress to <code>STARTING</code>, see <a
     *        href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#job_stuck_in_runnable">Jobs
     *        stuck in RUNNABLE status</a> in the troubleshooting section of the <i>Batch User Guide</i>.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see JobStatus
     */

    public JobDetail withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * The current status for the job.
     * </p>
     * <note>
     * <p>
     * If your jobs don't progress to <code>STARTING</code>, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#job_stuck_in_runnable">Jobs stuck
     * in RUNNABLE status</a> in the troubleshooting section of the <i>Batch User Guide</i>.
     * </p>
     * </note>
     * 
     * @param status
     *        The current status for the job.</p> <note>
     *        <p>
     *        If your jobs don't progress to <code>STARTING</code>, see <a
     *        href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#job_stuck_in_runnable">Jobs
     *        stuck in RUNNABLE status</a> in the troubleshooting section of the <i>Batch User Guide</i>.
     *        </p>
     * @see JobStatus
     */

    public void setStatus(JobStatus status) {
        withStatus(status);
    }

    /**
     * <p>
     * The current status for the job.
     * </p>
     * <note>
     * <p>
     * If your jobs don't progress to <code>STARTING</code>, see <a
     * href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#job_stuck_in_runnable">Jobs stuck
     * in RUNNABLE status</a> in the troubleshooting section of the <i>Batch User Guide</i>.
     * </p>
     * </note>
     * 
     * @param status
     *        The current status for the job.</p> <note>
     *        <p>
     *        If your jobs don't progress to <code>STARTING</code>, see <a
     *        href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#job_stuck_in_runnable">Jobs
     *        stuck in RUNNABLE status</a> in the troubleshooting section of the <i>Batch User Guide</i>.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see JobStatus
     */

    public JobDetail withStatus(JobStatus status) {
        this.status = status.toString();
        return this;
    }

    /**
     * <p>
     * The share identifier for the job.
     * </p>
     * 
     * @param shareIdentifier
     *        The share identifier for the job.
     */

    public void setShareIdentifier(String shareIdentifier) {
        this.shareIdentifier = shareIdentifier;
    }

    /**
     * <p>
     * The share identifier for the job.
     * </p>
     * 
     * @return The share identifier for the job.
     */

    public String getShareIdentifier() {
        return this.shareIdentifier;
    }

    /**
     * <p>
     * The share identifier for the job.
     * </p>
     * 
     * @param shareIdentifier
     *        The share identifier for the job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail withShareIdentifier(String shareIdentifier) {
        setShareIdentifier(shareIdentifier);
        return this;
    }

    /**
     * <p>
     * The scheduling policy of the job definition. This only affects jobs in job queues with a fair share policy. Jobs
     * with a higher scheduling priority are scheduled before jobs with a lower scheduling priority.
     * </p>
     * 
     * @param schedulingPriority
     *        The scheduling policy of the job definition. This only affects jobs in job queues with a fair share
     *        policy. Jobs with a higher scheduling priority are scheduled before jobs with a lower scheduling priority.
     */

    public void setSchedulingPriority(Integer schedulingPriority) {
        this.schedulingPriority = schedulingPriority;
    }

    /**
     * <p>
     * The scheduling policy of the job definition. This only affects jobs in job queues with a fair share policy. Jobs
     * with a higher scheduling priority are scheduled before jobs with a lower scheduling priority.
     * </p>
     * 
     * @return The scheduling policy of the job definition. This only affects jobs in job queues with a fair share
     *         policy. Jobs with a higher scheduling priority are scheduled before jobs with a lower scheduling
     *         priority.
     */

    public Integer getSchedulingPriority() {
        return this.schedulingPriority;
    }

    /**
     * <p>
     * The scheduling policy of the job definition. This only affects jobs in job queues with a fair share policy. Jobs
     * with a higher scheduling priority are scheduled before jobs with a lower scheduling priority.
     * </p>
     * 
     * @param schedulingPriority
     *        The scheduling policy of the job definition. This only affects jobs in job queues with a fair share
     *        policy. Jobs with a higher scheduling priority are scheduled before jobs with a lower scheduling priority.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail withSchedulingPriority(Integer schedulingPriority) {
        setSchedulingPriority(schedulingPriority);
        return this;
    }

    /**
     * <p>
     * A list of job attempts that are associated with this job.
     * </p>
     * 
     * @return A list of job attempts that are associated with this job.
     */

    public java.util.List<AttemptDetail> getAttempts() {
        return attempts;
    }

    /**
     * <p>
     * A list of job attempts that are associated with this job.
     * </p>
     * 
     * @param attempts
     *        A list of job attempts that are associated with this job.
     */

    public void setAttempts(java.util.Collection<AttemptDetail> attempts) {
        if (attempts == null) {
            this.attempts = null;
            return;
        }

        this.attempts = new java.util.ArrayList<AttemptDetail>(attempts);
    }

    /**
     * <p>
     * A list of job attempts that are associated with this job.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setAttempts(java.util.Collection)} or {@link #withAttempts(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param attempts
     *        A list of job attempts that are associated with this job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail withAttempts(AttemptDetail... attempts) {
        if (this.attempts == null) {
            setAttempts(new java.util.ArrayList<AttemptDetail>(attempts.length));
        }
        for (AttemptDetail ele : attempts) {
            this.attempts.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of job attempts that are associated with this job.
     * </p>
     * 
     * @param attempts
     *        A list of job attempts that are associated with this job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail withAttempts(java.util.Collection<AttemptDetail> attempts) {
        setAttempts(attempts);
        return this;
    }

    /**
     * <p>
     * A short, human-readable string to provide more details for the current status of the job.
     * </p>
     * 
     * @param statusReason
     *        A short, human-readable string to provide more details for the current status of the job.
     */

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    /**
     * <p>
     * A short, human-readable string to provide more details for the current status of the job.
     * </p>
     * 
     * @return A short, human-readable string to provide more details for the current status of the job.
     */

    public String getStatusReason() {
        return this.statusReason;
    }

    /**
     * <p>
     * A short, human-readable string to provide more details for the current status of the job.
     * </p>
     * 
     * @param statusReason
     *        A short, human-readable string to provide more details for the current status of the job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail withStatusReason(String statusReason) {
        setStatusReason(statusReason);
        return this;
    }

    /**
     * <p>
     * The Unix timestamp (in milliseconds) for when the job was created. For non-array jobs and parent array jobs, this
     * is when the job entered the <code>SUBMITTED</code> state. This is specifically at the time <a>SubmitJob</a> was
     * called. For array child jobs, this is when the child job was spawned by its parent and entered the
     * <code>PENDING</code> state.
     * </p>
     * 
     * @param createdAt
     *        The Unix timestamp (in milliseconds) for when the job was created. For non-array jobs and parent array
     *        jobs, this is when the job entered the <code>SUBMITTED</code> state. This is specifically at the time
     *        <a>SubmitJob</a> was called. For array child jobs, this is when the child job was spawned by its parent
     *        and entered the <code>PENDING</code> state.
     */

    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    /**
     * <p>
     * The Unix timestamp (in milliseconds) for when the job was created. For non-array jobs and parent array jobs, this
     * is when the job entered the <code>SUBMITTED</code> state. This is specifically at the time <a>SubmitJob</a> was
     * called. For array child jobs, this is when the child job was spawned by its parent and entered the
     * <code>PENDING</code> state.
     * </p>
     * 
     * @return The Unix timestamp (in milliseconds) for when the job was created. For non-array jobs and parent array
     *         jobs, this is when the job entered the <code>SUBMITTED</code> state. This is specifically at the time
     *         <a>SubmitJob</a> was called. For array child jobs, this is when the child job was spawned by its parent
     *         and entered the <code>PENDING</code> state.
     */

    public Long getCreatedAt() {
        return this.createdAt;
    }

    /**
     * <p>
     * The Unix timestamp (in milliseconds) for when the job was created. For non-array jobs and parent array jobs, this
     * is when the job entered the <code>SUBMITTED</code> state. This is specifically at the time <a>SubmitJob</a> was
     * called. For array child jobs, this is when the child job was spawned by its parent and entered the
     * <code>PENDING</code> state.
     * </p>
     * 
     * @param createdAt
     *        The Unix timestamp (in milliseconds) for when the job was created. For non-array jobs and parent array
     *        jobs, this is when the job entered the <code>SUBMITTED</code> state. This is specifically at the time
     *        <a>SubmitJob</a> was called. For array child jobs, this is when the child job was spawned by its parent
     *        and entered the <code>PENDING</code> state.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail withCreatedAt(Long createdAt) {
        setCreatedAt(createdAt);
        return this;
    }

    /**
     * <p>
     * The retry strategy to use for this job if an attempt fails.
     * </p>
     * 
     * @param retryStrategy
     *        The retry strategy to use for this job if an attempt fails.
     */

    public void setRetryStrategy(RetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
    }

    /**
     * <p>
     * The retry strategy to use for this job if an attempt fails.
     * </p>
     * 
     * @return The retry strategy to use for this job if an attempt fails.
     */

    public RetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    /**
     * <p>
     * The retry strategy to use for this job if an attempt fails.
     * </p>
     * 
     * @param retryStrategy
     *        The retry strategy to use for this job if an attempt fails.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail withRetryStrategy(RetryStrategy retryStrategy) {
        setRetryStrategy(retryStrategy);
        return this;
    }

    /**
     * <p>
     * The Unix timestamp (in milliseconds) for when the job was started. More specifically, it's when the job
     * transitioned from the <code>STARTING</code> state to the <code>RUNNING</code> state. This parameter isn't
     * provided for child jobs of array jobs or multi-node parallel jobs.
     * </p>
     * 
     * @param startedAt
     *        The Unix timestamp (in milliseconds) for when the job was started. More specifically, it's when the job
     *        transitioned from the <code>STARTING</code> state to the <code>RUNNING</code> state. This parameter isn't
     *        provided for child jobs of array jobs or multi-node parallel jobs.
     */

    public void setStartedAt(Long startedAt) {
        this.startedAt = startedAt;
    }

    /**
     * <p>
     * The Unix timestamp (in milliseconds) for when the job was started. More specifically, it's when the job
     * transitioned from the <code>STARTING</code> state to the <code>RUNNING</code> state. This parameter isn't
     * provided for child jobs of array jobs or multi-node parallel jobs.
     * </p>
     * 
     * @return The Unix timestamp (in milliseconds) for when the job was started. More specifically, it's when the job
     *         transitioned from the <code>STARTING</code> state to the <code>RUNNING</code> state. This parameter isn't
     *         provided for child jobs of array jobs or multi-node parallel jobs.
     */

    public Long getStartedAt() {
        return this.startedAt;
    }

    /**
     * <p>
     * The Unix timestamp (in milliseconds) for when the job was started. More specifically, it's when the job
     * transitioned from the <code>STARTING</code> state to the <code>RUNNING</code> state. This parameter isn't
     * provided for child jobs of array jobs or multi-node parallel jobs.
     * </p>
     * 
     * @param startedAt
     *        The Unix timestamp (in milliseconds) for when the job was started. More specifically, it's when the job
     *        transitioned from the <code>STARTING</code> state to the <code>RUNNING</code> state. This parameter isn't
     *        provided for child jobs of array jobs or multi-node parallel jobs.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail withStartedAt(Long startedAt) {
        setStartedAt(startedAt);
        return this;
    }

    /**
     * <p>
     * The Unix timestamp (in milliseconds) for when the job was stopped. More specifically, it's when the job
     * transitioned from the <code>RUNNING</code> state to a terminal state, such as <code>SUCCEEDED</code> or
     * <code>FAILED</code>.
     * </p>
     * 
     * @param stoppedAt
     *        The Unix timestamp (in milliseconds) for when the job was stopped. More specifically, it's when the job
     *        transitioned from the <code>RUNNING</code> state to a terminal state, such as <code>SUCCEEDED</code> or
     *        <code>FAILED</code>.
     */

    public void setStoppedAt(Long stoppedAt) {
        this.stoppedAt = stoppedAt;
    }

    /**
     * <p>
     * The Unix timestamp (in milliseconds) for when the job was stopped. More specifically, it's when the job
     * transitioned from the <code>RUNNING</code> state to a terminal state, such as <code>SUCCEEDED</code> or
     * <code>FAILED</code>.
     * </p>
     * 
     * @return The Unix timestamp (in milliseconds) for when the job was stopped. More specifically, it's when the job
     *         transitioned from the <code>RUNNING</code> state to a terminal state, such as <code>SUCCEEDED</code> or
     *         <code>FAILED</code>.
     */

    public Long getStoppedAt() {
        return this.stoppedAt;
    }

    /**
     * <p>
     * The Unix timestamp (in milliseconds) for when the job was stopped. More specifically, it's when the job
     * transitioned from the <code>RUNNING</code> state to a terminal state, such as <code>SUCCEEDED</code> or
     * <code>FAILED</code>.
     * </p>
     * 
     * @param stoppedAt
     *        The Unix timestamp (in milliseconds) for when the job was stopped. More specifically, it's when the job
     *        transitioned from the <code>RUNNING</code> state to a terminal state, such as <code>SUCCEEDED</code> or
     *        <code>FAILED</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail withStoppedAt(Long stoppedAt) {
        setStoppedAt(stoppedAt);
        return this;
    }

    /**
     * <p>
     * A list of job IDs that this job depends on.
     * </p>
     * 
     * @return A list of job IDs that this job depends on.
     */

    public java.util.List<JobDependency> getDependsOn() {
        return dependsOn;
    }

    /**
     * <p>
     * A list of job IDs that this job depends on.
     * </p>
     * 
     * @param dependsOn
     *        A list of job IDs that this job depends on.
     */

    public void setDependsOn(java.util.Collection<JobDependency> dependsOn) {
        if (dependsOn == null) {
            this.dependsOn = null;
            return;
        }

        this.dependsOn = new java.util.ArrayList<JobDependency>(dependsOn);
    }

    /**
     * <p>
     * A list of job IDs that this job depends on.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setDependsOn(java.util.Collection)} or {@link #withDependsOn(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param dependsOn
     *        A list of job IDs that this job depends on.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail withDependsOn(JobDependency... dependsOn) {
        if (this.dependsOn == null) {
            setDependsOn(new java.util.ArrayList<JobDependency>(dependsOn.length));
        }
        for (JobDependency ele : dependsOn) {
            this.dependsOn.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of job IDs that this job depends on.
     * </p>
     * 
     * @param dependsOn
     *        A list of job IDs that this job depends on.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail withDependsOn(java.util.Collection<JobDependency> dependsOn) {
        setDependsOn(dependsOn);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the job definition that this job uses.
     * </p>
     * 
     * @param jobDefinition
     *        The Amazon Resource Name (ARN) of the job definition that this job uses.
     */

    public void setJobDefinition(String jobDefinition) {
        this.jobDefinition = jobDefinition;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the job definition that this job uses.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the job definition that this job uses.
     */

    public String getJobDefinition() {
        return this.jobDefinition;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the job definition that this job uses.
     * </p>
     * 
     * @param jobDefinition
     *        The Amazon Resource Name (ARN) of the job definition that this job uses.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail withJobDefinition(String jobDefinition) {
        setJobDefinition(jobDefinition);
        return this;
    }

    /**
     * <p>
     * Additional parameters that are passed to the job that replace parameter substitution placeholders or override any
     * corresponding parameter defaults from the job definition.
     * </p>
     * 
     * @return Additional parameters that are passed to the job that replace parameter substitution placeholders or
     *         override any corresponding parameter defaults from the job definition.
     */

    public java.util.Map<String, String> getParameters() {
        return parameters;
    }

    /**
     * <p>
     * Additional parameters that are passed to the job that replace parameter substitution placeholders or override any
     * corresponding parameter defaults from the job definition.
     * </p>
     * 
     * @param parameters
     *        Additional parameters that are passed to the job that replace parameter substitution placeholders or
     *        override any corresponding parameter defaults from the job definition.
     */

    public void setParameters(java.util.Map<String, String> parameters) {
        this.parameters = parameters;
    }

    /**
     * <p>
     * Additional parameters that are passed to the job that replace parameter substitution placeholders or override any
     * corresponding parameter defaults from the job definition.
     * </p>
     * 
     * @param parameters
     *        Additional parameters that are passed to the job that replace parameter substitution placeholders or
     *        override any corresponding parameter defaults from the job definition.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail withParameters(java.util.Map<String, String> parameters) {
        setParameters(parameters);
        return this;
    }

    /**
     * Add a single Parameters entry
     *
     * @see JobDetail#withParameters
     * @returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail addParametersEntry(String key, String value) {
        if (null == this.parameters) {
            this.parameters = new java.util.HashMap<String, String>();
        }
        if (this.parameters.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        this.parameters.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into Parameters.
     *
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    /**
     * <p>
     * An object that represents the details for the container that's associated with the job.
     * </p>
     * 
     * @param container
     *        An object that represents the details for the container that's associated with the job.
     */

    public void setContainer(ContainerDetail container) {
        this.container = container;
    }

    /**
     * <p>
     * An object that represents the details for the container that's associated with the job.
     * </p>
     * 
     * @return An object that represents the details for the container that's associated with the job.
     */

    public ContainerDetail getContainer() {
        return this.container;
    }

    /**
     * <p>
     * An object that represents the details for the container that's associated with the job.
     * </p>
     * 
     * @param container
     *        An object that represents the details for the container that's associated with the job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail withContainer(ContainerDetail container) {
        setContainer(container);
        return this;
    }

    /**
     * <p>
     * An object that represents the details of a node that's associated with a multi-node parallel job.
     * </p>
     * 
     * @param nodeDetails
     *        An object that represents the details of a node that's associated with a multi-node parallel job.
     */

    public void setNodeDetails(NodeDetails nodeDetails) {
        this.nodeDetails = nodeDetails;
    }

    /**
     * <p>
     * An object that represents the details of a node that's associated with a multi-node parallel job.
     * </p>
     * 
     * @return An object that represents the details of a node that's associated with a multi-node parallel job.
     */

    public NodeDetails getNodeDetails() {
        return this.nodeDetails;
    }

    /**
     * <p>
     * An object that represents the details of a node that's associated with a multi-node parallel job.
     * </p>
     * 
     * @param nodeDetails
     *        An object that represents the details of a node that's associated with a multi-node parallel job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail withNodeDetails(NodeDetails nodeDetails) {
        setNodeDetails(nodeDetails);
        return this;
    }

    /**
     * <p>
     * An object that represents the node properties of a multi-node parallel job.
     * </p>
     * <note>
     * <p>
     * This isn't applicable to jobs that are running on Fargate resources.
     * </p>
     * </note>
     * 
     * @param nodeProperties
     *        An object that represents the node properties of a multi-node parallel job.</p> <note>
     *        <p>
     *        This isn't applicable to jobs that are running on Fargate resources.
     *        </p>
     */

    public void setNodeProperties(NodeProperties nodeProperties) {
        this.nodeProperties = nodeProperties;
    }

    /**
     * <p>
     * An object that represents the node properties of a multi-node parallel job.
     * </p>
     * <note>
     * <p>
     * This isn't applicable to jobs that are running on Fargate resources.
     * </p>
     * </note>
     * 
     * @return An object that represents the node properties of a multi-node parallel job.</p> <note>
     *         <p>
     *         This isn't applicable to jobs that are running on Fargate resources.
     *         </p>
     */

    public NodeProperties getNodeProperties() {
        return this.nodeProperties;
    }

    /**
     * <p>
     * An object that represents the node properties of a multi-node parallel job.
     * </p>
     * <note>
     * <p>
     * This isn't applicable to jobs that are running on Fargate resources.
     * </p>
     * </note>
     * 
     * @param nodeProperties
     *        An object that represents the node properties of a multi-node parallel job.</p> <note>
     *        <p>
     *        This isn't applicable to jobs that are running on Fargate resources.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail withNodeProperties(NodeProperties nodeProperties) {
        setNodeProperties(nodeProperties);
        return this;
    }

    /**
     * <p>
     * The array properties of the job, if it's an array job.
     * </p>
     * 
     * @param arrayProperties
     *        The array properties of the job, if it's an array job.
     */

    public void setArrayProperties(ArrayPropertiesDetail arrayProperties) {
        this.arrayProperties = arrayProperties;
    }

    /**
     * <p>
     * The array properties of the job, if it's an array job.
     * </p>
     * 
     * @return The array properties of the job, if it's an array job.
     */

    public ArrayPropertiesDetail getArrayProperties() {
        return this.arrayProperties;
    }

    /**
     * <p>
     * The array properties of the job, if it's an array job.
     * </p>
     * 
     * @param arrayProperties
     *        The array properties of the job, if it's an array job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail withArrayProperties(ArrayPropertiesDetail arrayProperties) {
        setArrayProperties(arrayProperties);
        return this;
    }

    /**
     * <p>
     * The timeout configuration for the job.
     * </p>
     * 
     * @param timeout
     *        The timeout configuration for the job.
     */

    public void setTimeout(JobTimeout timeout) {
        this.timeout = timeout;
    }

    /**
     * <p>
     * The timeout configuration for the job.
     * </p>
     * 
     * @return The timeout configuration for the job.
     */

    public JobTimeout getTimeout() {
        return this.timeout;
    }

    /**
     * <p>
     * The timeout configuration for the job.
     * </p>
     * 
     * @param timeout
     *        The timeout configuration for the job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail withTimeout(JobTimeout timeout) {
        setTimeout(timeout);
        return this;
    }

    /**
     * <p>
     * The tags that are applied to the job.
     * </p>
     * 
     * @return The tags that are applied to the job.
     */

    public java.util.Map<String, String> getTags() {
        return tags;
    }

    /**
     * <p>
     * The tags that are applied to the job.
     * </p>
     * 
     * @param tags
     *        The tags that are applied to the job.
     */

    public void setTags(java.util.Map<String, String> tags) {
        this.tags = tags;
    }

    /**
     * <p>
     * The tags that are applied to the job.
     * </p>
     * 
     * @param tags
     *        The tags that are applied to the job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail withTags(java.util.Map<String, String> tags) {
        setTags(tags);
        return this;
    }

    /**
     * Add a single Tags entry
     *
     * @see JobDetail#withTags
     * @returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new java.util.HashMap<String, String>();
        }
        if (this.tags.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        this.tags.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into Tags.
     *
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail clearTagsEntries() {
        this.tags = null;
        return this;
    }

    /**
     * <p>
     * Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task. If
     * no value is specified, the tags aren't propagated. Tags can only be propagated to the tasks when the tasks are
     * created. For tags with the same name, job tags are given priority over job definitions tags. If the total number
     * of combined tags from the job and job definition is over 50, the job is moved to the <code>FAILED</code> state.
     * </p>
     * 
     * @param propagateTags
     *        Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS
     *        task. If no value is specified, the tags aren't propagated. Tags can only be propagated to the tasks when
     *        the tasks are created. For tags with the same name, job tags are given priority over job definitions tags.
     *        If the total number of combined tags from the job and job definition is over 50, the job is moved to the
     *        <code>FAILED</code> state.
     */

    public void setPropagateTags(Boolean propagateTags) {
        this.propagateTags = propagateTags;
    }

    /**
     * <p>
     * Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task. If
     * no value is specified, the tags aren't propagated. Tags can only be propagated to the tasks when the tasks are
     * created. For tags with the same name, job tags are given priority over job definitions tags. If the total number
     * of combined tags from the job and job definition is over 50, the job is moved to the <code>FAILED</code> state.
     * </p>
     * 
     * @return Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS
     *         task. If no value is specified, the tags aren't propagated. Tags can only be propagated to the tasks when
     *         the tasks are created. For tags with the same name, job tags are given priority over job definitions
     *         tags. If the total number of combined tags from the job and job definition is over 50, the job is moved
     *         to the <code>FAILED</code> state.
     */

    public Boolean getPropagateTags() {
        return this.propagateTags;
    }

    /**
     * <p>
     * Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task. If
     * no value is specified, the tags aren't propagated. Tags can only be propagated to the tasks when the tasks are
     * created. For tags with the same name, job tags are given priority over job definitions tags. If the total number
     * of combined tags from the job and job definition is over 50, the job is moved to the <code>FAILED</code> state.
     * </p>
     * 
     * @param propagateTags
     *        Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS
     *        task. If no value is specified, the tags aren't propagated. Tags can only be propagated to the tasks when
     *        the tasks are created. For tags with the same name, job tags are given priority over job definitions tags.
     *        If the total number of combined tags from the job and job definition is over 50, the job is moved to the
     *        <code>FAILED</code> state.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail withPropagateTags(Boolean propagateTags) {
        setPropagateTags(propagateTags);
        return this;
    }

    /**
     * <p>
     * Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task. If
     * no value is specified, the tags aren't propagated. Tags can only be propagated to the tasks when the tasks are
     * created. For tags with the same name, job tags are given priority over job definitions tags. If the total number
     * of combined tags from the job and job definition is over 50, the job is moved to the <code>FAILED</code> state.
     * </p>
     * 
     * @return Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS
     *         task. If no value is specified, the tags aren't propagated. Tags can only be propagated to the tasks when
     *         the tasks are created. For tags with the same name, job tags are given priority over job definitions
     *         tags. If the total number of combined tags from the job and job definition is over 50, the job is moved
     *         to the <code>FAILED</code> state.
     */

    public Boolean isPropagateTags() {
        return this.propagateTags;
    }

    /**
     * <p>
     * The platform capabilities required by the job definition. If no value is specified, it defaults to
     * <code>EC2</code>. Jobs run on Fargate resources specify <code>FARGATE</code>.
     * </p>
     * 
     * @return The platform capabilities required by the job definition. If no value is specified, it defaults to
     *         <code>EC2</code>. Jobs run on Fargate resources specify <code>FARGATE</code>.
     * @see PlatformCapability
     */

    public java.util.List<String> getPlatformCapabilities() {
        return platformCapabilities;
    }

    /**
     * <p>
     * The platform capabilities required by the job definition. If no value is specified, it defaults to
     * <code>EC2</code>. Jobs run on Fargate resources specify <code>FARGATE</code>.
     * </p>
     * 
     * @param platformCapabilities
     *        The platform capabilities required by the job definition. If no value is specified, it defaults to
     *        <code>EC2</code>. Jobs run on Fargate resources specify <code>FARGATE</code>.
     * @see PlatformCapability
     */

    public void setPlatformCapabilities(java.util.Collection<String> platformCapabilities) {
        if (platformCapabilities == null) {
            this.platformCapabilities = null;
            return;
        }

        this.platformCapabilities = new java.util.ArrayList<String>(platformCapabilities);
    }

    /**
     * <p>
     * The platform capabilities required by the job definition. If no value is specified, it defaults to
     * <code>EC2</code>. Jobs run on Fargate resources specify <code>FARGATE</code>.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setPlatformCapabilities(java.util.Collection)} or {@link #withPlatformCapabilities(java.util.Collection)}
     * if you want to override the existing values.
     * </p>
     * 
     * @param platformCapabilities
     *        The platform capabilities required by the job definition. If no value is specified, it defaults to
     *        <code>EC2</code>. Jobs run on Fargate resources specify <code>FARGATE</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see PlatformCapability
     */

    public JobDetail withPlatformCapabilities(String... platformCapabilities) {
        if (this.platformCapabilities == null) {
            setPlatformCapabilities(new java.util.ArrayList<String>(platformCapabilities.length));
        }
        for (String ele : platformCapabilities) {
            this.platformCapabilities.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The platform capabilities required by the job definition. If no value is specified, it defaults to
     * <code>EC2</code>. Jobs run on Fargate resources specify <code>FARGATE</code>.
     * </p>
     * 
     * @param platformCapabilities
     *        The platform capabilities required by the job definition. If no value is specified, it defaults to
     *        <code>EC2</code>. Jobs run on Fargate resources specify <code>FARGATE</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see PlatformCapability
     */

    public JobDetail withPlatformCapabilities(java.util.Collection<String> platformCapabilities) {
        setPlatformCapabilities(platformCapabilities);
        return this;
    }

    /**
     * <p>
     * The platform capabilities required by the job definition. If no value is specified, it defaults to
     * <code>EC2</code>. Jobs run on Fargate resources specify <code>FARGATE</code>.
     * </p>
     * 
     * @param platformCapabilities
     *        The platform capabilities required by the job definition. If no value is specified, it defaults to
     *        <code>EC2</code>. Jobs run on Fargate resources specify <code>FARGATE</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see PlatformCapability
     */

    public JobDetail withPlatformCapabilities(PlatformCapability... platformCapabilities) {
        java.util.ArrayList<String> platformCapabilitiesCopy = new java.util.ArrayList<String>(platformCapabilities.length);
        for (PlatformCapability value : platformCapabilities) {
            platformCapabilitiesCopy.add(value.toString());
        }
        if (getPlatformCapabilities() == null) {
            setPlatformCapabilities(platformCapabilitiesCopy);
        } else {
            getPlatformCapabilities().addAll(platformCapabilitiesCopy);
        }
        return this;
    }

    /**
     * <p>
     * An object with various properties that are specific to Amazon EKS based jobs. Only one of <code>container</code>,
     * <code>eksProperties</code>, or <code>nodeDetails</code> is specified.
     * </p>
     * 
     * @param eksProperties
     *        An object with various properties that are specific to Amazon EKS based jobs. Only one of
     *        <code>container</code>, <code>eksProperties</code>, or <code>nodeDetails</code> is specified.
     */

    public void setEksProperties(EksPropertiesDetail eksProperties) {
        this.eksProperties = eksProperties;
    }

    /**
     * <p>
     * An object with various properties that are specific to Amazon EKS based jobs. Only one of <code>container</code>,
     * <code>eksProperties</code>, or <code>nodeDetails</code> is specified.
     * </p>
     * 
     * @return An object with various properties that are specific to Amazon EKS based jobs. Only one of
     *         <code>container</code>, <code>eksProperties</code>, or <code>nodeDetails</code> is specified.
     */

    public EksPropertiesDetail getEksProperties() {
        return this.eksProperties;
    }

    /**
     * <p>
     * An object with various properties that are specific to Amazon EKS based jobs. Only one of <code>container</code>,
     * <code>eksProperties</code>, or <code>nodeDetails</code> is specified.
     * </p>
     * 
     * @param eksProperties
     *        An object with various properties that are specific to Amazon EKS based jobs. Only one of
     *        <code>container</code>, <code>eksProperties</code>, or <code>nodeDetails</code> is specified.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail withEksProperties(EksPropertiesDetail eksProperties) {
        setEksProperties(eksProperties);
        return this;
    }

    /**
     * <p>
     * A list of job attempts that are associated with this job.
     * </p>
     * 
     * @return A list of job attempts that are associated with this job.
     */

    public java.util.List<EksAttemptDetail> getEksAttempts() {
        return eksAttempts;
    }

    /**
     * <p>
     * A list of job attempts that are associated with this job.
     * </p>
     * 
     * @param eksAttempts
     *        A list of job attempts that are associated with this job.
     */

    public void setEksAttempts(java.util.Collection<EksAttemptDetail> eksAttempts) {
        if (eksAttempts == null) {
            this.eksAttempts = null;
            return;
        }

        this.eksAttempts = new java.util.ArrayList<EksAttemptDetail>(eksAttempts);
    }

    /**
     * <p>
     * A list of job attempts that are associated with this job.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setEksAttempts(java.util.Collection)} or {@link #withEksAttempts(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param eksAttempts
     *        A list of job attempts that are associated with this job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail withEksAttempts(EksAttemptDetail... eksAttempts) {
        if (this.eksAttempts == null) {
            setEksAttempts(new java.util.ArrayList<EksAttemptDetail>(eksAttempts.length));
        }
        for (EksAttemptDetail ele : eksAttempts) {
            this.eksAttempts.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of job attempts that are associated with this job.
     * </p>
     * 
     * @param eksAttempts
     *        A list of job attempts that are associated with this job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail withEksAttempts(java.util.Collection<EksAttemptDetail> eksAttempts) {
        setEksAttempts(eksAttempts);
        return this;
    }

    /**
     * <p>
     * Indicates whether the job is canceled.
     * </p>
     * 
     * @param isCancelled
     *        Indicates whether the job is canceled.
     */

    public void setIsCancelled(Boolean isCancelled) {
        this.isCancelled = isCancelled;
    }

    /**
     * <p>
     * Indicates whether the job is canceled.
     * </p>
     * 
     * @return Indicates whether the job is canceled.
     */

    public Boolean getIsCancelled() {
        return this.isCancelled;
    }

    /**
     * <p>
     * Indicates whether the job is canceled.
     * </p>
     * 
     * @param isCancelled
     *        Indicates whether the job is canceled.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail withIsCancelled(Boolean isCancelled) {
        setIsCancelled(isCancelled);
        return this;
    }

    /**
     * <p>
     * Indicates whether the job is canceled.
     * </p>
     * 
     * @return Indicates whether the job is canceled.
     */

    public Boolean isCancelled() {
        return this.isCancelled;
    }

    /**
     * <p>
     * Indicates whether the job is terminated.
     * </p>
     * 
     * @param isTerminated
     *        Indicates whether the job is terminated.
     */

    public void setIsTerminated(Boolean isTerminated) {
        this.isTerminated = isTerminated;
    }

    /**
     * <p>
     * Indicates whether the job is terminated.
     * </p>
     * 
     * @return Indicates whether the job is terminated.
     */

    public Boolean getIsTerminated() {
        return this.isTerminated;
    }

    /**
     * <p>
     * Indicates whether the job is terminated.
     * </p>
     * 
     * @param isTerminated
     *        Indicates whether the job is terminated.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public JobDetail withIsTerminated(Boolean isTerminated) {
        setIsTerminated(isTerminated);
        return this;
    }

    /**
     * <p>
     * Indicates whether the job is terminated.
     * </p>
     * 
     * @return Indicates whether the job is terminated.
     */

    public Boolean isTerminated() {
        return this.isTerminated;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getJobArn() != null)
            sb.append("JobArn: ").append(getJobArn()).append(",");
        if (getJobName() != null)
            sb.append("JobName: ").append(getJobName()).append(",");
        if (getJobId() != null)
            sb.append("JobId: ").append(getJobId()).append(",");
        if (getJobQueue() != null)
            sb.append("JobQueue: ").append(getJobQueue()).append(",");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus()).append(",");
        if (getShareIdentifier() != null)
            sb.append("ShareIdentifier: ").append(getShareIdentifier()).append(",");
        if (getSchedulingPriority() != null)
            sb.append("SchedulingPriority: ").append(getSchedulingPriority()).append(",");
        if (getAttempts() != null)
            sb.append("Attempts: ").append(getAttempts()).append(",");
        if (getStatusReason() != null)
            sb.append("StatusReason: ").append(getStatusReason()).append(",");
        if (getCreatedAt() != null)
            sb.append("CreatedAt: ").append(getCreatedAt()).append(",");
        if (getRetryStrategy() != null)
            sb.append("RetryStrategy: ").append(getRetryStrategy()).append(",");
        if (getStartedAt() != null)
            sb.append("StartedAt: ").append(getStartedAt()).append(",");
        if (getStoppedAt() != null)
            sb.append("StoppedAt: ").append(getStoppedAt()).append(",");
        if (getDependsOn() != null)
            sb.append("DependsOn: ").append(getDependsOn()).append(",");
        if (getJobDefinition() != null)
            sb.append("JobDefinition: ").append(getJobDefinition()).append(",");
        if (getParameters() != null)
            sb.append("Parameters: ").append(getParameters()).append(",");
        if (getContainer() != null)
            sb.append("Container: ").append(getContainer()).append(",");
        if (getNodeDetails() != null)
            sb.append("NodeDetails: ").append(getNodeDetails()).append(",");
        if (getNodeProperties() != null)
            sb.append("NodeProperties: ").append(getNodeProperties()).append(",");
        if (getArrayProperties() != null)
            sb.append("ArrayProperties: ").append(getArrayProperties()).append(",");
        if (getTimeout() != null)
            sb.append("Timeout: ").append(getTimeout()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags()).append(",");
        if (getPropagateTags() != null)
            sb.append("PropagateTags: ").append(getPropagateTags()).append(",");
        if (getPlatformCapabilities() != null)
            sb.append("PlatformCapabilities: ").append(getPlatformCapabilities()).append(",");
        if (getEksProperties() != null)
            sb.append("EksProperties: ").append(getEksProperties()).append(",");
        if (getEksAttempts() != null)
            sb.append("EksAttempts: ").append(getEksAttempts()).append(",");
        if (getIsCancelled() != null)
            sb.append("IsCancelled: ").append(getIsCancelled()).append(",");
        if (getIsTerminated() != null)
            sb.append("IsTerminated: ").append(getIsTerminated());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof JobDetail == false)
            return false;
        JobDetail other = (JobDetail) obj;
        if (other.getJobArn() == null ^ this.getJobArn() == null)
            return false;
        if (other.getJobArn() != null && other.getJobArn().equals(this.getJobArn()) == false)
            return false;
        if (other.getJobName() == null ^ this.getJobName() == null)
            return false;
        if (other.getJobName() != null && other.getJobName().equals(this.getJobName()) == false)
            return false;
        if (other.getJobId() == null ^ this.getJobId() == null)
            return false;
        if (other.getJobId() != null && other.getJobId().equals(this.getJobId()) == false)
            return false;
        if (other.getJobQueue() == null ^ this.getJobQueue() == null)
            return false;
        if (other.getJobQueue() != null && other.getJobQueue().equals(this.getJobQueue()) == false)
            return false;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        if (other.getShareIdentifier() == null ^ this.getShareIdentifier() == null)
            return false;
        if (other.getShareIdentifier() != null && other.getShareIdentifier().equals(this.getShareIdentifier()) == false)
            return false;
        if (other.getSchedulingPriority() == null ^ this.getSchedulingPriority() == null)
            return false;
        if (other.getSchedulingPriority() != null && other.getSchedulingPriority().equals(this.getSchedulingPriority()) == false)
            return false;
        if (other.getAttempts() == null ^ this.getAttempts() == null)
            return false;
        if (other.getAttempts() != null && other.getAttempts().equals(this.getAttempts()) == false)
            return false;
        if (other.getStatusReason() == null ^ this.getStatusReason() == null)
            return false;
        if (other.getStatusReason() != null && other.getStatusReason().equals(this.getStatusReason()) == false)
            return false;
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null)
            return false;
        if (other.getCreatedAt() != null && other.getCreatedAt().equals(this.getCreatedAt()) == false)
            return false;
        if (other.getRetryStrategy() == null ^ this.getRetryStrategy() == null)
            return false;
        if (other.getRetryStrategy() != null && other.getRetryStrategy().equals(this.getRetryStrategy()) == false)
            return false;
        if (other.getStartedAt() == null ^ this.getStartedAt() == null)
            return false;
        if (other.getStartedAt() != null && other.getStartedAt().equals(this.getStartedAt()) == false)
            return false;
        if (other.getStoppedAt() == null ^ this.getStoppedAt() == null)
            return false;
        if (other.getStoppedAt() != null && other.getStoppedAt().equals(this.getStoppedAt()) == false)
            return false;
        if (other.getDependsOn() == null ^ this.getDependsOn() == null)
            return false;
        if (other.getDependsOn() != null && other.getDependsOn().equals(this.getDependsOn()) == false)
            return false;
        if (other.getJobDefinition() == null ^ this.getJobDefinition() == null)
            return false;
        if (other.getJobDefinition() != null && other.getJobDefinition().equals(this.getJobDefinition()) == false)
            return false;
        if (other.getParameters() == null ^ this.getParameters() == null)
            return false;
        if (other.getParameters() != null && other.getParameters().equals(this.getParameters()) == false)
            return false;
        if (other.getContainer() == null ^ this.getContainer() == null)
            return false;
        if (other.getContainer() != null && other.getContainer().equals(this.getContainer()) == false)
            return false;
        if (other.getNodeDetails() == null ^ this.getNodeDetails() == null)
            return false;
        if (other.getNodeDetails() != null && other.getNodeDetails().equals(this.getNodeDetails()) == false)
            return false;
        if (other.getNodeProperties() == null ^ this.getNodeProperties() == null)
            return false;
        if (other.getNodeProperties() != null && other.getNodeProperties().equals(this.getNodeProperties()) == false)
            return false;
        if (other.getArrayProperties() == null ^ this.getArrayProperties() == null)
            return false;
        if (other.getArrayProperties() != null && other.getArrayProperties().equals(this.getArrayProperties()) == false)
            return false;
        if (other.getTimeout() == null ^ this.getTimeout() == null)
            return false;
        if (other.getTimeout() != null && other.getTimeout().equals(this.getTimeout()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        if (other.getPropagateTags() == null ^ this.getPropagateTags() == null)
            return false;
        if (other.getPropagateTags() != null && other.getPropagateTags().equals(this.getPropagateTags()) == false)
            return false;
        if (other.getPlatformCapabilities() == null ^ this.getPlatformCapabilities() == null)
            return false;
        if (other.getPlatformCapabilities() != null && other.getPlatformCapabilities().equals(this.getPlatformCapabilities()) == false)
            return false;
        if (other.getEksProperties() == null ^ this.getEksProperties() == null)
            return false;
        if (other.getEksProperties() != null && other.getEksProperties().equals(this.getEksProperties()) == false)
            return false;
        if (other.getEksAttempts() == null ^ this.getEksAttempts() == null)
            return false;
        if (other.getEksAttempts() != null && other.getEksAttempts().equals(this.getEksAttempts()) == false)
            return false;
        if (other.getIsCancelled() == null ^ this.getIsCancelled() == null)
            return false;
        if (other.getIsCancelled() != null && other.getIsCancelled().equals(this.getIsCancelled()) == false)
            return false;
        if (other.getIsTerminated() == null ^ this.getIsTerminated() == null)
            return false;
        if (other.getIsTerminated() != null && other.getIsTerminated().equals(this.getIsTerminated()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getJobArn() == null) ? 0 : getJobArn().hashCode());
        hashCode = prime * hashCode + ((getJobName() == null) ? 0 : getJobName().hashCode());
        hashCode = prime * hashCode + ((getJobId() == null) ? 0 : getJobId().hashCode());
        hashCode = prime * hashCode + ((getJobQueue() == null) ? 0 : getJobQueue().hashCode());
        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        hashCode = prime * hashCode + ((getShareIdentifier() == null) ? 0 : getShareIdentifier().hashCode());
        hashCode = prime * hashCode + ((getSchedulingPriority() == null) ? 0 : getSchedulingPriority().hashCode());
        hashCode = prime * hashCode + ((getAttempts() == null) ? 0 : getAttempts().hashCode());
        hashCode = prime * hashCode + ((getStatusReason() == null) ? 0 : getStatusReason().hashCode());
        hashCode = prime * hashCode + ((getCreatedAt() == null) ? 0 : getCreatedAt().hashCode());
        hashCode = prime * hashCode + ((getRetryStrategy() == null) ? 0 : getRetryStrategy().hashCode());
        hashCode = prime * hashCode + ((getStartedAt() == null) ? 0 : getStartedAt().hashCode());
        hashCode = prime * hashCode + ((getStoppedAt() == null) ? 0 : getStoppedAt().hashCode());
        hashCode = prime * hashCode + ((getDependsOn() == null) ? 0 : getDependsOn().hashCode());
        hashCode = prime * hashCode + ((getJobDefinition() == null) ? 0 : getJobDefinition().hashCode());
        hashCode = prime * hashCode + ((getParameters() == null) ? 0 : getParameters().hashCode());
        hashCode = prime * hashCode + ((getContainer() == null) ? 0 : getContainer().hashCode());
        hashCode = prime * hashCode + ((getNodeDetails() == null) ? 0 : getNodeDetails().hashCode());
        hashCode = prime * hashCode + ((getNodeProperties() == null) ? 0 : getNodeProperties().hashCode());
        hashCode = prime * hashCode + ((getArrayProperties() == null) ? 0 : getArrayProperties().hashCode());
        hashCode = prime * hashCode + ((getTimeout() == null) ? 0 : getTimeout().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        hashCode = prime * hashCode + ((getPropagateTags() == null) ? 0 : getPropagateTags().hashCode());
        hashCode = prime * hashCode + ((getPlatformCapabilities() == null) ? 0 : getPlatformCapabilities().hashCode());
        hashCode = prime * hashCode + ((getEksProperties() == null) ? 0 : getEksProperties().hashCode());
        hashCode = prime * hashCode + ((getEksAttempts() == null) ? 0 : getEksAttempts().hashCode());
        hashCode = prime * hashCode + ((getIsCancelled() == null) ? 0 : getIsCancelled().hashCode());
        hashCode = prime * hashCode + ((getIsTerminated() == null) ? 0 : getIsTerminated().hashCode());
        return hashCode;
    }

    @Override
    public JobDetail clone() {
        try {
            return (JobDetail) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.batch.model.transform.JobDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
