/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.batch.model.EvaluateOnExit;
import com.amazonaws.services.batch.model.transform.RetryStrategyMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RetryStrategy
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer attempts;
    private List<EvaluateOnExit> evaluateOnExit;

    public void setAttempts(Integer attempts) {
        this.attempts = attempts;
    }

    public Integer getAttempts() {
        return this.attempts;
    }

    public RetryStrategy withAttempts(Integer attempts) {
        this.setAttempts(attempts);
        return this;
    }

    public List<EvaluateOnExit> getEvaluateOnExit() {
        return this.evaluateOnExit;
    }

    public void setEvaluateOnExit(Collection<EvaluateOnExit> evaluateOnExit) {
        if (evaluateOnExit == null) {
            this.evaluateOnExit = null;
            return;
        }
        this.evaluateOnExit = new ArrayList<EvaluateOnExit>(evaluateOnExit);
    }

    public RetryStrategy withEvaluateOnExit(EvaluateOnExit ... evaluateOnExit) {
        if (this.evaluateOnExit == null) {
            this.setEvaluateOnExit(new ArrayList<EvaluateOnExit>(evaluateOnExit.length));
        }
        for (EvaluateOnExit ele : evaluateOnExit) {
            this.evaluateOnExit.add(ele);
        }
        return this;
    }

    public RetryStrategy withEvaluateOnExit(Collection<EvaluateOnExit> evaluateOnExit) {
        this.setEvaluateOnExit(evaluateOnExit);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttempts() != null) {
            sb.append("Attempts: ").append(this.getAttempts()).append(",");
        }
        if (this.getEvaluateOnExit() != null) {
            sb.append("EvaluateOnExit: ").append(this.getEvaluateOnExit());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetryStrategy)) {
            return false;
        }
        RetryStrategy other = (RetryStrategy)obj;
        if (other.getAttempts() == null ^ this.getAttempts() == null) {
            return false;
        }
        if (other.getAttempts() != null && !other.getAttempts().equals(this.getAttempts())) {
            return false;
        }
        if (other.getEvaluateOnExit() == null ^ this.getEvaluateOnExit() == null) {
            return false;
        }
        return other.getEvaluateOnExit() == null || other.getEvaluateOnExit().equals(this.getEvaluateOnExit());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttempts() == null ? 0 : this.getAttempts().hashCode());
        hashCode = 31 * hashCode + (this.getEvaluateOnExit() == null ? 0 : this.getEvaluateOnExit().hashCode());
        return hashCode;
    }

    public RetryStrategy clone() {
        try {
            return (RetryStrategy)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RetryStrategyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

