/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backup.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.backup.model.CopyJob;
import java.util.Date;

@SdkInternalApi
public class CopyJobMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountId").build();
    private static final MarshallingInfo<String> COPYJOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CopyJobId").build();
    private static final MarshallingInfo<String> SOURCEBACKUPVAULTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceBackupVaultArn").build();
    private static final MarshallingInfo<String> SOURCERECOVERYPOINTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceRecoveryPointArn").build();
    private static final MarshallingInfo<String> DESTINATIONBACKUPVAULTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationBackupVaultArn").build();
    private static final MarshallingInfo<String> DESTINATIONRECOVERYPOINTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationRecoveryPointArn").build();
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceArn").build();
    private static final MarshallingInfo<Date> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> COMPLETIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompletionDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<String> STATUSMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusMessage").build();
    private static final MarshallingInfo<Long> BACKUPSIZEINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupSizeInBytes").build();
    private static final MarshallingInfo<String> IAMROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IamRoleArn").build();
    private static final MarshallingInfo<StructuredPojo> CREATEDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedBy").build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceType").build();
    private static final CopyJobMarshaller instance = new CopyJobMarshaller();

    public static CopyJobMarshaller getInstance() {
        return instance;
    }

    public void marshall(CopyJob copyJob, ProtocolMarshaller protocolMarshaller) {
        if (copyJob == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)copyJob.getAccountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)copyJob.getCopyJobId(), COPYJOBID_BINDING);
            protocolMarshaller.marshall((Object)copyJob.getSourceBackupVaultArn(), SOURCEBACKUPVAULTARN_BINDING);
            protocolMarshaller.marshall((Object)copyJob.getSourceRecoveryPointArn(), SOURCERECOVERYPOINTARN_BINDING);
            protocolMarshaller.marshall((Object)copyJob.getDestinationBackupVaultArn(), DESTINATIONBACKUPVAULTARN_BINDING);
            protocolMarshaller.marshall((Object)copyJob.getDestinationRecoveryPointArn(), DESTINATIONRECOVERYPOINTARN_BINDING);
            protocolMarshaller.marshall((Object)copyJob.getResourceArn(), RESOURCEARN_BINDING);
            protocolMarshaller.marshall((Object)copyJob.getCreationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)copyJob.getCompletionDate(), COMPLETIONDATE_BINDING);
            protocolMarshaller.marshall((Object)copyJob.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)copyJob.getStatusMessage(), STATUSMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)copyJob.getBackupSizeInBytes(), BACKUPSIZEINBYTES_BINDING);
            protocolMarshaller.marshall((Object)copyJob.getIamRoleArn(), IAMROLEARN_BINDING);
            protocolMarshaller.marshall((Object)copyJob.getCreatedBy(), CREATEDBY_BINDING);
            protocolMarshaller.marshall((Object)copyJob.getResourceType(), RESOURCETYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

