/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.b2bi.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.b2bi.model.CapabilityConfiguration;
import com.amazonaws.services.b2bi.model.S3Location;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateCapabilityRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String capabilityId;
    private String name;
    private CapabilityConfiguration configuration;
    private List<S3Location> instructionsDocuments;

    public void setCapabilityId(String capabilityId) {
        this.capabilityId = capabilityId;
    }

    public String getCapabilityId() {
        return this.capabilityId;
    }

    public UpdateCapabilityRequest withCapabilityId(String capabilityId) {
        this.setCapabilityId(capabilityId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public UpdateCapabilityRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setConfiguration(CapabilityConfiguration configuration) {
        this.configuration = configuration;
    }

    public CapabilityConfiguration getConfiguration() {
        return this.configuration;
    }

    public UpdateCapabilityRequest withConfiguration(CapabilityConfiguration configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    public List<S3Location> getInstructionsDocuments() {
        return this.instructionsDocuments;
    }

    public void setInstructionsDocuments(Collection<S3Location> instructionsDocuments) {
        if (instructionsDocuments == null) {
            this.instructionsDocuments = null;
            return;
        }
        this.instructionsDocuments = new ArrayList<S3Location>(instructionsDocuments);
    }

    public UpdateCapabilityRequest withInstructionsDocuments(S3Location ... instructionsDocuments) {
        if (this.instructionsDocuments == null) {
            this.setInstructionsDocuments(new ArrayList<S3Location>(instructionsDocuments.length));
        }
        for (S3Location ele : instructionsDocuments) {
            this.instructionsDocuments.add(ele);
        }
        return this;
    }

    public UpdateCapabilityRequest withInstructionsDocuments(Collection<S3Location> instructionsDocuments) {
        this.setInstructionsDocuments(instructionsDocuments);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCapabilityId() != null) {
            sb.append("CapabilityId: ").append(this.getCapabilityId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getConfiguration() != null) {
            sb.append("Configuration: ").append(this.getConfiguration()).append(",");
        }
        if (this.getInstructionsDocuments() != null) {
            sb.append("InstructionsDocuments: ").append(this.getInstructionsDocuments());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCapabilityRequest)) {
            return false;
        }
        UpdateCapabilityRequest other = (UpdateCapabilityRequest)obj;
        if (other.getCapabilityId() == null ^ this.getCapabilityId() == null) {
            return false;
        }
        if (other.getCapabilityId() != null && !other.getCapabilityId().equals(this.getCapabilityId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getConfiguration() == null ^ this.getConfiguration() == null) {
            return false;
        }
        if (other.getConfiguration() != null && !other.getConfiguration().equals(this.getConfiguration())) {
            return false;
        }
        if (other.getInstructionsDocuments() == null ^ this.getInstructionsDocuments() == null) {
            return false;
        }
        return other.getInstructionsDocuments() == null || other.getInstructionsDocuments().equals(this.getInstructionsDocuments());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCapabilityId() == null ? 0 : this.getCapabilityId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getInstructionsDocuments() == null ? 0 : this.getInstructionsDocuments().hashCode());
        return hashCode;
    }

    public UpdateCapabilityRequest clone() {
        return (UpdateCapabilityRequest)super.clone();
    }
}

