/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.b2bi.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.b2bi.model.EdiType;
import com.amazonaws.services.b2bi.model.S3Location;
import com.amazonaws.services.b2bi.model.transform.EdiConfigurationMarshaller;
import java.io.Serializable;

public class EdiConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private EdiType type;
    private S3Location inputLocation;
    private S3Location outputLocation;
    private String transformerId;

    public void setType(EdiType type) {
        this.type = type;
    }

    public EdiType getType() {
        return this.type;
    }

    public EdiConfiguration withType(EdiType type) {
        this.setType(type);
        return this;
    }

    public void setInputLocation(S3Location inputLocation) {
        this.inputLocation = inputLocation;
    }

    public S3Location getInputLocation() {
        return this.inputLocation;
    }

    public EdiConfiguration withInputLocation(S3Location inputLocation) {
        this.setInputLocation(inputLocation);
        return this;
    }

    public void setOutputLocation(S3Location outputLocation) {
        this.outputLocation = outputLocation;
    }

    public S3Location getOutputLocation() {
        return this.outputLocation;
    }

    public EdiConfiguration withOutputLocation(S3Location outputLocation) {
        this.setOutputLocation(outputLocation);
        return this;
    }

    public void setTransformerId(String transformerId) {
        this.transformerId = transformerId;
    }

    public String getTransformerId() {
        return this.transformerId;
    }

    public EdiConfiguration withTransformerId(String transformerId) {
        this.setTransformerId(transformerId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getInputLocation() != null) {
            sb.append("InputLocation: ").append(this.getInputLocation()).append(",");
        }
        if (this.getOutputLocation() != null) {
            sb.append("OutputLocation: ").append(this.getOutputLocation()).append(",");
        }
        if (this.getTransformerId() != null) {
            sb.append("TransformerId: ").append(this.getTransformerId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdiConfiguration)) {
            return false;
        }
        EdiConfiguration other = (EdiConfiguration)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getInputLocation() == null ^ this.getInputLocation() == null) {
            return false;
        }
        if (other.getInputLocation() != null && !other.getInputLocation().equals(this.getInputLocation())) {
            return false;
        }
        if (other.getOutputLocation() == null ^ this.getOutputLocation() == null) {
            return false;
        }
        if (other.getOutputLocation() != null && !other.getOutputLocation().equals(this.getOutputLocation())) {
            return false;
        }
        if (other.getTransformerId() == null ^ this.getTransformerId() == null) {
            return false;
        }
        return other.getTransformerId() == null || other.getTransformerId().equals(this.getTransformerId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getInputLocation() == null ? 0 : this.getInputLocation().hashCode());
        hashCode = 31 * hashCode + (this.getOutputLocation() == null ? 0 : this.getOutputLocation().hashCode());
        hashCode = 31 * hashCode + (this.getTransformerId() == null ? 0 : this.getTransformerId().hashCode());
        return hashCode;
    }

    public EdiConfiguration clone() {
        try {
            return (EdiConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EdiConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

