/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.b2bi;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.b2bi.AWSB2Bi;
import com.amazonaws.services.b2bi.AWSB2BiClientBuilder;
import com.amazonaws.services.b2bi.model.AWSB2BiException;
import com.amazonaws.services.b2bi.model.CreateCapabilityRequest;
import com.amazonaws.services.b2bi.model.CreateCapabilityResult;
import com.amazonaws.services.b2bi.model.CreatePartnershipRequest;
import com.amazonaws.services.b2bi.model.CreatePartnershipResult;
import com.amazonaws.services.b2bi.model.CreateProfileRequest;
import com.amazonaws.services.b2bi.model.CreateProfileResult;
import com.amazonaws.services.b2bi.model.CreateTransformerRequest;
import com.amazonaws.services.b2bi.model.CreateTransformerResult;
import com.amazonaws.services.b2bi.model.DeleteCapabilityRequest;
import com.amazonaws.services.b2bi.model.DeleteCapabilityResult;
import com.amazonaws.services.b2bi.model.DeletePartnershipRequest;
import com.amazonaws.services.b2bi.model.DeletePartnershipResult;
import com.amazonaws.services.b2bi.model.DeleteProfileRequest;
import com.amazonaws.services.b2bi.model.DeleteProfileResult;
import com.amazonaws.services.b2bi.model.DeleteTransformerRequest;
import com.amazonaws.services.b2bi.model.DeleteTransformerResult;
import com.amazonaws.services.b2bi.model.GetCapabilityRequest;
import com.amazonaws.services.b2bi.model.GetCapabilityResult;
import com.amazonaws.services.b2bi.model.GetPartnershipRequest;
import com.amazonaws.services.b2bi.model.GetPartnershipResult;
import com.amazonaws.services.b2bi.model.GetProfileRequest;
import com.amazonaws.services.b2bi.model.GetProfileResult;
import com.amazonaws.services.b2bi.model.GetTransformerJobRequest;
import com.amazonaws.services.b2bi.model.GetTransformerJobResult;
import com.amazonaws.services.b2bi.model.GetTransformerRequest;
import com.amazonaws.services.b2bi.model.GetTransformerResult;
import com.amazonaws.services.b2bi.model.ListCapabilitiesRequest;
import com.amazonaws.services.b2bi.model.ListCapabilitiesResult;
import com.amazonaws.services.b2bi.model.ListPartnershipsRequest;
import com.amazonaws.services.b2bi.model.ListPartnershipsResult;
import com.amazonaws.services.b2bi.model.ListProfilesRequest;
import com.amazonaws.services.b2bi.model.ListProfilesResult;
import com.amazonaws.services.b2bi.model.ListTagsForResourceRequest;
import com.amazonaws.services.b2bi.model.ListTagsForResourceResult;
import com.amazonaws.services.b2bi.model.ListTransformersRequest;
import com.amazonaws.services.b2bi.model.ListTransformersResult;
import com.amazonaws.services.b2bi.model.StartTransformerJobRequest;
import com.amazonaws.services.b2bi.model.StartTransformerJobResult;
import com.amazonaws.services.b2bi.model.TagResourceRequest;
import com.amazonaws.services.b2bi.model.TagResourceResult;
import com.amazonaws.services.b2bi.model.TestMappingRequest;
import com.amazonaws.services.b2bi.model.TestMappingResult;
import com.amazonaws.services.b2bi.model.TestParsingRequest;
import com.amazonaws.services.b2bi.model.TestParsingResult;
import com.amazonaws.services.b2bi.model.UntagResourceRequest;
import com.amazonaws.services.b2bi.model.UntagResourceResult;
import com.amazonaws.services.b2bi.model.UpdateCapabilityRequest;
import com.amazonaws.services.b2bi.model.UpdateCapabilityResult;
import com.amazonaws.services.b2bi.model.UpdatePartnershipRequest;
import com.amazonaws.services.b2bi.model.UpdatePartnershipResult;
import com.amazonaws.services.b2bi.model.UpdateProfileRequest;
import com.amazonaws.services.b2bi.model.UpdateProfileResult;
import com.amazonaws.services.b2bi.model.UpdateTransformerRequest;
import com.amazonaws.services.b2bi.model.UpdateTransformerResult;
import com.amazonaws.services.b2bi.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.CreateCapabilityRequestProtocolMarshaller;
import com.amazonaws.services.b2bi.model.transform.CreateCapabilityResultJsonUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.CreatePartnershipRequestProtocolMarshaller;
import com.amazonaws.services.b2bi.model.transform.CreatePartnershipResultJsonUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.CreateProfileRequestProtocolMarshaller;
import com.amazonaws.services.b2bi.model.transform.CreateProfileResultJsonUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.CreateTransformerRequestProtocolMarshaller;
import com.amazonaws.services.b2bi.model.transform.CreateTransformerResultJsonUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.DeleteCapabilityRequestProtocolMarshaller;
import com.amazonaws.services.b2bi.model.transform.DeleteCapabilityResultJsonUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.DeletePartnershipRequestProtocolMarshaller;
import com.amazonaws.services.b2bi.model.transform.DeletePartnershipResultJsonUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.DeleteProfileRequestProtocolMarshaller;
import com.amazonaws.services.b2bi.model.transform.DeleteProfileResultJsonUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.DeleteTransformerRequestProtocolMarshaller;
import com.amazonaws.services.b2bi.model.transform.DeleteTransformerResultJsonUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.GetCapabilityRequestProtocolMarshaller;
import com.amazonaws.services.b2bi.model.transform.GetCapabilityResultJsonUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.GetPartnershipRequestProtocolMarshaller;
import com.amazonaws.services.b2bi.model.transform.GetPartnershipResultJsonUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.GetProfileRequestProtocolMarshaller;
import com.amazonaws.services.b2bi.model.transform.GetProfileResultJsonUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.GetTransformerJobRequestProtocolMarshaller;
import com.amazonaws.services.b2bi.model.transform.GetTransformerJobResultJsonUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.GetTransformerRequestProtocolMarshaller;
import com.amazonaws.services.b2bi.model.transform.GetTransformerResultJsonUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.ListCapabilitiesRequestProtocolMarshaller;
import com.amazonaws.services.b2bi.model.transform.ListCapabilitiesResultJsonUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.ListPartnershipsRequestProtocolMarshaller;
import com.amazonaws.services.b2bi.model.transform.ListPartnershipsResultJsonUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.ListProfilesRequestProtocolMarshaller;
import com.amazonaws.services.b2bi.model.transform.ListProfilesResultJsonUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.b2bi.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.ListTransformersRequestProtocolMarshaller;
import com.amazonaws.services.b2bi.model.transform.ListTransformersResultJsonUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.StartTransformerJobRequestProtocolMarshaller;
import com.amazonaws.services.b2bi.model.transform.StartTransformerJobResultJsonUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.b2bi.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.TestMappingRequestProtocolMarshaller;
import com.amazonaws.services.b2bi.model.transform.TestMappingResultJsonUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.TestParsingRequestProtocolMarshaller;
import com.amazonaws.services.b2bi.model.transform.TestParsingResultJsonUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.b2bi.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.UpdateCapabilityRequestProtocolMarshaller;
import com.amazonaws.services.b2bi.model.transform.UpdateCapabilityResultJsonUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.UpdatePartnershipRequestProtocolMarshaller;
import com.amazonaws.services.b2bi.model.transform.UpdatePartnershipResultJsonUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.UpdateProfileRequestProtocolMarshaller;
import com.amazonaws.services.b2bi.model.transform.UpdateProfileResultJsonUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.UpdateTransformerRequestProtocolMarshaller;
import com.amazonaws.services.b2bi.model.transform.UpdateTransformerResultJsonUnmarshaller;
import com.amazonaws.services.b2bi.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSB2BiClient
extends AmazonWebServiceClient
implements AWSB2Bi {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSB2Bi.class);
    private static final String DEFAULT_SIGNING_NAME = "b2bi";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.0").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSB2BiException.class));

    public static AWSB2BiClientBuilder builder() {
        return AWSB2BiClientBuilder.standard();
    }

    AWSB2BiClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSB2BiClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("b2bi.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/b2bi/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/b2bi/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateCapabilityResult createCapability(CreateCapabilityRequest request) {
        request = (CreateCapabilityRequest)this.beforeClientExecution(request);
        return this.executeCreateCapability(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateCapabilityResult executeCreateCapability(CreateCapabilityRequest createCapabilityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createCapabilityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateCapabilityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateCapabilityRequestProtocolMarshaller(protocolFactory).marshall((CreateCapabilityRequest)super.beforeMarshalling((AmazonWebServiceRequest)createCapabilityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateCapability");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateCapabilityResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateCapabilityResult createCapabilityResult = (CreateCapabilityResult)response.getAwsResponse();
            return createCapabilityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreatePartnershipResult createPartnership(CreatePartnershipRequest request) {
        request = (CreatePartnershipRequest)this.beforeClientExecution(request);
        return this.executeCreatePartnership(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreatePartnershipResult executeCreatePartnership(CreatePartnershipRequest createPartnershipRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPartnershipRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePartnershipRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePartnershipRequestProtocolMarshaller(protocolFactory).marshall((CreatePartnershipRequest)super.beforeMarshalling((AmazonWebServiceRequest)createPartnershipRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreatePartnership");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreatePartnershipResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreatePartnershipResult createPartnershipResult = (CreatePartnershipResult)response.getAwsResponse();
            return createPartnershipResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateProfileResult createProfile(CreateProfileRequest request) {
        request = (CreateProfileRequest)this.beforeClientExecution(request);
        return this.executeCreateProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateProfileResult executeCreateProfile(CreateProfileRequest createProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateProfileRequestProtocolMarshaller(protocolFactory).marshall((CreateProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)createProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateProfile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateProfileResult createProfileResult = (CreateProfileResult)response.getAwsResponse();
            return createProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateTransformerResult createTransformer(CreateTransformerRequest request) {
        request = (CreateTransformerRequest)this.beforeClientExecution(request);
        return this.executeCreateTransformer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateTransformerResult executeCreateTransformer(CreateTransformerRequest createTransformerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createTransformerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateTransformerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateTransformerRequestProtocolMarshaller(protocolFactory).marshall((CreateTransformerRequest)super.beforeMarshalling((AmazonWebServiceRequest)createTransformerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateTransformer");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateTransformerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateTransformerResult createTransformerResult = (CreateTransformerResult)response.getAwsResponse();
            return createTransformerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteCapabilityResult deleteCapability(DeleteCapabilityRequest request) {
        request = (DeleteCapabilityRequest)this.beforeClientExecution(request);
        return this.executeDeleteCapability(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteCapabilityResult executeDeleteCapability(DeleteCapabilityRequest deleteCapabilityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteCapabilityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteCapabilityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteCapabilityRequestProtocolMarshaller(protocolFactory).marshall((DeleteCapabilityRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteCapabilityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteCapability");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteCapabilityResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteCapabilityResult deleteCapabilityResult = (DeleteCapabilityResult)response.getAwsResponse();
            return deleteCapabilityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeletePartnershipResult deletePartnership(DeletePartnershipRequest request) {
        request = (DeletePartnershipRequest)this.beforeClientExecution(request);
        return this.executeDeletePartnership(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeletePartnershipResult executeDeletePartnership(DeletePartnershipRequest deletePartnershipRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deletePartnershipRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeletePartnershipRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeletePartnershipRequestProtocolMarshaller(protocolFactory).marshall((DeletePartnershipRequest)super.beforeMarshalling((AmazonWebServiceRequest)deletePartnershipRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeletePartnership");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeletePartnershipResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeletePartnershipResult deletePartnershipResult = (DeletePartnershipResult)response.getAwsResponse();
            return deletePartnershipResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteProfileResult deleteProfile(DeleteProfileRequest request) {
        request = (DeleteProfileRequest)this.beforeClientExecution(request);
        return this.executeDeleteProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteProfileResult executeDeleteProfile(DeleteProfileRequest deleteProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteProfileRequestProtocolMarshaller(protocolFactory).marshall((DeleteProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteProfile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteProfileResult deleteProfileResult = (DeleteProfileResult)response.getAwsResponse();
            return deleteProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteTransformerResult deleteTransformer(DeleteTransformerRequest request) {
        request = (DeleteTransformerRequest)this.beforeClientExecution(request);
        return this.executeDeleteTransformer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteTransformerResult executeDeleteTransformer(DeleteTransformerRequest deleteTransformerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteTransformerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteTransformerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteTransformerRequestProtocolMarshaller(protocolFactory).marshall((DeleteTransformerRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteTransformerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteTransformer");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteTransformerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteTransformerResult deleteTransformerResult = (DeleteTransformerResult)response.getAwsResponse();
            return deleteTransformerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetCapabilityResult getCapability(GetCapabilityRequest request) {
        request = (GetCapabilityRequest)this.beforeClientExecution(request);
        return this.executeGetCapability(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetCapabilityResult executeGetCapability(GetCapabilityRequest getCapabilityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getCapabilityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetCapabilityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetCapabilityRequestProtocolMarshaller(protocolFactory).marshall((GetCapabilityRequest)super.beforeMarshalling((AmazonWebServiceRequest)getCapabilityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetCapability");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetCapabilityResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetCapabilityResult getCapabilityResult = (GetCapabilityResult)response.getAwsResponse();
            return getCapabilityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetPartnershipResult getPartnership(GetPartnershipRequest request) {
        request = (GetPartnershipRequest)this.beforeClientExecution(request);
        return this.executeGetPartnership(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetPartnershipResult executeGetPartnership(GetPartnershipRequest getPartnershipRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPartnershipRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPartnershipRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPartnershipRequestProtocolMarshaller(protocolFactory).marshall((GetPartnershipRequest)super.beforeMarshalling((AmazonWebServiceRequest)getPartnershipRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetPartnership");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetPartnershipResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetPartnershipResult getPartnershipResult = (GetPartnershipResult)response.getAwsResponse();
            return getPartnershipResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetProfileResult getProfile(GetProfileRequest request) {
        request = (GetProfileRequest)this.beforeClientExecution(request);
        return this.executeGetProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetProfileResult executeGetProfile(GetProfileRequest getProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetProfileRequestProtocolMarshaller(protocolFactory).marshall((GetProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)getProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetProfile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetProfileResult getProfileResult = (GetProfileResult)response.getAwsResponse();
            return getProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetTransformerResult getTransformer(GetTransformerRequest request) {
        request = (GetTransformerRequest)this.beforeClientExecution(request);
        return this.executeGetTransformer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetTransformerResult executeGetTransformer(GetTransformerRequest getTransformerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTransformerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTransformerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTransformerRequestProtocolMarshaller(protocolFactory).marshall((GetTransformerRequest)super.beforeMarshalling((AmazonWebServiceRequest)getTransformerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetTransformer");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTransformerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetTransformerResult getTransformerResult = (GetTransformerResult)response.getAwsResponse();
            return getTransformerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetTransformerJobResult getTransformerJob(GetTransformerJobRequest request) {
        request = (GetTransformerJobRequest)this.beforeClientExecution(request);
        return this.executeGetTransformerJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetTransformerJobResult executeGetTransformerJob(GetTransformerJobRequest getTransformerJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTransformerJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTransformerJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTransformerJobRequestProtocolMarshaller(protocolFactory).marshall((GetTransformerJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)getTransformerJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetTransformerJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTransformerJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetTransformerJobResult getTransformerJobResult = (GetTransformerJobResult)response.getAwsResponse();
            return getTransformerJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListCapabilitiesResult listCapabilities(ListCapabilitiesRequest request) {
        request = (ListCapabilitiesRequest)this.beforeClientExecution(request);
        return this.executeListCapabilities(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListCapabilitiesResult executeListCapabilities(ListCapabilitiesRequest listCapabilitiesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listCapabilitiesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListCapabilitiesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListCapabilitiesRequestProtocolMarshaller(protocolFactory).marshall((ListCapabilitiesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listCapabilitiesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListCapabilities");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListCapabilitiesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListCapabilitiesResult listCapabilitiesResult = (ListCapabilitiesResult)response.getAwsResponse();
            return listCapabilitiesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPartnershipsResult listPartnerships(ListPartnershipsRequest request) {
        request = (ListPartnershipsRequest)this.beforeClientExecution(request);
        return this.executeListPartnerships(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPartnershipsResult executeListPartnerships(ListPartnershipsRequest listPartnershipsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPartnershipsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPartnershipsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPartnershipsRequestProtocolMarshaller(protocolFactory).marshall((ListPartnershipsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPartnershipsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListPartnerships");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPartnershipsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPartnershipsResult listPartnershipsResult = (ListPartnershipsResult)response.getAwsResponse();
            return listPartnershipsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListProfilesResult listProfiles(ListProfilesRequest request) {
        request = (ListProfilesRequest)this.beforeClientExecution(request);
        return this.executeListProfiles(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListProfilesResult executeListProfiles(ListProfilesRequest listProfilesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listProfilesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListProfilesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListProfilesRequestProtocolMarshaller(protocolFactory).marshall((ListProfilesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listProfilesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListProfiles");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListProfilesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListProfilesResult listProfilesResult = (ListProfilesResult)response.getAwsResponse();
            return listProfilesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTransformersResult listTransformers(ListTransformersRequest request) {
        request = (ListTransformersRequest)this.beforeClientExecution(request);
        return this.executeListTransformers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTransformersResult executeListTransformers(ListTransformersRequest listTransformersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTransformersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTransformersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTransformersRequestProtocolMarshaller(protocolFactory).marshall((ListTransformersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTransformersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTransformers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTransformersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTransformersResult listTransformersResult = (ListTransformersResult)response.getAwsResponse();
            return listTransformersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartTransformerJobResult startTransformerJob(StartTransformerJobRequest request) {
        request = (StartTransformerJobRequest)this.beforeClientExecution(request);
        return this.executeStartTransformerJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartTransformerJobResult executeStartTransformerJob(StartTransformerJobRequest startTransformerJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startTransformerJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartTransformerJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartTransformerJobRequestProtocolMarshaller(protocolFactory).marshall((StartTransformerJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)startTransformerJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartTransformerJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartTransformerJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartTransformerJobResult startTransformerJobResult = (StartTransformerJobResult)response.getAwsResponse();
            return startTransformerJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TestMappingResult testMapping(TestMappingRequest request) {
        request = (TestMappingRequest)this.beforeClientExecution(request);
        return this.executeTestMapping(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TestMappingResult executeTestMapping(TestMappingRequest testMappingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(testMappingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TestMappingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TestMappingRequestProtocolMarshaller(protocolFactory).marshall((TestMappingRequest)super.beforeMarshalling((AmazonWebServiceRequest)testMappingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TestMapping");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TestMappingResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TestMappingResult testMappingResult = (TestMappingResult)response.getAwsResponse();
            return testMappingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TestParsingResult testParsing(TestParsingRequest request) {
        request = (TestParsingRequest)this.beforeClientExecution(request);
        return this.executeTestParsing(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TestParsingResult executeTestParsing(TestParsingRequest testParsingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(testParsingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TestParsingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TestParsingRequestProtocolMarshaller(protocolFactory).marshall((TestParsingRequest)super.beforeMarshalling((AmazonWebServiceRequest)testParsingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TestParsing");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TestParsingResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TestParsingResult testParsingResult = (TestParsingResult)response.getAwsResponse();
            return testParsingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateCapabilityResult updateCapability(UpdateCapabilityRequest request) {
        request = (UpdateCapabilityRequest)this.beforeClientExecution(request);
        return this.executeUpdateCapability(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateCapabilityResult executeUpdateCapability(UpdateCapabilityRequest updateCapabilityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateCapabilityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateCapabilityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateCapabilityRequestProtocolMarshaller(protocolFactory).marshall((UpdateCapabilityRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateCapabilityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateCapability");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateCapabilityResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateCapabilityResult updateCapabilityResult = (UpdateCapabilityResult)response.getAwsResponse();
            return updateCapabilityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdatePartnershipResult updatePartnership(UpdatePartnershipRequest request) {
        request = (UpdatePartnershipRequest)this.beforeClientExecution(request);
        return this.executeUpdatePartnership(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdatePartnershipResult executeUpdatePartnership(UpdatePartnershipRequest updatePartnershipRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updatePartnershipRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdatePartnershipRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdatePartnershipRequestProtocolMarshaller(protocolFactory).marshall((UpdatePartnershipRequest)super.beforeMarshalling((AmazonWebServiceRequest)updatePartnershipRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdatePartnership");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdatePartnershipResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdatePartnershipResult updatePartnershipResult = (UpdatePartnershipResult)response.getAwsResponse();
            return updatePartnershipResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateProfileResult updateProfile(UpdateProfileRequest request) {
        request = (UpdateProfileRequest)this.beforeClientExecution(request);
        return this.executeUpdateProfile(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateProfileResult executeUpdateProfile(UpdateProfileRequest updateProfileRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateProfileRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateProfileRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateProfileRequestProtocolMarshaller(protocolFactory).marshall((UpdateProfileRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateProfileRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateProfile");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateProfileResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateProfileResult updateProfileResult = (UpdateProfileResult)response.getAwsResponse();
            return updateProfileResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateTransformerResult updateTransformer(UpdateTransformerRequest request) {
        request = (UpdateTransformerRequest)this.beforeClientExecution(request);
        return this.executeUpdateTransformer(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateTransformerResult executeUpdateTransformer(UpdateTransformerRequest updateTransformerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateTransformerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateTransformerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateTransformerRequestProtocolMarshaller(protocolFactory).marshall((UpdateTransformerRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateTransformerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)DEFAULT_SIGNING_NAME);
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateTransformer");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateTransformerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateTransformerResult updateTransformerResult = (UpdateTransformerResult)response.getAwsResponse();
            return updateTransformerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

