/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auditmanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.auditmanager.model.AssessmentControl;
import com.amazonaws.services.auditmanager.model.ControlSetStatus;
import com.amazonaws.services.auditmanager.model.Delegation;
import com.amazonaws.services.auditmanager.model.Role;
import com.amazonaws.services.auditmanager.model.transform.AssessmentControlSetMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AssessmentControlSet
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String description;
    private String status;
    private List<Role> roles;
    private List<AssessmentControl> controls;
    private List<Delegation> delegations;
    private Integer systemEvidenceCount;
    private Integer manualEvidenceCount;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public AssessmentControlSet withId(String id) {
        this.setId(id);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public AssessmentControlSet withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public AssessmentControlSet withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public AssessmentControlSet withStatus(ControlSetStatus status) {
        this.status = status.toString();
        return this;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Collection<Role> roles) {
        if (roles == null) {
            this.roles = null;
            return;
        }
        this.roles = new ArrayList<Role>(roles);
    }

    public AssessmentControlSet withRoles(Role ... roles) {
        if (this.roles == null) {
            this.setRoles(new ArrayList<Role>(roles.length));
        }
        for (Role ele : roles) {
            this.roles.add(ele);
        }
        return this;
    }

    public AssessmentControlSet withRoles(Collection<Role> roles) {
        this.setRoles(roles);
        return this;
    }

    public List<AssessmentControl> getControls() {
        return this.controls;
    }

    public void setControls(Collection<AssessmentControl> controls) {
        if (controls == null) {
            this.controls = null;
            return;
        }
        this.controls = new ArrayList<AssessmentControl>(controls);
    }

    public AssessmentControlSet withControls(AssessmentControl ... controls) {
        if (this.controls == null) {
            this.setControls(new ArrayList<AssessmentControl>(controls.length));
        }
        for (AssessmentControl ele : controls) {
            this.controls.add(ele);
        }
        return this;
    }

    public AssessmentControlSet withControls(Collection<AssessmentControl> controls) {
        this.setControls(controls);
        return this;
    }

    public List<Delegation> getDelegations() {
        return this.delegations;
    }

    public void setDelegations(Collection<Delegation> delegations) {
        if (delegations == null) {
            this.delegations = null;
            return;
        }
        this.delegations = new ArrayList<Delegation>(delegations);
    }

    public AssessmentControlSet withDelegations(Delegation ... delegations) {
        if (this.delegations == null) {
            this.setDelegations(new ArrayList<Delegation>(delegations.length));
        }
        for (Delegation ele : delegations) {
            this.delegations.add(ele);
        }
        return this;
    }

    public AssessmentControlSet withDelegations(Collection<Delegation> delegations) {
        this.setDelegations(delegations);
        return this;
    }

    public void setSystemEvidenceCount(Integer systemEvidenceCount) {
        this.systemEvidenceCount = systemEvidenceCount;
    }

    public Integer getSystemEvidenceCount() {
        return this.systemEvidenceCount;
    }

    public AssessmentControlSet withSystemEvidenceCount(Integer systemEvidenceCount) {
        this.setSystemEvidenceCount(systemEvidenceCount);
        return this;
    }

    public void setManualEvidenceCount(Integer manualEvidenceCount) {
        this.manualEvidenceCount = manualEvidenceCount;
    }

    public Integer getManualEvidenceCount() {
        return this.manualEvidenceCount;
    }

    public AssessmentControlSet withManualEvidenceCount(Integer manualEvidenceCount) {
        this.setManualEvidenceCount(manualEvidenceCount);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getRoles() != null) {
            sb.append("Roles: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getControls() != null) {
            sb.append("Controls: ").append(this.getControls()).append(",");
        }
        if (this.getDelegations() != null) {
            sb.append("Delegations: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getSystemEvidenceCount() != null) {
            sb.append("SystemEvidenceCount: ").append(this.getSystemEvidenceCount()).append(",");
        }
        if (this.getManualEvidenceCount() != null) {
            sb.append("ManualEvidenceCount: ").append(this.getManualEvidenceCount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentControlSet)) {
            return false;
        }
        AssessmentControlSet other = (AssessmentControlSet)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getRoles() == null ^ this.getRoles() == null) {
            return false;
        }
        if (other.getRoles() != null && !other.getRoles().equals(this.getRoles())) {
            return false;
        }
        if (other.getControls() == null ^ this.getControls() == null) {
            return false;
        }
        if (other.getControls() != null && !other.getControls().equals(this.getControls())) {
            return false;
        }
        if (other.getDelegations() == null ^ this.getDelegations() == null) {
            return false;
        }
        if (other.getDelegations() != null && !other.getDelegations().equals(this.getDelegations())) {
            return false;
        }
        if (other.getSystemEvidenceCount() == null ^ this.getSystemEvidenceCount() == null) {
            return false;
        }
        if (other.getSystemEvidenceCount() != null && !other.getSystemEvidenceCount().equals(this.getSystemEvidenceCount())) {
            return false;
        }
        if (other.getManualEvidenceCount() == null ^ this.getManualEvidenceCount() == null) {
            return false;
        }
        return other.getManualEvidenceCount() == null || other.getManualEvidenceCount().equals(this.getManualEvidenceCount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getRoles() == null ? 0 : this.getRoles().hashCode());
        hashCode = 31 * hashCode + (this.getControls() == null ? 0 : this.getControls().hashCode());
        hashCode = 31 * hashCode + (this.getDelegations() == null ? 0 : this.getDelegations().hashCode());
        hashCode = 31 * hashCode + (this.getSystemEvidenceCount() == null ? 0 : this.getSystemEvidenceCount().hashCode());
        hashCode = 31 * hashCode + (this.getManualEvidenceCount() == null ? 0 : this.getManualEvidenceCount().hashCode());
        return hashCode;
    }

    public AssessmentControlSet clone() {
        try {
            return (AssessmentControlSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AssessmentControlSetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

