/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auditmanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.auditmanager.model.ControlComment;
import com.amazonaws.services.auditmanager.model.ControlResponse;
import com.amazonaws.services.auditmanager.model.ControlStatus;
import com.amazonaws.services.auditmanager.model.transform.AssessmentControlMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AssessmentControl
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String name;
    private String description;
    private String status;
    private String response;
    private List<ControlComment> comments;
    private List<String> evidenceSources;
    private Integer evidenceCount;
    private Integer assessmentReportEvidenceCount;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public AssessmentControl withId(String id) {
        this.setId(id);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public AssessmentControl withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public AssessmentControl withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public AssessmentControl withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public AssessmentControl withStatus(ControlStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public String getResponse() {
        return this.response;
    }

    public AssessmentControl withResponse(String response) {
        this.setResponse(response);
        return this;
    }

    public AssessmentControl withResponse(ControlResponse response) {
        this.response = response.toString();
        return this;
    }

    public List<ControlComment> getComments() {
        return this.comments;
    }

    public void setComments(Collection<ControlComment> comments) {
        if (comments == null) {
            this.comments = null;
            return;
        }
        this.comments = new ArrayList<ControlComment>(comments);
    }

    public AssessmentControl withComments(ControlComment ... comments) {
        if (this.comments == null) {
            this.setComments(new ArrayList<ControlComment>(comments.length));
        }
        for (ControlComment ele : comments) {
            this.comments.add(ele);
        }
        return this;
    }

    public AssessmentControl withComments(Collection<ControlComment> comments) {
        this.setComments(comments);
        return this;
    }

    public List<String> getEvidenceSources() {
        return this.evidenceSources;
    }

    public void setEvidenceSources(Collection<String> evidenceSources) {
        if (evidenceSources == null) {
            this.evidenceSources = null;
            return;
        }
        this.evidenceSources = new ArrayList<String>(evidenceSources);
    }

    public AssessmentControl withEvidenceSources(String ... evidenceSources) {
        if (this.evidenceSources == null) {
            this.setEvidenceSources(new ArrayList<String>(evidenceSources.length));
        }
        for (String ele : evidenceSources) {
            this.evidenceSources.add(ele);
        }
        return this;
    }

    public AssessmentControl withEvidenceSources(Collection<String> evidenceSources) {
        this.setEvidenceSources(evidenceSources);
        return this;
    }

    public void setEvidenceCount(Integer evidenceCount) {
        this.evidenceCount = evidenceCount;
    }

    public Integer getEvidenceCount() {
        return this.evidenceCount;
    }

    public AssessmentControl withEvidenceCount(Integer evidenceCount) {
        this.setEvidenceCount(evidenceCount);
        return this;
    }

    public void setAssessmentReportEvidenceCount(Integer assessmentReportEvidenceCount) {
        this.assessmentReportEvidenceCount = assessmentReportEvidenceCount;
    }

    public Integer getAssessmentReportEvidenceCount() {
        return this.assessmentReportEvidenceCount;
    }

    public AssessmentControl withAssessmentReportEvidenceCount(Integer assessmentReportEvidenceCount) {
        this.setAssessmentReportEvidenceCount(assessmentReportEvidenceCount);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getResponse() != null) {
            sb.append("Response: ").append(this.getResponse()).append(",");
        }
        if (this.getComments() != null) {
            sb.append("Comments: ").append(this.getComments()).append(",");
        }
        if (this.getEvidenceSources() != null) {
            sb.append("EvidenceSources: ").append(this.getEvidenceSources()).append(",");
        }
        if (this.getEvidenceCount() != null) {
            sb.append("EvidenceCount: ").append(this.getEvidenceCount()).append(",");
        }
        if (this.getAssessmentReportEvidenceCount() != null) {
            sb.append("AssessmentReportEvidenceCount: ").append(this.getAssessmentReportEvidenceCount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentControl)) {
            return false;
        }
        AssessmentControl other = (AssessmentControl)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getResponse() == null ^ this.getResponse() == null) {
            return false;
        }
        if (other.getResponse() != null && !other.getResponse().equals(this.getResponse())) {
            return false;
        }
        if (other.getComments() == null ^ this.getComments() == null) {
            return false;
        }
        if (other.getComments() != null && !other.getComments().equals(this.getComments())) {
            return false;
        }
        if (other.getEvidenceSources() == null ^ this.getEvidenceSources() == null) {
            return false;
        }
        if (other.getEvidenceSources() != null && !other.getEvidenceSources().equals(this.getEvidenceSources())) {
            return false;
        }
        if (other.getEvidenceCount() == null ^ this.getEvidenceCount() == null) {
            return false;
        }
        if (other.getEvidenceCount() != null && !other.getEvidenceCount().equals(this.getEvidenceCount())) {
            return false;
        }
        if (other.getAssessmentReportEvidenceCount() == null ^ this.getAssessmentReportEvidenceCount() == null) {
            return false;
        }
        return other.getAssessmentReportEvidenceCount() == null || other.getAssessmentReportEvidenceCount().equals(this.getAssessmentReportEvidenceCount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getResponse() == null ? 0 : this.getResponse().hashCode());
        hashCode = 31 * hashCode + (this.getComments() == null ? 0 : this.getComments().hashCode());
        hashCode = 31 * hashCode + (this.getEvidenceSources() == null ? 0 : this.getEvidenceSources().hashCode());
        hashCode = 31 * hashCode + (this.getEvidenceCount() == null ? 0 : this.getEvidenceCount().hashCode());
        hashCode = 31 * hashCode + (this.getAssessmentReportEvidenceCount() == null ? 0 : this.getAssessmentReportEvidenceCount().hashCode());
        return hashCode;
    }

    public AssessmentControl clone() {
        try {
            return (AssessmentControl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AssessmentControlMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

