/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apptest.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.apptest.model.Step;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateTestCaseRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String description;
    private List<Step> steps;
    private String clientToken;
    private Map<String, String> tags;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateTestCaseRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateTestCaseRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void setSteps(Collection<Step> steps) {
        if (steps == null) {
            this.steps = null;
            return;
        }
        this.steps = new ArrayList<Step>(steps);
    }

    public CreateTestCaseRequest withSteps(Step ... steps) {
        if (this.steps == null) {
            this.setSteps(new ArrayList<Step>(steps.length));
        }
        for (Step ele : steps) {
            this.steps.add(ele);
        }
        return this;
    }

    public CreateTestCaseRequest withSteps(Collection<Step> steps) {
        this.setSteps(steps);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateTestCaseRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateTestCaseRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateTestCaseRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateTestCaseRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getSteps() != null) {
            sb.append("Steps: ").append(this.getSteps()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTestCaseRequest)) {
            return false;
        }
        CreateTestCaseRequest other = (CreateTestCaseRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getSteps() == null ^ this.getSteps() == null) {
            return false;
        }
        if (other.getSteps() != null && !other.getSteps().equals(this.getSteps())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getSteps() == null ? 0 : this.getSteps().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateTestCaseRequest clone() {
        return (CreateTestCaseRequest)super.clone();
    }
}

