/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apptest.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.apptest.model.Step;
import com.amazonaws.services.apptest.model.TestCases;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateTestSuiteRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String description;
    private List<Step> beforeSteps;
    private List<Step> afterSteps;
    private TestCases testCases;
    private String clientToken;
    private Map<String, String> tags;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateTestSuiteRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateTestSuiteRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<Step> getBeforeSteps() {
        return this.beforeSteps;
    }

    public void setBeforeSteps(Collection<Step> beforeSteps) {
        if (beforeSteps == null) {
            this.beforeSteps = null;
            return;
        }
        this.beforeSteps = new ArrayList<Step>(beforeSteps);
    }

    public CreateTestSuiteRequest withBeforeSteps(Step ... beforeSteps) {
        if (this.beforeSteps == null) {
            this.setBeforeSteps(new ArrayList<Step>(beforeSteps.length));
        }
        for (Step ele : beforeSteps) {
            this.beforeSteps.add(ele);
        }
        return this;
    }

    public CreateTestSuiteRequest withBeforeSteps(Collection<Step> beforeSteps) {
        this.setBeforeSteps(beforeSteps);
        return this;
    }

    public List<Step> getAfterSteps() {
        return this.afterSteps;
    }

    public void setAfterSteps(Collection<Step> afterSteps) {
        if (afterSteps == null) {
            this.afterSteps = null;
            return;
        }
        this.afterSteps = new ArrayList<Step>(afterSteps);
    }

    public CreateTestSuiteRequest withAfterSteps(Step ... afterSteps) {
        if (this.afterSteps == null) {
            this.setAfterSteps(new ArrayList<Step>(afterSteps.length));
        }
        for (Step ele : afterSteps) {
            this.afterSteps.add(ele);
        }
        return this;
    }

    public CreateTestSuiteRequest withAfterSteps(Collection<Step> afterSteps) {
        this.setAfterSteps(afterSteps);
        return this;
    }

    public void setTestCases(TestCases testCases) {
        this.testCases = testCases;
    }

    public TestCases getTestCases() {
        return this.testCases;
    }

    public CreateTestSuiteRequest withTestCases(TestCases testCases) {
        this.setTestCases(testCases);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateTestSuiteRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateTestSuiteRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateTestSuiteRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateTestSuiteRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getBeforeSteps() != null) {
            sb.append("BeforeSteps: ").append(this.getBeforeSteps()).append(",");
        }
        if (this.getAfterSteps() != null) {
            sb.append("AfterSteps: ").append(this.getAfterSteps()).append(",");
        }
        if (this.getTestCases() != null) {
            sb.append("TestCases: ").append(this.getTestCases()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTestSuiteRequest)) {
            return false;
        }
        CreateTestSuiteRequest other = (CreateTestSuiteRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getBeforeSteps() == null ^ this.getBeforeSteps() == null) {
            return false;
        }
        if (other.getBeforeSteps() != null && !other.getBeforeSteps().equals(this.getBeforeSteps())) {
            return false;
        }
        if (other.getAfterSteps() == null ^ this.getAfterSteps() == null) {
            return false;
        }
        if (other.getAfterSteps() != null && !other.getAfterSteps().equals(this.getAfterSteps())) {
            return false;
        }
        if (other.getTestCases() == null ^ this.getTestCases() == null) {
            return false;
        }
        if (other.getTestCases() != null && !other.getTestCases().equals(this.getTestCases())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getBeforeSteps() == null ? 0 : this.getBeforeSteps().hashCode());
        hashCode = 31 * hashCode + (this.getAfterSteps() == null ? 0 : this.getAfterSteps().hashCode());
        hashCode = 31 * hashCode + (this.getTestCases() == null ? 0 : this.getTestCases().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateTestSuiteRequest clone() {
        return (CreateTestSuiteRequest)super.clone();
    }
}

