/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationsignals.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.applicationsignals.model.ServiceSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ListServicesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private Date startTime;
    private Date endTime;
    private List<ServiceSummary> serviceSummaries;
    private String nextToken;

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public ListServicesResult withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public ListServicesResult withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public List<ServiceSummary> getServiceSummaries() {
        return this.serviceSummaries;
    }

    public void setServiceSummaries(Collection<ServiceSummary> serviceSummaries) {
        if (serviceSummaries == null) {
            this.serviceSummaries = null;
            return;
        }
        this.serviceSummaries = new ArrayList<ServiceSummary>(serviceSummaries);
    }

    public ListServicesResult withServiceSummaries(ServiceSummary ... serviceSummaries) {
        if (this.serviceSummaries == null) {
            this.setServiceSummaries(new ArrayList<ServiceSummary>(serviceSummaries.length));
        }
        for (ServiceSummary ele : serviceSummaries) {
            this.serviceSummaries.add(ele);
        }
        return this;
    }

    public ListServicesResult withServiceSummaries(Collection<ServiceSummary> serviceSummaries) {
        this.setServiceSummaries(serviceSummaries);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListServicesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getServiceSummaries() != null) {
            sb.append("ServiceSummaries: ").append(this.getServiceSummaries()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServicesResult)) {
            return false;
        }
        ListServicesResult other = (ListServicesResult)obj;
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getServiceSummaries() == null ^ this.getServiceSummaries() == null) {
            return false;
        }
        if (other.getServiceSummaries() != null && !other.getServiceSummaries().equals(this.getServiceSummaries())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getServiceSummaries() == null ? 0 : this.getServiceSummaries().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListServicesResult clone() {
        try {
            return (ListServicesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

