/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appflow.model.transform.CustomAuthCredentialsMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CustomAuthCredentials
implements Serializable,
Cloneable,
StructuredPojo {
    private String customAuthenticationType;
    private Map<String, String> credentialsMap;

    public void setCustomAuthenticationType(String customAuthenticationType) {
        this.customAuthenticationType = customAuthenticationType;
    }

    public String getCustomAuthenticationType() {
        return this.customAuthenticationType;
    }

    public CustomAuthCredentials withCustomAuthenticationType(String customAuthenticationType) {
        this.setCustomAuthenticationType(customAuthenticationType);
        return this;
    }

    public Map<String, String> getCredentialsMap() {
        return this.credentialsMap;
    }

    public void setCredentialsMap(Map<String, String> credentialsMap) {
        this.credentialsMap = credentialsMap;
    }

    public CustomAuthCredentials withCredentialsMap(Map<String, String> credentialsMap) {
        this.setCredentialsMap(credentialsMap);
        return this;
    }

    public CustomAuthCredentials addCredentialsMapEntry(String key, String value) {
        if (null == this.credentialsMap) {
            this.credentialsMap = new HashMap<String, String>();
        }
        if (this.credentialsMap.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.credentialsMap.put(key, value);
        return this;
    }

    public CustomAuthCredentials clearCredentialsMapEntries() {
        this.credentialsMap = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCustomAuthenticationType() != null) {
            sb.append("CustomAuthenticationType: ").append(this.getCustomAuthenticationType()).append(",");
        }
        if (this.getCredentialsMap() != null) {
            sb.append("CredentialsMap: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomAuthCredentials)) {
            return false;
        }
        CustomAuthCredentials other = (CustomAuthCredentials)obj;
        if (other.getCustomAuthenticationType() == null ^ this.getCustomAuthenticationType() == null) {
            return false;
        }
        if (other.getCustomAuthenticationType() != null && !other.getCustomAuthenticationType().equals(this.getCustomAuthenticationType())) {
            return false;
        }
        if (other.getCredentialsMap() == null ^ this.getCredentialsMap() == null) {
            return false;
        }
        return other.getCredentialsMap() == null || other.getCredentialsMap().equals(this.getCredentialsMap());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCustomAuthenticationType() == null ? 0 : this.getCustomAuthenticationType().hashCode());
        hashCode = 31 * hashCode + (this.getCredentialsMap() == null ? 0 : this.getCredentialsMap().hashCode());
        return hashCode;
    }

    public CustomAuthCredentials clone() {
        try {
            return (CustomAuthCredentials)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CustomAuthCredentialsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

