/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appflow.model.ConnectorOAuthRequest;
import com.amazonaws.services.appflow.model.OAuth2GrantType;
import com.amazonaws.services.appflow.model.transform.SalesforceConnectorProfileCredentialsMarshaller;
import java.io.Serializable;

public class SalesforceConnectorProfileCredentials
implements Serializable,
Cloneable,
StructuredPojo {
    private String accessToken;
    private String refreshToken;
    private ConnectorOAuthRequest oAuthRequest;
    private String clientCredentialsArn;
    private String oAuth2GrantType;
    private String jwtToken;

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public SalesforceConnectorProfileCredentials withAccessToken(String accessToken) {
        this.setAccessToken(accessToken);
        return this;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public SalesforceConnectorProfileCredentials withRefreshToken(String refreshToken) {
        this.setRefreshToken(refreshToken);
        return this;
    }

    public void setOAuthRequest(ConnectorOAuthRequest oAuthRequest) {
        this.oAuthRequest = oAuthRequest;
    }

    public ConnectorOAuthRequest getOAuthRequest() {
        return this.oAuthRequest;
    }

    public SalesforceConnectorProfileCredentials withOAuthRequest(ConnectorOAuthRequest oAuthRequest) {
        this.setOAuthRequest(oAuthRequest);
        return this;
    }

    public void setClientCredentialsArn(String clientCredentialsArn) {
        this.clientCredentialsArn = clientCredentialsArn;
    }

    public String getClientCredentialsArn() {
        return this.clientCredentialsArn;
    }

    public SalesforceConnectorProfileCredentials withClientCredentialsArn(String clientCredentialsArn) {
        this.setClientCredentialsArn(clientCredentialsArn);
        return this;
    }

    public void setOAuth2GrantType(String oAuth2GrantType) {
        this.oAuth2GrantType = oAuth2GrantType;
    }

    public String getOAuth2GrantType() {
        return this.oAuth2GrantType;
    }

    public SalesforceConnectorProfileCredentials withOAuth2GrantType(String oAuth2GrantType) {
        this.setOAuth2GrantType(oAuth2GrantType);
        return this;
    }

    public SalesforceConnectorProfileCredentials withOAuth2GrantType(OAuth2GrantType oAuth2GrantType) {
        this.oAuth2GrantType = oAuth2GrantType.toString();
        return this;
    }

    public void setJwtToken(String jwtToken) {
        this.jwtToken = jwtToken;
    }

    public String getJwtToken() {
        return this.jwtToken;
    }

    public SalesforceConnectorProfileCredentials withJwtToken(String jwtToken) {
        this.setJwtToken(jwtToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccessToken() != null) {
            sb.append("AccessToken: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getRefreshToken() != null) {
            sb.append("RefreshToken: ").append(this.getRefreshToken()).append(",");
        }
        if (this.getOAuthRequest() != null) {
            sb.append("OAuthRequest: ").append(this.getOAuthRequest()).append(",");
        }
        if (this.getClientCredentialsArn() != null) {
            sb.append("ClientCredentialsArn: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getOAuth2GrantType() != null) {
            sb.append("OAuth2GrantType: ").append(this.getOAuth2GrantType()).append(",");
        }
        if (this.getJwtToken() != null) {
            sb.append("JwtToken: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceConnectorProfileCredentials)) {
            return false;
        }
        SalesforceConnectorProfileCredentials other = (SalesforceConnectorProfileCredentials)obj;
        if (other.getAccessToken() == null ^ this.getAccessToken() == null) {
            return false;
        }
        if (other.getAccessToken() != null && !other.getAccessToken().equals(this.getAccessToken())) {
            return false;
        }
        if (other.getRefreshToken() == null ^ this.getRefreshToken() == null) {
            return false;
        }
        if (other.getRefreshToken() != null && !other.getRefreshToken().equals(this.getRefreshToken())) {
            return false;
        }
        if (other.getOAuthRequest() == null ^ this.getOAuthRequest() == null) {
            return false;
        }
        if (other.getOAuthRequest() != null && !other.getOAuthRequest().equals(this.getOAuthRequest())) {
            return false;
        }
        if (other.getClientCredentialsArn() == null ^ this.getClientCredentialsArn() == null) {
            return false;
        }
        if (other.getClientCredentialsArn() != null && !other.getClientCredentialsArn().equals(this.getClientCredentialsArn())) {
            return false;
        }
        if (other.getOAuth2GrantType() == null ^ this.getOAuth2GrantType() == null) {
            return false;
        }
        if (other.getOAuth2GrantType() != null && !other.getOAuth2GrantType().equals(this.getOAuth2GrantType())) {
            return false;
        }
        if (other.getJwtToken() == null ^ this.getJwtToken() == null) {
            return false;
        }
        return other.getJwtToken() == null || other.getJwtToken().equals(this.getJwtToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccessToken() == null ? 0 : this.getAccessToken().hashCode());
        hashCode = 31 * hashCode + (this.getRefreshToken() == null ? 0 : this.getRefreshToken().hashCode());
        hashCode = 31 * hashCode + (this.getOAuthRequest() == null ? 0 : this.getOAuthRequest().hashCode());
        hashCode = 31 * hashCode + (this.getClientCredentialsArn() == null ? 0 : this.getClientCredentialsArn().hashCode());
        hashCode = 31 * hashCode + (this.getOAuth2GrantType() == null ? 0 : this.getOAuth2GrantType().hashCode());
        hashCode = 31 * hashCode + (this.getJwtToken() == null ? 0 : this.getJwtToken().hashCode());
        return hashCode;
    }

    public SalesforceConnectorProfileCredentials clone() {
        try {
            return (SalesforceConnectorProfileCredentials)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SalesforceConnectorProfileCredentialsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

