/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appfabric.model.transform;

import com.amazonaws.services.appfabric.model.S3Bucket;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class S3BucketJsonUnmarshaller
implements Unmarshaller<S3Bucket, JsonUnmarshallerContext> {
    private static S3BucketJsonUnmarshaller instance;

    public S3Bucket unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3Bucket s3Bucket = new S3Bucket();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("bucketName", targetDepth)) {
                    context.nextToken();
                    s3Bucket.setBucketName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("prefix", targetDepth)) {
                    context.nextToken();
                    s3Bucket.setPrefix((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return s3Bucket;
    }

    public static S3BucketJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3BucketJsonUnmarshaller();
        }
        return instance;
    }
}

