/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appfabric.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.appfabric.model.FirehoseStream;

@SdkInternalApi
public class FirehoseStreamMarshaller {
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streamName").build();
    private static final FirehoseStreamMarshaller instance = new FirehoseStreamMarshaller();

    public static FirehoseStreamMarshaller getInstance() {
        return instance;
    }

    public void marshall(FirehoseStream firehoseStream, ProtocolMarshaller protocolMarshaller) {
        if (firehoseStream == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)firehoseStream.getStreamName(), STREAMNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

