/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appfabric.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.appfabric.model.AuthType;
import com.amazonaws.services.appfabric.model.Credential;
import com.amazonaws.services.appfabric.model.Tag;
import com.amazonaws.services.appfabric.model.Tenant;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateAppAuthorizationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String appBundleIdentifier;
    private String app;
    private Credential credential;
    private Tenant tenant;
    private String authType;
    private String clientToken;
    private List<Tag> tags;

    public void setAppBundleIdentifier(String appBundleIdentifier) {
        this.appBundleIdentifier = appBundleIdentifier;
    }

    public String getAppBundleIdentifier() {
        return this.appBundleIdentifier;
    }

    public CreateAppAuthorizationRequest withAppBundleIdentifier(String appBundleIdentifier) {
        this.setAppBundleIdentifier(appBundleIdentifier);
        return this;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getApp() {
        return this.app;
    }

    public CreateAppAuthorizationRequest withApp(String app) {
        this.setApp(app);
        return this;
    }

    public void setCredential(Credential credential) {
        this.credential = credential;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public CreateAppAuthorizationRequest withCredential(Credential credential) {
        this.setCredential(credential);
        return this;
    }

    public void setTenant(Tenant tenant) {
        this.tenant = tenant;
    }

    public Tenant getTenant() {
        return this.tenant;
    }

    public CreateAppAuthorizationRequest withTenant(Tenant tenant) {
        this.setTenant(tenant);
        return this;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getAuthType() {
        return this.authType;
    }

    public CreateAppAuthorizationRequest withAuthType(String authType) {
        this.setAuthType(authType);
        return this;
    }

    public CreateAppAuthorizationRequest withAuthType(AuthType authType) {
        this.authType = authType.toString();
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateAppAuthorizationRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateAppAuthorizationRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateAppAuthorizationRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAppBundleIdentifier() != null) {
            sb.append("AppBundleIdentifier: ").append(this.getAppBundleIdentifier()).append(",");
        }
        if (this.getApp() != null) {
            sb.append("App: ").append(this.getApp()).append(",");
        }
        if (this.getCredential() != null) {
            sb.append("Credential: ").append(this.getCredential()).append(",");
        }
        if (this.getTenant() != null) {
            sb.append("Tenant: ").append(this.getTenant()).append(",");
        }
        if (this.getAuthType() != null) {
            sb.append("AuthType: ").append(this.getAuthType()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppAuthorizationRequest)) {
            return false;
        }
        CreateAppAuthorizationRequest other = (CreateAppAuthorizationRequest)obj;
        if (other.getAppBundleIdentifier() == null ^ this.getAppBundleIdentifier() == null) {
            return false;
        }
        if (other.getAppBundleIdentifier() != null && !other.getAppBundleIdentifier().equals(this.getAppBundleIdentifier())) {
            return false;
        }
        if (other.getApp() == null ^ this.getApp() == null) {
            return false;
        }
        if (other.getApp() != null && !other.getApp().equals(this.getApp())) {
            return false;
        }
        if (other.getCredential() == null ^ this.getCredential() == null) {
            return false;
        }
        if (other.getCredential() != null && !other.getCredential().equals(this.getCredential())) {
            return false;
        }
        if (other.getTenant() == null ^ this.getTenant() == null) {
            return false;
        }
        if (other.getTenant() != null && !other.getTenant().equals(this.getTenant())) {
            return false;
        }
        if (other.getAuthType() == null ^ this.getAuthType() == null) {
            return false;
        }
        if (other.getAuthType() != null && !other.getAuthType().equals(this.getAuthType())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAppBundleIdentifier() == null ? 0 : this.getAppBundleIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getApp() == null ? 0 : this.getApp().hashCode());
        hashCode = 31 * hashCode + (this.getCredential() == null ? 0 : this.getCredential().hashCode());
        hashCode = 31 * hashCode + (this.getTenant() == null ? 0 : this.getTenant().hashCode());
        hashCode = 31 * hashCode + (this.getAuthType() == null ? 0 : this.getAuthType().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateAppAuthorizationRequest clone() {
        return (CreateAppAuthorizationRequest)super.clone();
    }
}

