/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appfabric;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.appfabric.AWSAppFabric;
import com.amazonaws.services.appfabric.AWSAppFabricClientBuilder;
import com.amazonaws.services.appfabric.model.AWSAppFabricException;
import com.amazonaws.services.appfabric.model.BatchGetUserAccessTasksRequest;
import com.amazonaws.services.appfabric.model.BatchGetUserAccessTasksResult;
import com.amazonaws.services.appfabric.model.ConnectAppAuthorizationRequest;
import com.amazonaws.services.appfabric.model.ConnectAppAuthorizationResult;
import com.amazonaws.services.appfabric.model.CreateAppAuthorizationRequest;
import com.amazonaws.services.appfabric.model.CreateAppAuthorizationResult;
import com.amazonaws.services.appfabric.model.CreateAppBundleRequest;
import com.amazonaws.services.appfabric.model.CreateAppBundleResult;
import com.amazonaws.services.appfabric.model.CreateIngestionDestinationRequest;
import com.amazonaws.services.appfabric.model.CreateIngestionDestinationResult;
import com.amazonaws.services.appfabric.model.CreateIngestionRequest;
import com.amazonaws.services.appfabric.model.CreateIngestionResult;
import com.amazonaws.services.appfabric.model.DeleteAppAuthorizationRequest;
import com.amazonaws.services.appfabric.model.DeleteAppAuthorizationResult;
import com.amazonaws.services.appfabric.model.DeleteAppBundleRequest;
import com.amazonaws.services.appfabric.model.DeleteAppBundleResult;
import com.amazonaws.services.appfabric.model.DeleteIngestionDestinationRequest;
import com.amazonaws.services.appfabric.model.DeleteIngestionDestinationResult;
import com.amazonaws.services.appfabric.model.DeleteIngestionRequest;
import com.amazonaws.services.appfabric.model.DeleteIngestionResult;
import com.amazonaws.services.appfabric.model.GetAppAuthorizationRequest;
import com.amazonaws.services.appfabric.model.GetAppAuthorizationResult;
import com.amazonaws.services.appfabric.model.GetAppBundleRequest;
import com.amazonaws.services.appfabric.model.GetAppBundleResult;
import com.amazonaws.services.appfabric.model.GetIngestionDestinationRequest;
import com.amazonaws.services.appfabric.model.GetIngestionDestinationResult;
import com.amazonaws.services.appfabric.model.GetIngestionRequest;
import com.amazonaws.services.appfabric.model.GetIngestionResult;
import com.amazonaws.services.appfabric.model.ListAppAuthorizationsRequest;
import com.amazonaws.services.appfabric.model.ListAppAuthorizationsResult;
import com.amazonaws.services.appfabric.model.ListAppBundlesRequest;
import com.amazonaws.services.appfabric.model.ListAppBundlesResult;
import com.amazonaws.services.appfabric.model.ListIngestionDestinationsRequest;
import com.amazonaws.services.appfabric.model.ListIngestionDestinationsResult;
import com.amazonaws.services.appfabric.model.ListIngestionsRequest;
import com.amazonaws.services.appfabric.model.ListIngestionsResult;
import com.amazonaws.services.appfabric.model.ListTagsForResourceRequest;
import com.amazonaws.services.appfabric.model.ListTagsForResourceResult;
import com.amazonaws.services.appfabric.model.StartIngestionRequest;
import com.amazonaws.services.appfabric.model.StartIngestionResult;
import com.amazonaws.services.appfabric.model.StartUserAccessTasksRequest;
import com.amazonaws.services.appfabric.model.StartUserAccessTasksResult;
import com.amazonaws.services.appfabric.model.StopIngestionRequest;
import com.amazonaws.services.appfabric.model.StopIngestionResult;
import com.amazonaws.services.appfabric.model.TagResourceRequest;
import com.amazonaws.services.appfabric.model.TagResourceResult;
import com.amazonaws.services.appfabric.model.UntagResourceRequest;
import com.amazonaws.services.appfabric.model.UntagResourceResult;
import com.amazonaws.services.appfabric.model.UpdateAppAuthorizationRequest;
import com.amazonaws.services.appfabric.model.UpdateAppAuthorizationResult;
import com.amazonaws.services.appfabric.model.UpdateIngestionDestinationRequest;
import com.amazonaws.services.appfabric.model.UpdateIngestionDestinationResult;
import com.amazonaws.services.appfabric.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.BatchGetUserAccessTasksRequestProtocolMarshaller;
import com.amazonaws.services.appfabric.model.transform.BatchGetUserAccessTasksResultJsonUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.ConnectAppAuthorizationRequestProtocolMarshaller;
import com.amazonaws.services.appfabric.model.transform.ConnectAppAuthorizationResultJsonUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.CreateAppAuthorizationRequestProtocolMarshaller;
import com.amazonaws.services.appfabric.model.transform.CreateAppAuthorizationResultJsonUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.CreateAppBundleRequestProtocolMarshaller;
import com.amazonaws.services.appfabric.model.transform.CreateAppBundleResultJsonUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.CreateIngestionDestinationRequestProtocolMarshaller;
import com.amazonaws.services.appfabric.model.transform.CreateIngestionDestinationResultJsonUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.CreateIngestionRequestProtocolMarshaller;
import com.amazonaws.services.appfabric.model.transform.CreateIngestionResultJsonUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.DeleteAppAuthorizationRequestProtocolMarshaller;
import com.amazonaws.services.appfabric.model.transform.DeleteAppAuthorizationResultJsonUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.DeleteAppBundleRequestProtocolMarshaller;
import com.amazonaws.services.appfabric.model.transform.DeleteAppBundleResultJsonUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.DeleteIngestionDestinationRequestProtocolMarshaller;
import com.amazonaws.services.appfabric.model.transform.DeleteIngestionDestinationResultJsonUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.DeleteIngestionRequestProtocolMarshaller;
import com.amazonaws.services.appfabric.model.transform.DeleteIngestionResultJsonUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.GetAppAuthorizationRequestProtocolMarshaller;
import com.amazonaws.services.appfabric.model.transform.GetAppAuthorizationResultJsonUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.GetAppBundleRequestProtocolMarshaller;
import com.amazonaws.services.appfabric.model.transform.GetAppBundleResultJsonUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.GetIngestionDestinationRequestProtocolMarshaller;
import com.amazonaws.services.appfabric.model.transform.GetIngestionDestinationResultJsonUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.GetIngestionRequestProtocolMarshaller;
import com.amazonaws.services.appfabric.model.transform.GetIngestionResultJsonUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.ListAppAuthorizationsRequestProtocolMarshaller;
import com.amazonaws.services.appfabric.model.transform.ListAppAuthorizationsResultJsonUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.ListAppBundlesRequestProtocolMarshaller;
import com.amazonaws.services.appfabric.model.transform.ListAppBundlesResultJsonUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.ListIngestionDestinationsRequestProtocolMarshaller;
import com.amazonaws.services.appfabric.model.transform.ListIngestionDestinationsResultJsonUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.ListIngestionsRequestProtocolMarshaller;
import com.amazonaws.services.appfabric.model.transform.ListIngestionsResultJsonUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.appfabric.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.StartIngestionRequestProtocolMarshaller;
import com.amazonaws.services.appfabric.model.transform.StartIngestionResultJsonUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.StartUserAccessTasksRequestProtocolMarshaller;
import com.amazonaws.services.appfabric.model.transform.StartUserAccessTasksResultJsonUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.StopIngestionRequestProtocolMarshaller;
import com.amazonaws.services.appfabric.model.transform.StopIngestionResultJsonUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.appfabric.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.appfabric.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.UpdateAppAuthorizationRequestProtocolMarshaller;
import com.amazonaws.services.appfabric.model.transform.UpdateAppAuthorizationResultJsonUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.UpdateIngestionDestinationRequestProtocolMarshaller;
import com.amazonaws.services.appfabric.model.transform.UpdateIngestionDestinationResultJsonUnmarshaller;
import com.amazonaws.services.appfabric.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSAppFabricClient
extends AmazonWebServiceClient
implements AWSAppFabric {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSAppFabric.class);
    private static final String DEFAULT_SIGNING_NAME = "appfabric";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSAppFabricException.class));

    public static AWSAppFabricClientBuilder builder() {
        return AWSAppFabricClientBuilder.standard();
    }

    AWSAppFabricClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSAppFabricClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("appfabric.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/appfabric/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/appfabric/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BatchGetUserAccessTasksResult batchGetUserAccessTasks(BatchGetUserAccessTasksRequest request) {
        request = (BatchGetUserAccessTasksRequest)this.beforeClientExecution(request);
        return this.executeBatchGetUserAccessTasks(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchGetUserAccessTasksResult executeBatchGetUserAccessTasks(BatchGetUserAccessTasksRequest batchGetUserAccessTasksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchGetUserAccessTasksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchGetUserAccessTasksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchGetUserAccessTasksRequestProtocolMarshaller(protocolFactory).marshall((BatchGetUserAccessTasksRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchGetUserAccessTasksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppFabric");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchGetUserAccessTasks");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchGetUserAccessTasksResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchGetUserAccessTasksResult batchGetUserAccessTasksResult = (BatchGetUserAccessTasksResult)response.getAwsResponse();
            return batchGetUserAccessTasksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ConnectAppAuthorizationResult connectAppAuthorization(ConnectAppAuthorizationRequest request) {
        request = (ConnectAppAuthorizationRequest)this.beforeClientExecution(request);
        return this.executeConnectAppAuthorization(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ConnectAppAuthorizationResult executeConnectAppAuthorization(ConnectAppAuthorizationRequest connectAppAuthorizationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(connectAppAuthorizationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ConnectAppAuthorizationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ConnectAppAuthorizationRequestProtocolMarshaller(protocolFactory).marshall((ConnectAppAuthorizationRequest)super.beforeMarshalling((AmazonWebServiceRequest)connectAppAuthorizationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppFabric");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ConnectAppAuthorization");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ConnectAppAuthorizationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ConnectAppAuthorizationResult connectAppAuthorizationResult = (ConnectAppAuthorizationResult)response.getAwsResponse();
            return connectAppAuthorizationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateAppAuthorizationResult createAppAuthorization(CreateAppAuthorizationRequest request) {
        request = (CreateAppAuthorizationRequest)this.beforeClientExecution(request);
        return this.executeCreateAppAuthorization(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateAppAuthorizationResult executeCreateAppAuthorization(CreateAppAuthorizationRequest createAppAuthorizationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAppAuthorizationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAppAuthorizationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAppAuthorizationRequestProtocolMarshaller(protocolFactory).marshall((CreateAppAuthorizationRequest)super.beforeMarshalling((AmazonWebServiceRequest)createAppAuthorizationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppFabric");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateAppAuthorization");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateAppAuthorizationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateAppAuthorizationResult createAppAuthorizationResult = (CreateAppAuthorizationResult)response.getAwsResponse();
            return createAppAuthorizationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateAppBundleResult createAppBundle(CreateAppBundleRequest request) {
        request = (CreateAppBundleRequest)this.beforeClientExecution(request);
        return this.executeCreateAppBundle(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateAppBundleResult executeCreateAppBundle(CreateAppBundleRequest createAppBundleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAppBundleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAppBundleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAppBundleRequestProtocolMarshaller(protocolFactory).marshall((CreateAppBundleRequest)super.beforeMarshalling((AmazonWebServiceRequest)createAppBundleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppFabric");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateAppBundle");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateAppBundleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateAppBundleResult createAppBundleResult = (CreateAppBundleResult)response.getAwsResponse();
            return createAppBundleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateIngestionResult createIngestion(CreateIngestionRequest request) {
        request = (CreateIngestionRequest)this.beforeClientExecution(request);
        return this.executeCreateIngestion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateIngestionResult executeCreateIngestion(CreateIngestionRequest createIngestionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createIngestionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateIngestionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateIngestionRequestProtocolMarshaller(protocolFactory).marshall((CreateIngestionRequest)super.beforeMarshalling((AmazonWebServiceRequest)createIngestionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppFabric");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateIngestion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateIngestionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateIngestionResult createIngestionResult = (CreateIngestionResult)response.getAwsResponse();
            return createIngestionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateIngestionDestinationResult createIngestionDestination(CreateIngestionDestinationRequest request) {
        request = (CreateIngestionDestinationRequest)this.beforeClientExecution(request);
        return this.executeCreateIngestionDestination(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateIngestionDestinationResult executeCreateIngestionDestination(CreateIngestionDestinationRequest createIngestionDestinationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createIngestionDestinationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateIngestionDestinationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateIngestionDestinationRequestProtocolMarshaller(protocolFactory).marshall((CreateIngestionDestinationRequest)super.beforeMarshalling((AmazonWebServiceRequest)createIngestionDestinationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppFabric");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateIngestionDestination");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateIngestionDestinationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateIngestionDestinationResult createIngestionDestinationResult = (CreateIngestionDestinationResult)response.getAwsResponse();
            return createIngestionDestinationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteAppAuthorizationResult deleteAppAuthorization(DeleteAppAuthorizationRequest request) {
        request = (DeleteAppAuthorizationRequest)this.beforeClientExecution(request);
        return this.executeDeleteAppAuthorization(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAppAuthorizationResult executeDeleteAppAuthorization(DeleteAppAuthorizationRequest deleteAppAuthorizationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAppAuthorizationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAppAuthorizationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAppAuthorizationRequestProtocolMarshaller(protocolFactory).marshall((DeleteAppAuthorizationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAppAuthorizationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppFabric");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteAppAuthorization");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteAppAuthorizationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAppAuthorizationResult deleteAppAuthorizationResult = (DeleteAppAuthorizationResult)response.getAwsResponse();
            return deleteAppAuthorizationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteAppBundleResult deleteAppBundle(DeleteAppBundleRequest request) {
        request = (DeleteAppBundleRequest)this.beforeClientExecution(request);
        return this.executeDeleteAppBundle(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAppBundleResult executeDeleteAppBundle(DeleteAppBundleRequest deleteAppBundleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAppBundleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAppBundleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAppBundleRequestProtocolMarshaller(protocolFactory).marshall((DeleteAppBundleRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAppBundleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppFabric");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteAppBundle");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteAppBundleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAppBundleResult deleteAppBundleResult = (DeleteAppBundleResult)response.getAwsResponse();
            return deleteAppBundleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteIngestionResult deleteIngestion(DeleteIngestionRequest request) {
        request = (DeleteIngestionRequest)this.beforeClientExecution(request);
        return this.executeDeleteIngestion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteIngestionResult executeDeleteIngestion(DeleteIngestionRequest deleteIngestionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteIngestionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteIngestionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteIngestionRequestProtocolMarshaller(protocolFactory).marshall((DeleteIngestionRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteIngestionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppFabric");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteIngestion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteIngestionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteIngestionResult deleteIngestionResult = (DeleteIngestionResult)response.getAwsResponse();
            return deleteIngestionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteIngestionDestinationResult deleteIngestionDestination(DeleteIngestionDestinationRequest request) {
        request = (DeleteIngestionDestinationRequest)this.beforeClientExecution(request);
        return this.executeDeleteIngestionDestination(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteIngestionDestinationResult executeDeleteIngestionDestination(DeleteIngestionDestinationRequest deleteIngestionDestinationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteIngestionDestinationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteIngestionDestinationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteIngestionDestinationRequestProtocolMarshaller(protocolFactory).marshall((DeleteIngestionDestinationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteIngestionDestinationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppFabric");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteIngestionDestination");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteIngestionDestinationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteIngestionDestinationResult deleteIngestionDestinationResult = (DeleteIngestionDestinationResult)response.getAwsResponse();
            return deleteIngestionDestinationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAppAuthorizationResult getAppAuthorization(GetAppAuthorizationRequest request) {
        request = (GetAppAuthorizationRequest)this.beforeClientExecution(request);
        return this.executeGetAppAuthorization(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAppAuthorizationResult executeGetAppAuthorization(GetAppAuthorizationRequest getAppAuthorizationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAppAuthorizationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAppAuthorizationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAppAuthorizationRequestProtocolMarshaller(protocolFactory).marshall((GetAppAuthorizationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAppAuthorizationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppFabric");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAppAuthorization");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAppAuthorizationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetAppAuthorizationResult getAppAuthorizationResult = (GetAppAuthorizationResult)response.getAwsResponse();
            return getAppAuthorizationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAppBundleResult getAppBundle(GetAppBundleRequest request) {
        request = (GetAppBundleRequest)this.beforeClientExecution(request);
        return this.executeGetAppBundle(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAppBundleResult executeGetAppBundle(GetAppBundleRequest getAppBundleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAppBundleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAppBundleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAppBundleRequestProtocolMarshaller(protocolFactory).marshall((GetAppBundleRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAppBundleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppFabric");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAppBundle");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAppBundleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetAppBundleResult getAppBundleResult = (GetAppBundleResult)response.getAwsResponse();
            return getAppBundleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetIngestionResult getIngestion(GetIngestionRequest request) {
        request = (GetIngestionRequest)this.beforeClientExecution(request);
        return this.executeGetIngestion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetIngestionResult executeGetIngestion(GetIngestionRequest getIngestionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getIngestionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetIngestionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetIngestionRequestProtocolMarshaller(protocolFactory).marshall((GetIngestionRequest)super.beforeMarshalling((AmazonWebServiceRequest)getIngestionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppFabric");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetIngestion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetIngestionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetIngestionResult getIngestionResult = (GetIngestionResult)response.getAwsResponse();
            return getIngestionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetIngestionDestinationResult getIngestionDestination(GetIngestionDestinationRequest request) {
        request = (GetIngestionDestinationRequest)this.beforeClientExecution(request);
        return this.executeGetIngestionDestination(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetIngestionDestinationResult executeGetIngestionDestination(GetIngestionDestinationRequest getIngestionDestinationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getIngestionDestinationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetIngestionDestinationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetIngestionDestinationRequestProtocolMarshaller(protocolFactory).marshall((GetIngestionDestinationRequest)super.beforeMarshalling((AmazonWebServiceRequest)getIngestionDestinationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppFabric");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetIngestionDestination");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetIngestionDestinationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetIngestionDestinationResult getIngestionDestinationResult = (GetIngestionDestinationResult)response.getAwsResponse();
            return getIngestionDestinationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAppAuthorizationsResult listAppAuthorizations(ListAppAuthorizationsRequest request) {
        request = (ListAppAuthorizationsRequest)this.beforeClientExecution(request);
        return this.executeListAppAuthorizations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAppAuthorizationsResult executeListAppAuthorizations(ListAppAuthorizationsRequest listAppAuthorizationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAppAuthorizationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAppAuthorizationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAppAuthorizationsRequestProtocolMarshaller(protocolFactory).marshall((ListAppAuthorizationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAppAuthorizationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppFabric");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAppAuthorizations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAppAuthorizationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAppAuthorizationsResult listAppAuthorizationsResult = (ListAppAuthorizationsResult)response.getAwsResponse();
            return listAppAuthorizationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAppBundlesResult listAppBundles(ListAppBundlesRequest request) {
        request = (ListAppBundlesRequest)this.beforeClientExecution(request);
        return this.executeListAppBundles(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAppBundlesResult executeListAppBundles(ListAppBundlesRequest listAppBundlesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAppBundlesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAppBundlesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAppBundlesRequestProtocolMarshaller(protocolFactory).marshall((ListAppBundlesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAppBundlesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppFabric");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAppBundles");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAppBundlesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAppBundlesResult listAppBundlesResult = (ListAppBundlesResult)response.getAwsResponse();
            return listAppBundlesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListIngestionDestinationsResult listIngestionDestinations(ListIngestionDestinationsRequest request) {
        request = (ListIngestionDestinationsRequest)this.beforeClientExecution(request);
        return this.executeListIngestionDestinations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListIngestionDestinationsResult executeListIngestionDestinations(ListIngestionDestinationsRequest listIngestionDestinationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listIngestionDestinationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListIngestionDestinationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListIngestionDestinationsRequestProtocolMarshaller(protocolFactory).marshall((ListIngestionDestinationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listIngestionDestinationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppFabric");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListIngestionDestinations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListIngestionDestinationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListIngestionDestinationsResult listIngestionDestinationsResult = (ListIngestionDestinationsResult)response.getAwsResponse();
            return listIngestionDestinationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListIngestionsResult listIngestions(ListIngestionsRequest request) {
        request = (ListIngestionsRequest)this.beforeClientExecution(request);
        return this.executeListIngestions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListIngestionsResult executeListIngestions(ListIngestionsRequest listIngestionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listIngestionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListIngestionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListIngestionsRequestProtocolMarshaller(protocolFactory).marshall((ListIngestionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listIngestionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppFabric");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListIngestions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListIngestionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListIngestionsResult listIngestionsResult = (ListIngestionsResult)response.getAwsResponse();
            return listIngestionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppFabric");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartIngestionResult startIngestion(StartIngestionRequest request) {
        request = (StartIngestionRequest)this.beforeClientExecution(request);
        return this.executeStartIngestion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartIngestionResult executeStartIngestion(StartIngestionRequest startIngestionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startIngestionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartIngestionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartIngestionRequestProtocolMarshaller(protocolFactory).marshall((StartIngestionRequest)super.beforeMarshalling((AmazonWebServiceRequest)startIngestionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppFabric");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartIngestion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartIngestionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartIngestionResult startIngestionResult = (StartIngestionResult)response.getAwsResponse();
            return startIngestionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartUserAccessTasksResult startUserAccessTasks(StartUserAccessTasksRequest request) {
        request = (StartUserAccessTasksRequest)this.beforeClientExecution(request);
        return this.executeStartUserAccessTasks(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartUserAccessTasksResult executeStartUserAccessTasks(StartUserAccessTasksRequest startUserAccessTasksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startUserAccessTasksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartUserAccessTasksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartUserAccessTasksRequestProtocolMarshaller(protocolFactory).marshall((StartUserAccessTasksRequest)super.beforeMarshalling((AmazonWebServiceRequest)startUserAccessTasksRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppFabric");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartUserAccessTasks");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartUserAccessTasksResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartUserAccessTasksResult startUserAccessTasksResult = (StartUserAccessTasksResult)response.getAwsResponse();
            return startUserAccessTasksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopIngestionResult stopIngestion(StopIngestionRequest request) {
        request = (StopIngestionRequest)this.beforeClientExecution(request);
        return this.executeStopIngestion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopIngestionResult executeStopIngestion(StopIngestionRequest stopIngestionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopIngestionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopIngestionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopIngestionRequestProtocolMarshaller(protocolFactory).marshall((StopIngestionRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopIngestionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppFabric");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopIngestion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopIngestionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopIngestionResult stopIngestionResult = (StopIngestionResult)response.getAwsResponse();
            return stopIngestionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppFabric");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppFabric");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateAppAuthorizationResult updateAppAuthorization(UpdateAppAuthorizationRequest request) {
        request = (UpdateAppAuthorizationRequest)this.beforeClientExecution(request);
        return this.executeUpdateAppAuthorization(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateAppAuthorizationResult executeUpdateAppAuthorization(UpdateAppAuthorizationRequest updateAppAuthorizationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateAppAuthorizationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateAppAuthorizationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateAppAuthorizationRequestProtocolMarshaller(protocolFactory).marshall((UpdateAppAuthorizationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateAppAuthorizationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppFabric");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateAppAuthorization");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateAppAuthorizationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateAppAuthorizationResult updateAppAuthorizationResult = (UpdateAppAuthorizationResult)response.getAwsResponse();
            return updateAppAuthorizationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateIngestionDestinationResult updateIngestionDestination(UpdateIngestionDestinationRequest request) {
        request = (UpdateIngestionDestinationRequest)this.beforeClientExecution(request);
        return this.executeUpdateIngestionDestination(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateIngestionDestinationResult executeUpdateIngestionDestination(UpdateIngestionDestinationRequest updateIngestionDestinationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateIngestionDestinationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateIngestionDestinationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateIngestionDestinationRequestProtocolMarshaller(protocolFactory).marshall((UpdateIngestionDestinationRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateIngestionDestinationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AppFabric");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateIngestionDestination");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateIngestionDestinationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateIngestionDestinationResult updateIngestionDestinationResult = (UpdateIngestionDestinationResult)response.getAwsResponse();
            return updateIngestionDestinationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

