/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.GetIntegrationResponseRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetIntegrationResponseRequestMarshaller
implements Marshaller<Request<GetIntegrationResponseRequest>, GetIntegrationResponseRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<GetIntegrationResponseRequest> marshall(GetIntegrationResponseRequest getIntegrationResponseRequest) {
        if (getIntegrationResponseRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getIntegrationResponseRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration/responses/{status_code}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getIntegrationResponseRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)getIntegrationResponseRequest.getRestApiId()));
        uriResourcePath = uriResourcePath.replace("{resource_id}", getIntegrationResponseRequest.getResourceId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)getIntegrationResponseRequest.getResourceId()));
        uriResourcePath = uriResourcePath.replace("{http_method}", getIntegrationResponseRequest.getHttpMethod() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)getIntegrationResponseRequest.getHttpMethod()));
        uriResourcePath = uriResourcePath.replace("{status_code}", getIntegrationResponseRequest.getStatusCode() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)getIntegrationResponseRequest.getStatusCode()));
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

