/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.GetIntegrationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetIntegrationRequestMarshaller
implements Marshaller<Request<GetIntegrationRequest>, GetIntegrationRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<GetIntegrationRequest> marshall(GetIntegrationRequest getIntegrationRequest) {
        if (getIntegrationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getIntegrationRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getIntegrationRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)getIntegrationRequest.getRestApiId()));
        uriResourcePath = uriResourcePath.replace("{resource_id}", getIntegrationRequest.getResourceId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)getIntegrationRequest.getResourceId()));
        uriResourcePath = uriResourcePath.replace("{http_method}", getIntegrationRequest.getHttpMethod() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)getIntegrationRequest.getHttpMethod()));
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

