/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.GetAuthorizersRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetAuthorizersRequestMarshaller
implements Marshaller<Request<GetAuthorizersRequest>, GetAuthorizersRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<GetAuthorizersRequest> marshall(GetAuthorizersRequest getAuthorizersRequest) {
        String limit;
        String position;
        if (getAuthorizersRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getAuthorizersRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/authorizers";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getAuthorizersRequest.getRestApiId() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString((String)getAuthorizersRequest.getRestApiId()));
        request.setResourcePath(uriResourcePath);
        String string = position = getAuthorizersRequest.getPosition() == null ? null : StringUtils.fromString((String)getAuthorizersRequest.getPosition());
        if (position != null) {
            request.addParameter("position", position);
        }
        String string2 = limit = getAuthorizersRequest.getLimit() == null ? null : StringUtils.fromInteger((Integer)getAuthorizersRequest.getLimit());
        if (limit != null) {
            request.addParameter("limit", limit);
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

