/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.amplify.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.amplify.model.AutoBranchCreationConfig;
import com.amazonaws.services.amplify.model.CustomRule;
import com.amazonaws.services.amplify.model.Platform;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateAppRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String appId;
    private String name;
    private String description;
    private String platform;
    private String iamServiceRoleArn;
    private Map<String, String> environmentVariables;
    private Boolean enableBranchAutoBuild;
    private Boolean enableBranchAutoDeletion;
    private Boolean enableBasicAuth;
    private String basicAuthCredentials;
    private List<CustomRule> customRules;
    private String buildSpec;
    private String customHeaders;
    private Boolean enableAutoBranchCreation;
    private List<String> autoBranchCreationPatterns;
    private AutoBranchCreationConfig autoBranchCreationConfig;
    private String repository;
    private String oauthToken;
    private String accessToken;

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppId() {
        return this.appId;
    }

    public UpdateAppRequest withAppId(String appId) {
        this.setAppId(appId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public UpdateAppRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateAppRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getPlatform() {
        return this.platform;
    }

    public UpdateAppRequest withPlatform(String platform) {
        this.setPlatform(platform);
        return this;
    }

    public UpdateAppRequest withPlatform(Platform platform) {
        this.platform = platform.toString();
        return this;
    }

    public void setIamServiceRoleArn(String iamServiceRoleArn) {
        this.iamServiceRoleArn = iamServiceRoleArn;
    }

    public String getIamServiceRoleArn() {
        return this.iamServiceRoleArn;
    }

    public UpdateAppRequest withIamServiceRoleArn(String iamServiceRoleArn) {
        this.setIamServiceRoleArn(iamServiceRoleArn);
        return this;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public UpdateAppRequest withEnvironmentVariables(Map<String, String> environmentVariables) {
        this.setEnvironmentVariables(environmentVariables);
        return this;
    }

    public UpdateAppRequest addEnvironmentVariablesEntry(String key, String value) {
        if (null == this.environmentVariables) {
            this.environmentVariables = new HashMap<String, String>();
        }
        if (this.environmentVariables.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.environmentVariables.put(key, value);
        return this;
    }

    public UpdateAppRequest clearEnvironmentVariablesEntries() {
        this.environmentVariables = null;
        return this;
    }

    public void setEnableBranchAutoBuild(Boolean enableBranchAutoBuild) {
        this.enableBranchAutoBuild = enableBranchAutoBuild;
    }

    public Boolean getEnableBranchAutoBuild() {
        return this.enableBranchAutoBuild;
    }

    public UpdateAppRequest withEnableBranchAutoBuild(Boolean enableBranchAutoBuild) {
        this.setEnableBranchAutoBuild(enableBranchAutoBuild);
        return this;
    }

    public Boolean isEnableBranchAutoBuild() {
        return this.enableBranchAutoBuild;
    }

    public void setEnableBranchAutoDeletion(Boolean enableBranchAutoDeletion) {
        this.enableBranchAutoDeletion = enableBranchAutoDeletion;
    }

    public Boolean getEnableBranchAutoDeletion() {
        return this.enableBranchAutoDeletion;
    }

    public UpdateAppRequest withEnableBranchAutoDeletion(Boolean enableBranchAutoDeletion) {
        this.setEnableBranchAutoDeletion(enableBranchAutoDeletion);
        return this;
    }

    public Boolean isEnableBranchAutoDeletion() {
        return this.enableBranchAutoDeletion;
    }

    public void setEnableBasicAuth(Boolean enableBasicAuth) {
        this.enableBasicAuth = enableBasicAuth;
    }

    public Boolean getEnableBasicAuth() {
        return this.enableBasicAuth;
    }

    public UpdateAppRequest withEnableBasicAuth(Boolean enableBasicAuth) {
        this.setEnableBasicAuth(enableBasicAuth);
        return this;
    }

    public Boolean isEnableBasicAuth() {
        return this.enableBasicAuth;
    }

    public void setBasicAuthCredentials(String basicAuthCredentials) {
        this.basicAuthCredentials = basicAuthCredentials;
    }

    public String getBasicAuthCredentials() {
        return this.basicAuthCredentials;
    }

    public UpdateAppRequest withBasicAuthCredentials(String basicAuthCredentials) {
        this.setBasicAuthCredentials(basicAuthCredentials);
        return this;
    }

    public List<CustomRule> getCustomRules() {
        return this.customRules;
    }

    public void setCustomRules(Collection<CustomRule> customRules) {
        if (customRules == null) {
            this.customRules = null;
            return;
        }
        this.customRules = new ArrayList<CustomRule>(customRules);
    }

    public UpdateAppRequest withCustomRules(CustomRule ... customRules) {
        if (this.customRules == null) {
            this.setCustomRules(new ArrayList<CustomRule>(customRules.length));
        }
        for (CustomRule ele : customRules) {
            this.customRules.add(ele);
        }
        return this;
    }

    public UpdateAppRequest withCustomRules(Collection<CustomRule> customRules) {
        this.setCustomRules(customRules);
        return this;
    }

    public void setBuildSpec(String buildSpec) {
        this.buildSpec = buildSpec;
    }

    public String getBuildSpec() {
        return this.buildSpec;
    }

    public UpdateAppRequest withBuildSpec(String buildSpec) {
        this.setBuildSpec(buildSpec);
        return this;
    }

    public void setCustomHeaders(String customHeaders) {
        this.customHeaders = customHeaders;
    }

    public String getCustomHeaders() {
        return this.customHeaders;
    }

    public UpdateAppRequest withCustomHeaders(String customHeaders) {
        this.setCustomHeaders(customHeaders);
        return this;
    }

    public void setEnableAutoBranchCreation(Boolean enableAutoBranchCreation) {
        this.enableAutoBranchCreation = enableAutoBranchCreation;
    }

    public Boolean getEnableAutoBranchCreation() {
        return this.enableAutoBranchCreation;
    }

    public UpdateAppRequest withEnableAutoBranchCreation(Boolean enableAutoBranchCreation) {
        this.setEnableAutoBranchCreation(enableAutoBranchCreation);
        return this;
    }

    public Boolean isEnableAutoBranchCreation() {
        return this.enableAutoBranchCreation;
    }

    public List<String> getAutoBranchCreationPatterns() {
        return this.autoBranchCreationPatterns;
    }

    public void setAutoBranchCreationPatterns(Collection<String> autoBranchCreationPatterns) {
        if (autoBranchCreationPatterns == null) {
            this.autoBranchCreationPatterns = null;
            return;
        }
        this.autoBranchCreationPatterns = new ArrayList<String>(autoBranchCreationPatterns);
    }

    public UpdateAppRequest withAutoBranchCreationPatterns(String ... autoBranchCreationPatterns) {
        if (this.autoBranchCreationPatterns == null) {
            this.setAutoBranchCreationPatterns(new ArrayList<String>(autoBranchCreationPatterns.length));
        }
        for (String ele : autoBranchCreationPatterns) {
            this.autoBranchCreationPatterns.add(ele);
        }
        return this;
    }

    public UpdateAppRequest withAutoBranchCreationPatterns(Collection<String> autoBranchCreationPatterns) {
        this.setAutoBranchCreationPatterns(autoBranchCreationPatterns);
        return this;
    }

    public void setAutoBranchCreationConfig(AutoBranchCreationConfig autoBranchCreationConfig) {
        this.autoBranchCreationConfig = autoBranchCreationConfig;
    }

    public AutoBranchCreationConfig getAutoBranchCreationConfig() {
        return this.autoBranchCreationConfig;
    }

    public UpdateAppRequest withAutoBranchCreationConfig(AutoBranchCreationConfig autoBranchCreationConfig) {
        this.setAutoBranchCreationConfig(autoBranchCreationConfig);
        return this;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getRepository() {
        return this.repository;
    }

    public UpdateAppRequest withRepository(String repository) {
        this.setRepository(repository);
        return this;
    }

    public void setOauthToken(String oauthToken) {
        this.oauthToken = oauthToken;
    }

    public String getOauthToken() {
        return this.oauthToken;
    }

    public UpdateAppRequest withOauthToken(String oauthToken) {
        this.setOauthToken(oauthToken);
        return this;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public UpdateAppRequest withAccessToken(String accessToken) {
        this.setAccessToken(accessToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAppId() != null) {
            sb.append("AppId: ").append(this.getAppId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getPlatform() != null) {
            sb.append("Platform: ").append(this.getPlatform()).append(",");
        }
        if (this.getIamServiceRoleArn() != null) {
            sb.append("IamServiceRoleArn: ").append(this.getIamServiceRoleArn()).append(",");
        }
        if (this.getEnvironmentVariables() != null) {
            sb.append("EnvironmentVariables: ").append(this.getEnvironmentVariables()).append(",");
        }
        if (this.getEnableBranchAutoBuild() != null) {
            sb.append("EnableBranchAutoBuild: ").append(this.getEnableBranchAutoBuild()).append(",");
        }
        if (this.getEnableBranchAutoDeletion() != null) {
            sb.append("EnableBranchAutoDeletion: ").append(this.getEnableBranchAutoDeletion()).append(",");
        }
        if (this.getEnableBasicAuth() != null) {
            sb.append("EnableBasicAuth: ").append(this.getEnableBasicAuth()).append(",");
        }
        if (this.getBasicAuthCredentials() != null) {
            sb.append("BasicAuthCredentials: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getCustomRules() != null) {
            sb.append("CustomRules: ").append(this.getCustomRules()).append(",");
        }
        if (this.getBuildSpec() != null) {
            sb.append("BuildSpec: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getCustomHeaders() != null) {
            sb.append("CustomHeaders: ").append(this.getCustomHeaders()).append(",");
        }
        if (this.getEnableAutoBranchCreation() != null) {
            sb.append("EnableAutoBranchCreation: ").append(this.getEnableAutoBranchCreation()).append(",");
        }
        if (this.getAutoBranchCreationPatterns() != null) {
            sb.append("AutoBranchCreationPatterns: ").append(this.getAutoBranchCreationPatterns()).append(",");
        }
        if (this.getAutoBranchCreationConfig() != null) {
            sb.append("AutoBranchCreationConfig: ").append(this.getAutoBranchCreationConfig()).append(",");
        }
        if (this.getRepository() != null) {
            sb.append("Repository: ").append(this.getRepository()).append(",");
        }
        if (this.getOauthToken() != null) {
            sb.append("OauthToken: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getAccessToken() != null) {
            sb.append("AccessToken: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAppRequest)) {
            return false;
        }
        UpdateAppRequest other = (UpdateAppRequest)obj;
        if (other.getAppId() == null ^ this.getAppId() == null) {
            return false;
        }
        if (other.getAppId() != null && !other.getAppId().equals(this.getAppId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getPlatform() == null ^ this.getPlatform() == null) {
            return false;
        }
        if (other.getPlatform() != null && !other.getPlatform().equals(this.getPlatform())) {
            return false;
        }
        if (other.getIamServiceRoleArn() == null ^ this.getIamServiceRoleArn() == null) {
            return false;
        }
        if (other.getIamServiceRoleArn() != null && !other.getIamServiceRoleArn().equals(this.getIamServiceRoleArn())) {
            return false;
        }
        if (other.getEnvironmentVariables() == null ^ this.getEnvironmentVariables() == null) {
            return false;
        }
        if (other.getEnvironmentVariables() != null && !other.getEnvironmentVariables().equals(this.getEnvironmentVariables())) {
            return false;
        }
        if (other.getEnableBranchAutoBuild() == null ^ this.getEnableBranchAutoBuild() == null) {
            return false;
        }
        if (other.getEnableBranchAutoBuild() != null && !other.getEnableBranchAutoBuild().equals(this.getEnableBranchAutoBuild())) {
            return false;
        }
        if (other.getEnableBranchAutoDeletion() == null ^ this.getEnableBranchAutoDeletion() == null) {
            return false;
        }
        if (other.getEnableBranchAutoDeletion() != null && !other.getEnableBranchAutoDeletion().equals(this.getEnableBranchAutoDeletion())) {
            return false;
        }
        if (other.getEnableBasicAuth() == null ^ this.getEnableBasicAuth() == null) {
            return false;
        }
        if (other.getEnableBasicAuth() != null && !other.getEnableBasicAuth().equals(this.getEnableBasicAuth())) {
            return false;
        }
        if (other.getBasicAuthCredentials() == null ^ this.getBasicAuthCredentials() == null) {
            return false;
        }
        if (other.getBasicAuthCredentials() != null && !other.getBasicAuthCredentials().equals(this.getBasicAuthCredentials())) {
            return false;
        }
        if (other.getCustomRules() == null ^ this.getCustomRules() == null) {
            return false;
        }
        if (other.getCustomRules() != null && !other.getCustomRules().equals(this.getCustomRules())) {
            return false;
        }
        if (other.getBuildSpec() == null ^ this.getBuildSpec() == null) {
            return false;
        }
        if (other.getBuildSpec() != null && !other.getBuildSpec().equals(this.getBuildSpec())) {
            return false;
        }
        if (other.getCustomHeaders() == null ^ this.getCustomHeaders() == null) {
            return false;
        }
        if (other.getCustomHeaders() != null && !other.getCustomHeaders().equals(this.getCustomHeaders())) {
            return false;
        }
        if (other.getEnableAutoBranchCreation() == null ^ this.getEnableAutoBranchCreation() == null) {
            return false;
        }
        if (other.getEnableAutoBranchCreation() != null && !other.getEnableAutoBranchCreation().equals(this.getEnableAutoBranchCreation())) {
            return false;
        }
        if (other.getAutoBranchCreationPatterns() == null ^ this.getAutoBranchCreationPatterns() == null) {
            return false;
        }
        if (other.getAutoBranchCreationPatterns() != null && !other.getAutoBranchCreationPatterns().equals(this.getAutoBranchCreationPatterns())) {
            return false;
        }
        if (other.getAutoBranchCreationConfig() == null ^ this.getAutoBranchCreationConfig() == null) {
            return false;
        }
        if (other.getAutoBranchCreationConfig() != null && !other.getAutoBranchCreationConfig().equals(this.getAutoBranchCreationConfig())) {
            return false;
        }
        if (other.getRepository() == null ^ this.getRepository() == null) {
            return false;
        }
        if (other.getRepository() != null && !other.getRepository().equals(this.getRepository())) {
            return false;
        }
        if (other.getOauthToken() == null ^ this.getOauthToken() == null) {
            return false;
        }
        if (other.getOauthToken() != null && !other.getOauthToken().equals(this.getOauthToken())) {
            return false;
        }
        if (other.getAccessToken() == null ^ this.getAccessToken() == null) {
            return false;
        }
        return other.getAccessToken() == null || other.getAccessToken().equals(this.getAccessToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAppId() == null ? 0 : this.getAppId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getPlatform() == null ? 0 : this.getPlatform().hashCode());
        hashCode = 31 * hashCode + (this.getIamServiceRoleArn() == null ? 0 : this.getIamServiceRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentVariables() == null ? 0 : this.getEnvironmentVariables().hashCode());
        hashCode = 31 * hashCode + (this.getEnableBranchAutoBuild() == null ? 0 : this.getEnableBranchAutoBuild().hashCode());
        hashCode = 31 * hashCode + (this.getEnableBranchAutoDeletion() == null ? 0 : this.getEnableBranchAutoDeletion().hashCode());
        hashCode = 31 * hashCode + (this.getEnableBasicAuth() == null ? 0 : this.getEnableBasicAuth().hashCode());
        hashCode = 31 * hashCode + (this.getBasicAuthCredentials() == null ? 0 : this.getBasicAuthCredentials().hashCode());
        hashCode = 31 * hashCode + (this.getCustomRules() == null ? 0 : this.getCustomRules().hashCode());
        hashCode = 31 * hashCode + (this.getBuildSpec() == null ? 0 : this.getBuildSpec().hashCode());
        hashCode = 31 * hashCode + (this.getCustomHeaders() == null ? 0 : this.getCustomHeaders().hashCode());
        hashCode = 31 * hashCode + (this.getEnableAutoBranchCreation() == null ? 0 : this.getEnableAutoBranchCreation().hashCode());
        hashCode = 31 * hashCode + (this.getAutoBranchCreationPatterns() == null ? 0 : this.getAutoBranchCreationPatterns().hashCode());
        hashCode = 31 * hashCode + (this.getAutoBranchCreationConfig() == null ? 0 : this.getAutoBranchCreationConfig().hashCode());
        hashCode = 31 * hashCode + (this.getRepository() == null ? 0 : this.getRepository().hashCode());
        hashCode = 31 * hashCode + (this.getOauthToken() == null ? 0 : this.getOauthToken().hashCode());
        hashCode = 31 * hashCode + (this.getAccessToken() == null ? 0 : this.getAccessToken().hashCode());
        return hashCode;
    }

    public UpdateAppRequest clone() {
        return (UpdateAppRequest)super.clone();
    }
}

