/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.certificatemanager;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.PredefinedClientConfigurations;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.certificatemanager.AWSCertificateManagerAsync;
import com.amazonaws.services.certificatemanager.AWSCertificateManagerClient;
import com.amazonaws.services.certificatemanager.model.DeleteCertificateRequest;
import com.amazonaws.services.certificatemanager.model.DescribeCertificateRequest;
import com.amazonaws.services.certificatemanager.model.DescribeCertificateResult;
import com.amazonaws.services.certificatemanager.model.GetCertificateRequest;
import com.amazonaws.services.certificatemanager.model.GetCertificateResult;
import com.amazonaws.services.certificatemanager.model.ListCertificatesRequest;
import com.amazonaws.services.certificatemanager.model.ListCertificatesResult;
import com.amazonaws.services.certificatemanager.model.RequestCertificateRequest;
import com.amazonaws.services.certificatemanager.model.RequestCertificateResult;
import com.amazonaws.services.certificatemanager.model.ResendValidationEmailRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSCertificateManagerAsyncClient
extends AWSCertificateManagerClient
implements AWSCertificateManagerAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AWSCertificateManagerAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AWSCertificateManagerAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSCertificateManagerAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSCertificateManagerAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, PredefinedClientConfigurations.defaultConfig(), executorService);
    }

    public AWSCertificateManagerAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSCertificateManagerAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSCertificateManagerAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSCertificateManagerAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, PredefinedClientConfigurations.defaultConfig(), executorService);
    }

    public AWSCertificateManagerAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<Void> deleteCertificateAsync(DeleteCertificateRequest request) {
        return this.deleteCertificateAsync(request, null);
    }

    @Override
    public Future<Void> deleteCertificateAsync(final DeleteCertificateRequest request, final AsyncHandler<DeleteCertificateRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSCertificateManagerAsyncClient.this.deleteCertificate(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCertificateResult> describeCertificateAsync(DescribeCertificateRequest request) {
        return this.describeCertificateAsync(request, null);
    }

    @Override
    public Future<DescribeCertificateResult> describeCertificateAsync(final DescribeCertificateRequest request, final AsyncHandler<DescribeCertificateRequest, DescribeCertificateResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeCertificateResult>(){

            @Override
            public DescribeCertificateResult call() throws Exception {
                DescribeCertificateResult result;
                try {
                    result = AWSCertificateManagerAsyncClient.this.describeCertificate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCertificateResult> getCertificateAsync(GetCertificateRequest request) {
        return this.getCertificateAsync(request, null);
    }

    @Override
    public Future<GetCertificateResult> getCertificateAsync(final GetCertificateRequest request, final AsyncHandler<GetCertificateRequest, GetCertificateResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetCertificateResult>(){

            @Override
            public GetCertificateResult call() throws Exception {
                GetCertificateResult result;
                try {
                    result = AWSCertificateManagerAsyncClient.this.getCertificate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCertificatesResult> listCertificatesAsync(ListCertificatesRequest request) {
        return this.listCertificatesAsync(request, null);
    }

    @Override
    public Future<ListCertificatesResult> listCertificatesAsync(final ListCertificatesRequest request, final AsyncHandler<ListCertificatesRequest, ListCertificatesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListCertificatesResult>(){

            @Override
            public ListCertificatesResult call() throws Exception {
                ListCertificatesResult result;
                try {
                    result = AWSCertificateManagerAsyncClient.this.listCertificates(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RequestCertificateResult> requestCertificateAsync(RequestCertificateRequest request) {
        return this.requestCertificateAsync(request, null);
    }

    @Override
    public Future<RequestCertificateResult> requestCertificateAsync(final RequestCertificateRequest request, final AsyncHandler<RequestCertificateRequest, RequestCertificateResult> asyncHandler) {
        return this.executorService.submit(new Callable<RequestCertificateResult>(){

            @Override
            public RequestCertificateResult call() throws Exception {
                RequestCertificateResult result;
                try {
                    result = AWSCertificateManagerAsyncClient.this.requestCertificate(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Void> resendValidationEmailAsync(ResendValidationEmailRequest request) {
        return this.resendValidationEmailAsync(request, null);
    }

    @Override
    public Future<Void> resendValidationEmailAsync(final ResendValidationEmailRequest request, final AsyncHandler<ResendValidationEmailRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AWSCertificateManagerAsyncClient.this.resendValidationEmail(request);
                    result = null;
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

