/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.accessanalyzer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.accessanalyzer.model.S3AccessPointConfiguration;
import com.amazonaws.services.accessanalyzer.model.S3BucketAclGrantConfiguration;
import com.amazonaws.services.accessanalyzer.model.S3PublicAccessBlockConfiguration;
import com.amazonaws.services.accessanalyzer.model.transform.S3BucketConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class S3BucketConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String bucketPolicy;
    private List<S3BucketAclGrantConfiguration> bucketAclGrants;
    private S3PublicAccessBlockConfiguration bucketPublicAccessBlock;
    private Map<String, S3AccessPointConfiguration> accessPoints;

    public void setBucketPolicy(String bucketPolicy) {
        this.bucketPolicy = bucketPolicy;
    }

    public String getBucketPolicy() {
        return this.bucketPolicy;
    }

    public S3BucketConfiguration withBucketPolicy(String bucketPolicy) {
        this.setBucketPolicy(bucketPolicy);
        return this;
    }

    public List<S3BucketAclGrantConfiguration> getBucketAclGrants() {
        return this.bucketAclGrants;
    }

    public void setBucketAclGrants(Collection<S3BucketAclGrantConfiguration> bucketAclGrants) {
        if (bucketAclGrants == null) {
            this.bucketAclGrants = null;
            return;
        }
        this.bucketAclGrants = new ArrayList<S3BucketAclGrantConfiguration>(bucketAclGrants);
    }

    public S3BucketConfiguration withBucketAclGrants(S3BucketAclGrantConfiguration ... bucketAclGrants) {
        if (this.bucketAclGrants == null) {
            this.setBucketAclGrants(new ArrayList<S3BucketAclGrantConfiguration>(bucketAclGrants.length));
        }
        for (S3BucketAclGrantConfiguration ele : bucketAclGrants) {
            this.bucketAclGrants.add(ele);
        }
        return this;
    }

    public S3BucketConfiguration withBucketAclGrants(Collection<S3BucketAclGrantConfiguration> bucketAclGrants) {
        this.setBucketAclGrants(bucketAclGrants);
        return this;
    }

    public void setBucketPublicAccessBlock(S3PublicAccessBlockConfiguration bucketPublicAccessBlock) {
        this.bucketPublicAccessBlock = bucketPublicAccessBlock;
    }

    public S3PublicAccessBlockConfiguration getBucketPublicAccessBlock() {
        return this.bucketPublicAccessBlock;
    }

    public S3BucketConfiguration withBucketPublicAccessBlock(S3PublicAccessBlockConfiguration bucketPublicAccessBlock) {
        this.setBucketPublicAccessBlock(bucketPublicAccessBlock);
        return this;
    }

    public Map<String, S3AccessPointConfiguration> getAccessPoints() {
        return this.accessPoints;
    }

    public void setAccessPoints(Map<String, S3AccessPointConfiguration> accessPoints) {
        this.accessPoints = accessPoints;
    }

    public S3BucketConfiguration withAccessPoints(Map<String, S3AccessPointConfiguration> accessPoints) {
        this.setAccessPoints(accessPoints);
        return this;
    }

    public S3BucketConfiguration addAccessPointsEntry(String key, S3AccessPointConfiguration value) {
        if (null == this.accessPoints) {
            this.accessPoints = new HashMap<String, S3AccessPointConfiguration>();
        }
        if (this.accessPoints.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.accessPoints.put(key, value);
        return this;
    }

    public S3BucketConfiguration clearAccessPointsEntries() {
        this.accessPoints = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucketPolicy() != null) {
            sb.append("BucketPolicy: ").append(this.getBucketPolicy()).append(",");
        }
        if (this.getBucketAclGrants() != null) {
            sb.append("BucketAclGrants: ").append(this.getBucketAclGrants()).append(",");
        }
        if (this.getBucketPublicAccessBlock() != null) {
            sb.append("BucketPublicAccessBlock: ").append(this.getBucketPublicAccessBlock()).append(",");
        }
        if (this.getAccessPoints() != null) {
            sb.append("AccessPoints: ").append(this.getAccessPoints());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3BucketConfiguration)) {
            return false;
        }
        S3BucketConfiguration other = (S3BucketConfiguration)obj;
        if (other.getBucketPolicy() == null ^ this.getBucketPolicy() == null) {
            return false;
        }
        if (other.getBucketPolicy() != null && !other.getBucketPolicy().equals(this.getBucketPolicy())) {
            return false;
        }
        if (other.getBucketAclGrants() == null ^ this.getBucketAclGrants() == null) {
            return false;
        }
        if (other.getBucketAclGrants() != null && !other.getBucketAclGrants().equals(this.getBucketAclGrants())) {
            return false;
        }
        if (other.getBucketPublicAccessBlock() == null ^ this.getBucketPublicAccessBlock() == null) {
            return false;
        }
        if (other.getBucketPublicAccessBlock() != null && !other.getBucketPublicAccessBlock().equals(this.getBucketPublicAccessBlock())) {
            return false;
        }
        if (other.getAccessPoints() == null ^ this.getAccessPoints() == null) {
            return false;
        }
        return other.getAccessPoints() == null || other.getAccessPoints().equals(this.getAccessPoints());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucketPolicy() == null ? 0 : this.getBucketPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getBucketAclGrants() == null ? 0 : this.getBucketAclGrants().hashCode());
        hashCode = 31 * hashCode + (this.getBucketPublicAccessBlock() == null ? 0 : this.getBucketPublicAccessBlock().hashCode());
        hashCode = 31 * hashCode + (this.getAccessPoints() == null ? 0 : this.getAccessPoints().hashCode());
        return hashCode;
    }

    public S3BucketConfiguration clone() {
        try {
            return (S3BucketConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3BucketConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

