/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.model;

import com.aliyun.openservices.ots.model.PrimaryKeyValue;
import com.aliyun.openservices.ots.utils.CalculateHelper;
import com.aliyun.openservices.ots.utils.CodingUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RowPrimaryKey {
    private Map<String, PrimaryKeyValue> primaryKey = new HashMap<String, PrimaryKeyValue>();
    private int dataSize = -1;

    public Map<String, PrimaryKeyValue> getPrimaryKey() {
        return Collections.unmodifiableMap(this.primaryKey);
    }

    public RowPrimaryKey addPrimaryKeyColumn(String name, PrimaryKeyValue value) {
        CodingUtils.assertParameterNotNull(name, "name");
        CodingUtils.assertParameterNotNull(value, "value");
        this.primaryKey.put(name, value);
        this.dataSize = -1;
        return this;
    }

    public int getSize() {
        if (this.dataSize == -1) {
            this.dataSize = 0;
            for (Map.Entry<String, PrimaryKeyValue> entry : this.primaryKey.entrySet()) {
                this.dataSize += CalculateHelper.getStringDataSize(entry.getKey());
                this.dataSize += entry.getValue().getSize();
            }
        }
        return this.dataSize;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof RowPrimaryKey)) {
            return false;
        }
        RowPrimaryKey pk = (RowPrimaryKey)o;
        if (this.primaryKey.size() != pk.primaryKey.size()) {
            return false;
        }
        for (Map.Entry<String, PrimaryKeyValue> entry : this.primaryKey.entrySet()) {
            PrimaryKeyValue value = pk.primaryKey.get(entry.getKey());
            if (value == null) {
                return false;
            }
            if (value.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        for (Map.Entry<String, PrimaryKeyValue> entry : this.primaryKey.entrySet()) {
            result = 31 * result + entry.getKey().hashCode();
            result = 31 * result + entry.getValue().hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, PrimaryKeyValue> pk : this.primaryKey.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(pk.getKey());
            sb.append(":");
            sb.append(pk.getValue());
        }
        return sb.toString();
    }
}

