/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.openservices.ots.ClientException;
import com.aliyun.openservices.ots.comm.ExecutionContext;
import com.aliyun.openservices.ots.comm.ResponseHandler;
import com.aliyun.openservices.ots.comm.ResponseMessage;
import com.aliyun.openservices.ots.internal.OTSTraceLogger;
import com.aliyun.openservices.ots.internal.model.ResponseContentWithMeta;
import com.aliyun.openservices.ots.log.LogUtil;
import com.aliyun.openservices.ots.parser.ResultParseException;
import com.aliyun.openservices.ots.parser.ResultParser;
import com.aliyun.openservices.ots.utils.ResourceManager;
import java.io.IOException;
import java.util.List;
import org.apache.http.ContentTooLongException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.ContentBufferEntity;
import org.apache.http.nio.protocol.AbstractAsyncResponseConsumer;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.ContentInputBuffer;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.nio.util.SimpleInputBuffer;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Asserts;

public abstract class OTSAsyncResponseConsumer<Res>
extends AbstractAsyncResponseConsumer<Res> {
    protected static final int BUFFER_SIZE = 4096;
    protected volatile HttpResponse httpResponse;
    protected volatile SimpleInputBuffer buf;
    protected ResultParser resultParser;
    protected ExecutionContext context;
    protected OTSTraceLogger traceLogger;
    protected static ResourceManager rm = ResourceManager.getInstance("common");

    public OTSAsyncResponseConsumer(ResultParser resultParser, OTSTraceLogger traceLogger) {
        this.resultParser = resultParser;
        this.traceLogger = traceLogger;
    }

    public void setContext(ExecutionContext context) {
        this.context = context;
    }

    protected void onResponseReceived(HttpResponse response) throws IOException {
        this.httpResponse = response;
    }

    protected abstract Res parseResult() throws Exception;

    protected Res buildResult(HttpContext context) throws Exception {
        if (LogUtil.LOG.isDebugEnabled()) {
            LogUtil.LOG.debug("TraceId:" + this.traceLogger.getTraceId() + "\t" + "ResponseReveived");
        }
        this.traceLogger.addEventTime("ResponseReveived", System.currentTimeMillis());
        Res result = this.parseResult();
        return result;
    }

    protected ResponseContentWithMeta getResponseContentWithMeta() throws Exception {
        ResponseMessage response = new ResponseMessage(this.httpResponse);
        try {
            List<ResponseHandler> responseHandlers = this.context.getResponseHandlers();
            for (ResponseHandler h : responseHandlers) {
                h.handle(response);
            }
            ResponseContentWithMeta responseContent = (ResponseContentWithMeta)this.resultParser.getObject(response);
            this.closeResponseSilently(response);
            return responseContent;
        }
        catch (ResultParseException e) {
            this.closeResponseSilently(response);
            ClientException ex = new ClientException("InvalidResponse", rm.getFormattedString("FailedToParseResponse", new Object[0]), e);
            throw ex;
        }
        catch (Exception ex) {
            this.closeResponseSilently(response);
            throw ex;
        }
    }

    protected void onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
        long len = entity.getContentLength();
        if (len > Integer.MAX_VALUE) {
            throw new ContentTooLongException("Entity content is too long: " + len);
        }
        if (len < 0L) {
            len = 4096L;
        }
        this.buf = new SimpleInputBuffer((int)len, (ByteBufferAllocator)new HeapByteBufferAllocator());
        this.httpResponse.setEntity((HttpEntity)new ContentBufferEntity(entity, (ContentInputBuffer)this.buf));
    }

    protected void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        Asserts.notNull((Object)this.buf, (String)"Content buffer");
        this.buf.consumeContent(decoder);
    }

    protected void releaseResources() {
        this.httpResponse = null;
        this.buf = null;
    }

    private void closeResponseSilently(ResponseMessage response) {
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

