/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.trace;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.internal.OtelEncodingUtils;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.SpanContext;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.SpanId;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.StatusCode;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.TraceFlags;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.TraceId;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.TraceState;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.MessageHookPointStatus;
import java.util.HashSet;
import java.util.Set;

public class TracingUtility {
    private static final String VERSION = "00";
    private static final String VERSION_00 = "00";
    private static final int VERSION_SIZE = 2;
    private static final char TRACE_PARENT_DELIMITER = '-';
    private static final int TRACE_PARENT_DELIMITER_SIZE = 1;
    private static final int TRACE_ID_HEX_SIZE = TraceId.getLength();
    private static final int SPAN_ID_HEX_SIZE = SpanId.getLength();
    private static final int TRACE_OPTION_HEX_SIZE = TraceFlags.getLength();
    private static final int TRACE_ID_OFFSET = 3;
    private static final int SPAN_ID_OFFSET = 3 + TRACE_ID_HEX_SIZE + 1;
    private static final int TRACE_OPTION_OFFSET = SPAN_ID_OFFSET + SPAN_ID_HEX_SIZE + 1;
    private static final int TRACE_PARENT_HEADER_SIZE = TRACE_OPTION_OFFSET + TRACE_OPTION_HEX_SIZE;
    private static final Set<String> VALID_VERSIONS = new HashSet<String>();

    private TracingUtility() {
    }

    public static String injectSpanContextToTraceParent(SpanContext spanContext) {
        if (!spanContext.isValid()) {
            return "";
        }
        char[] chars = new char[TRACE_PARENT_HEADER_SIZE];
        chars[0] = "00".charAt(0);
        chars[1] = "00".charAt(1);
        chars[2] = 45;
        String traceId = spanContext.getTraceId();
        for (int i = 0; i < traceId.length(); ++i) {
            chars[3 + i] = traceId.charAt(i);
        }
        chars[TracingUtility.SPAN_ID_OFFSET - 1] = 45;
        String spanId = spanContext.getSpanId();
        for (int i = 0; i < spanId.length(); ++i) {
            chars[TracingUtility.SPAN_ID_OFFSET + i] = spanId.charAt(i);
        }
        chars[TracingUtility.TRACE_OPTION_OFFSET - 1] = 45;
        String traceFlagsHex = spanContext.getTraceFlags().asHex();
        chars[TracingUtility.TRACE_OPTION_OFFSET] = traceFlagsHex.charAt(0);
        chars[TracingUtility.TRACE_OPTION_OFFSET + 1] = traceFlagsHex.charAt(1);
        return new String(chars, 0, TRACE_PARENT_HEADER_SIZE);
    }

    public static SpanContext extractContextFromTraceParent(String traceParent) {
        boolean isValid;
        if (null == traceParent) {
            return SpanContext.getInvalid();
        }
        boolean bl = isValid = (traceParent.length() == TRACE_PARENT_HEADER_SIZE || traceParent.length() > TRACE_PARENT_HEADER_SIZE && traceParent.charAt(TRACE_PARENT_HEADER_SIZE) == '-') && traceParent.charAt(2) == '-' && traceParent.charAt(SPAN_ID_OFFSET - 1) == '-' && traceParent.charAt(TRACE_OPTION_OFFSET - 1) == '-';
        if (!isValid) {
            return SpanContext.getInvalid();
        }
        String version = traceParent.substring(0, 2);
        if (!VALID_VERSIONS.contains(version)) {
            return SpanContext.getInvalid();
        }
        if (version.equals("00") && traceParent.length() > TRACE_PARENT_HEADER_SIZE) {
            return SpanContext.getInvalid();
        }
        String traceId = traceParent.substring(3, 3 + TraceId.getLength());
        String spanId = traceParent.substring(SPAN_ID_OFFSET, SPAN_ID_OFFSET + SpanId.getLength());
        char firstTraceFlagsChar = traceParent.charAt(TRACE_OPTION_OFFSET);
        char secondTraceFlagsChar = traceParent.charAt(TRACE_OPTION_OFFSET + 1);
        if (!OtelEncodingUtils.isValidBase16Character(firstTraceFlagsChar) || !OtelEncodingUtils.isValidBase16Character(secondTraceFlagsChar)) {
            return SpanContext.getInvalid();
        }
        TraceFlags traceFlags = TraceFlags.fromByte(OtelEncodingUtils.byteFromBase16(firstTraceFlagsChar, secondTraceFlagsChar));
        return SpanContext.createFromRemoteParent(traceId, spanId, traceFlags, TraceState.getDefault());
    }

    public static StatusCode convertToTraceStatus(MessageHookPointStatus status) {
        switch (status) {
            case OK: {
                return StatusCode.OK;
            }
            case ERROR: {
                return StatusCode.ERROR;
            }
        }
        return StatusCode.UNSET;
    }

    static {
        for (int i = 0; i < 255; ++i) {
            String version = Long.toHexString(i);
            if (version.length() < 2) {
                version = '0' + version;
            }
            VALID_VERSIONS.add(version);
        }
    }
}

