/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.remoting;

import com.aliyun.openservices.ons.shaded.com.google.common.util.concurrent.Futures;
import com.aliyun.openservices.ons.shaded.com.google.common.util.concurrent.ListenableFuture;
import com.aliyun.openservices.ons.shaded.com.google.common.util.concurrent.MoreExecutors;
import com.aliyun.openservices.ons.shaded.com.google.gson.Gson;
import com.aliyun.openservices.ons.shaded.com.google.gson.GsonBuilder;
import com.aliyun.openservices.ons.shaded.com.google.gson.annotations.SerializedName;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.exception.ClientException;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.exception.ErrorCode;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.remoting.Credentials;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.remoting.CredentialsProvider;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.utility.HttpTinyClient;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.utility.ThreadFactoryImpl;
import com.aliyun.openservices.ons.shaded.org.slf4j.Logger;
import com.aliyun.openservices.ons.shaded.org.slf4j.LoggerFactory;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class StsCredentialsProvider
implements CredentialsProvider {
    private static final Logger log = LoggerFactory.getLogger(StsCredentialsProvider.class);
    private static final int HTTP_TIMEOUT_MILLIS = 1000;
    private static final String RAM_ROLE_HOST = "100.100.100.200";
    private static final String RAM_ROLE_URL_PREFIX = "/latest/meta-data/Ram/security-credentials/";
    private final HttpTinyClient httpTinyClient;
    private volatile Credentials credentials;
    private final String ramRole;
    private final ExecutorService stsRefresher;

    public StsCredentialsProvider(String ramRole) {
        this(ramRole, HttpTinyClient.getInstance());
    }

    StsCredentialsProvider(String ramRole, HttpTinyClient tinyClient) {
        this.httpTinyClient = tinyClient;
        this.ramRole = ramRole;
        this.credentials = null;
        this.stsRefresher = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryImpl("StsRefresher"));
    }

    @Override
    public Credentials getCredentials() throws ClientException {
        if (null == this.credentials) {
            ListenableFuture<Credentials> future = this.refresh();
            try {
                return (Credentials)future.get();
            }
            catch (Throwable t) {
                throw new ClientException(ErrorCode.STS_TOKEN_GET_FAILURE, t);
            }
        }
        if (this.credentials.expiredSoon()) {
            this.refresh();
        }
        return this.credentials;
    }

    private ListenableFuture<Credentials> refresh() {
        String url = "http://100.100.100.200/latest/meta-data/Ram/security-credentials/" + this.ramRole;
        ListenableFuture<HttpTinyClient.HttpResult> future = this.httpTinyClient.httpGet(url, 1000, this.stsRefresher);
        return Futures.transform(future, httpResult -> {
            try {
                if (httpResult.isOk()) {
                    String content = httpResult.getContent();
                    Gson gson = new GsonBuilder().create();
                    StsCredentials stsCredentials = gson.fromJson(content, StsCredentials.class);
                    String expiration = stsCredentials.getExpiration();
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                    dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    long expiredTimeMillis = dateFormat.parse(expiration).getTime();
                    String code = stsCredentials.getCode();
                    if (StsCredentials.SUCCESS_CODE.equals(code)) {
                        this.credentials = new Credentials(stsCredentials.getAccessKeyId(), stsCredentials.getAccessKeySecret(), stsCredentials.getSecurityToken(), expiredTimeMillis);
                        return this.credentials;
                    }
                    log.error("Failed to fetch sts token, ramRole={}, code={}", (Object)this.ramRole, (Object)code);
                } else {
                    log.error("Failed to fetch sts token, ramRole={}, httpCode={}", (Object)this.ramRole, (Object)httpResult.getCode());
                }
            }
            catch (Throwable t) {
                log.error("Exception raise while refreshing sts token, ramRole={}", (Object)this.ramRole, (Object)t);
                throw new RuntimeException(t);
            }
            throw new RuntimeException("Failed to fetch sts token");
        }, MoreExecutors.directExecutor());
    }

    static class StsCredentials {
        public static String SUCCESS_CODE = "Success";
        @SerializedName(value="AccessKeyId")
        private final String accessKeyId;
        @SerializedName(value="AccessKeySecret")
        private final String accessKeySecret;
        @SerializedName(value="Expiration")
        private final String expiration;
        @SerializedName(value="SecurityToken")
        private final String securityToken;
        @SerializedName(value="LastUpdated")
        private final String lastUpdated;
        @SerializedName(value="Code")
        private final String code;

        public StsCredentials(String accessKeyId, String accessKeySecret, String expiration, String securityToken, String lastUpdated, String code) {
            this.accessKeyId = accessKeyId;
            this.accessKeySecret = accessKeySecret;
            this.expiration = expiration;
            this.securityToken = securityToken;
            this.lastUpdated = lastUpdated;
            this.code = code;
        }

        public String getAccessKeyId() {
            return this.accessKeyId;
        }

        public String getAccessKeySecret() {
            return this.accessKeySecret;
        }

        public String getExpiration() {
            return this.expiration;
        }

        public String getSecurityToken() {
            return this.securityToken;
        }

        public String getLastUpdated() {
            return this.lastUpdated;
        }

        public String getCode() {
            return this.code;
        }
    }
}

