/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.misc;

import com.aliyun.openservices.ons.shaded.commons.lang3.StringUtils;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.exception.ClientException;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.exception.ErrorCode;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.Message;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Validators {
    public static final String TOPIC_REGEX = "^[%|a-zA-Z0-9._-]+$";
    public static final Pattern TOPIC_PATTERN = Pattern.compile("^[%|a-zA-Z0-9._-]+$");
    public static final int TOPIC_MAX_LENGTH = 255;
    public static final String GROUP_REGEX = "^[%|a-zA-Z0-9._-]+$";
    public static final Pattern GROUP_PATTERN = Pattern.compile("^[%|a-zA-Z0-9._-]+$");
    public static final int CONSUMER_GROUP_MAX_LENGTH = 255;
    public static final int MESSAGE_BODY_MAX_SIZE = 0x400000;
    public static final String INSTANCE_REGEX = "MQ_INST_\\w+_\\w+";
    public static final Pattern NAME_SERVER_ENDPOINT_PATTERN = Pattern.compile("^(\\w+://|).*");
    public static final Pattern NAME_SERVER_ENDPOINT_WITH_NAMESPACE_PATTERN = Pattern.compile("^(\\w+://|)MQ_INST_\\w+_\\w+\\..*");

    private Validators() {
    }

    private static boolean regexNotMatched(String origin, Pattern pattern) {
        Matcher matcher = pattern.matcher(origin);
        return !matcher.matches();
    }

    public static void checkTopic(String topic) throws ClientException {
        if (StringUtils.isAnyBlank(topic)) {
            throw new ClientException(ErrorCode.ILLEGAL_FORMAT, "Topic is blank.");
        }
        if (Validators.regexNotMatched(topic, TOPIC_PATTERN)) {
            throw new ClientException(ErrorCode.ILLEGAL_FORMAT, String.format("Topic[%s] is illegal.", topic));
        }
        if (topic.length() > 255) {
            throw new ClientException(ErrorCode.ILLEGAL_FORMAT, "Topic's length exceeds the threshold, masSize=255 bytes");
        }
    }

    public static void checkGroup(String group) throws ClientException {
        if (!StringUtils.isNoneBlank(group)) {
            throw new ClientException(ErrorCode.ILLEGAL_FORMAT, "Group is blank.");
        }
        if (Validators.regexNotMatched(group, GROUP_PATTERN)) {
            throw new ClientException(ErrorCode.ILLEGAL_FORMAT, String.format("Group[%s] is illegal.", group));
        }
        if (group.length() > 255) {
            throw new ClientException(ErrorCode.ILLEGAL_FORMAT, "Group length exceeds the threshold, maxSize255 bytes");
        }
    }

    public static void checkMessage(Message message) throws ClientException {
        if (null == message) {
            throw new ClientException(ErrorCode.ILLEGAL_FORMAT, "Message is null.");
        }
        Validators.checkTopic(message.getTopic());
        byte[] body = message.getBody();
        if (null == body) {
            throw new ClientException(ErrorCode.ILLEGAL_FORMAT, "Message body is null.");
        }
        if (0 >= body.length) {
            throw new ClientException(ErrorCode.ILLEGAL_FORMAT, "Message body's length is zero.");
        }
        if (body.length > 0x400000) {
            throw new ClientException(ErrorCode.ILLEGAL_FORMAT, "Message body's length exceeds the threshold, maxSize=4194304 bytes.");
        }
    }

    public static void checkNamesrvAddr(String namesrvAddr) throws ClientException {
        if (!StringUtils.isNoneBlank(namesrvAddr)) {
            throw new ClientException(ErrorCode.ILLEGAL_FORMAT, "Name server address is blank.");
        }
        if (!NAME_SERVER_ENDPOINT_PATTERN.matcher(namesrvAddr).matches() && !NAME_SERVER_ENDPOINT_WITH_NAMESPACE_PATTERN.matcher(namesrvAddr).matches()) {
            throw new ClientException(ErrorCode.ILLEGAL_FORMAT, "Name server address is illegal.");
        }
    }
}

