/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.consumer.filter;

import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.consumer.filter.ExpressionType;
import com.aliyun.openservices.ons.shaded.org.apache.rocketmq.client.message.MessageExt;

public class FilterExpression {
    public static final String TAG_EXPRESSION_SUB_ALL = "*";
    private static final String TAG_EXPRESSION_SPLIT_PATTERN = "\\|\\|";
    private final String expression;
    private final ExpressionType expressionType;
    private final long version;

    public FilterExpression() {
        this(TAG_EXPRESSION_SUB_ALL);
    }

    public FilterExpression(String expression) {
        this(expression, ExpressionType.TAG);
    }

    public FilterExpression(String expression, ExpressionType expressionType) {
        this.expression = ExpressionType.TAG == expressionType ? (null == expression || expression.isEmpty() ? TAG_EXPRESSION_SUB_ALL : expression.trim()) : expression;
        this.expressionType = expressionType;
        this.version = System.currentTimeMillis();
    }

    public boolean accept(MessageExt messageExt) {
        if (TAG_EXPRESSION_SUB_ALL.equals(this.expression)) {
            return true;
        }
        String[] split = this.expression.split(TAG_EXPRESSION_SPLIT_PATTERN);
        String messageTag = messageExt.getTag();
        for (String tag : split) {
            if (!tag.equals(messageTag)) continue;
            return true;
        }
        return false;
    }

    public String getExpression() {
        return this.expression;
    }

    public ExpressionType getExpressionType() {
        return this.expressionType;
    }

    public long getVersion() {
        return this.version;
    }
}

