/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.export;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.context.Context;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.common.CompletableResultCode;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.ReadWriteSpan;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.ReadableSpan;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.SpanProcessor;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.data.SpanData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SimpleSpanProcessor
extends SpanProcessor {
    private static final Logger logger = Logger.getLogger(SimpleSpanProcessor.class.getName());
    private final SpanExporter spanExporter;
    private final boolean sampled;
    private final Set<CompletableResultCode> pendingExports = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);

    public static SpanProcessor create(SpanExporter exporter) {
        if (exporter == null) {
            throw new NullPointerException("exporter");
        }
        return new SimpleSpanProcessor(exporter, true);
    }

    SimpleSpanProcessor(SpanExporter spanExporter, boolean sampled) {
        if (spanExporter == null) {
            throw new NullPointerException("spanExporter");
        }
        this.spanExporter = spanExporter;
        this.sampled = sampled;
    }

    @Override
    public void onStart(Context parentContext, ReadWriteSpan span) {
    }

    @Override
    public boolean isStartRequired() {
        return false;
    }

    @Override
    public void onEnd(ReadableSpan span) {
        if (this.sampled && !span.getSpanContext().isSampled()) {
            return;
        }
        try {
            List<SpanData> spans = Collections.singletonList(span.toSpanData());
            final CompletableResultCode result = this.spanExporter.export(spans);
            this.pendingExports.add(result);
            result.whenComplete(new Runnable(){

                @Override
                public void run() {
                    SimpleSpanProcessor.this.pendingExports.remove(result);
                    if (!result.isSuccess()) {
                        logger.log(Level.FINE, "Exporter failed");
                    }
                }
            });
        }
        catch (RuntimeException e) {
            logger.log(Level.WARNING, "Exporter threw an Exception", e);
        }
    }

    @Override
    public boolean isEndRequired() {
        return true;
    }

    @Override
    public CompletableResultCode shutdown() {
        if (this.isShutdown.getAndSet(true)) {
            return CompletableResultCode.ofSuccess();
        }
        final CompletableResultCode result = new CompletableResultCode();
        final CompletableResultCode flushResult = this.forceFlush();
        flushResult.whenComplete(new Runnable(){

            @Override
            public void run() {
                final CompletableResultCode shutdownResult = SimpleSpanProcessor.this.spanExporter.shutdown();
                shutdownResult.whenComplete(new Runnable(){

                    @Override
                    public void run() {
                        if (!flushResult.isSuccess() || !shutdownResult.isSuccess()) {
                            result.fail();
                        } else {
                            result.succeed();
                        }
                    }
                });
            }
        });
        return result;
    }

    @Override
    public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofAll(this.pendingExports);
    }
}

