/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace;

import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.SpanId;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.trace.TraceId;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.trace.IdGenerator;
import java.util.Random;

class RandomIdGenerator
extends IdGenerator {
    public static final RandomIdGenerator INSTANCE = new RandomIdGenerator();
    private static final ThreadLocal<Random> threadLocalRandom = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random();
        }
    };
    private static final long INVALID_ID = 0L;

    RandomIdGenerator() {
    }

    @Override
    public String generateSpanId() {
        long id;
        while ((id = threadLocalRandom.get().nextLong()) == 0L) {
        }
        return SpanId.fromLong(id);
    }

    @Override
    public String generateTraceId() {
        long idLo;
        long idHi;
        do {
            Random random = threadLocalRandom.get();
            idHi = random.nextLong();
            idLo = random.nextLong();
        } while (idHi == 0L && idLo == 0L);
        return TraceId.fromLongs(idHi, idLo);
    }
}

