/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data;

import com.aliyun.openservices.ons.shaded.com.google.auto.value.AutoValue;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.api.metrics.common.Labels;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.AutoValue_DoubleHistogramPointData;
import com.aliyun.openservices.ons.shaded.io.opentelemetry.sdk.metrics.data.PointData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class DoubleHistogramPointData
implements PointData {
    public static DoubleHistogramPointData create(long startEpochNanos, long epochNanos, Labels labels, double sum, List<Double> boundaries, List<Long> counts) {
        if (counts.size() != boundaries.size() + 1) {
            throw new IllegalArgumentException("invalid counts: size should be " + (boundaries.size() + 1) + " instead of " + counts.size());
        }
        if (!DoubleHistogramPointData.isStrictlyIncreasing(boundaries)) {
            throw new IllegalArgumentException("invalid boundaries: " + boundaries);
        }
        if (!boundaries.isEmpty() && (boundaries.get(0).isInfinite() || boundaries.get(boundaries.size() - 1).isInfinite())) {
            throw new IllegalArgumentException("invalid boundaries: contains explicit +/-Inf");
        }
        long totalCount = 0L;
        for (long c : counts) {
            totalCount += c;
        }
        return new AutoValue_DoubleHistogramPointData(startEpochNanos, epochNanos, labels, sum, totalCount, Collections.unmodifiableList(new ArrayList<Double>(boundaries)), Collections.unmodifiableList(new ArrayList<Long>(counts)));
    }

    DoubleHistogramPointData() {
    }

    public abstract double getSum();

    public abstract long getCount();

    public abstract List<Double> getBoundaries();

    public abstract List<Long> getCounts();

    private static boolean isStrictlyIncreasing(List<Double> xs) {
        for (int i = 0; i < xs.size() - 1; ++i) {
            if (xs.get(i).compareTo(xs.get(i + 1)) < 0) continue;
            return false;
        }
        return true;
    }
}

