/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api;

import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.ONSFactoryAPI;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.PullConsumer;
import com.aliyun.openservices.ons.api.batch.BatchConsumer;
import com.aliyun.openservices.ons.api.order.OrderConsumer;
import com.aliyun.openservices.ons.api.order.OrderProducer;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionChecker;
import com.aliyun.openservices.ons.api.transaction.TransactionProducer;
import java.util.Properties;

public class ONSFactory {
    private static ONSFactoryAPI onsFactory = null;

    private ONSFactory() {
    }

    public static Producer createProducer(Properties properties) {
        return onsFactory.createProducer(properties);
    }

    public static OrderProducer createOrderProducer(Properties properties) {
        return onsFactory.createOrderProducer(properties);
    }

    public static TransactionProducer createTransactionProducer(Properties properties, LocalTransactionChecker checker) {
        return onsFactory.createTransactionProducer(properties, checker);
    }

    public static Consumer createConsumer(Properties properties) {
        return onsFactory.createConsumer(properties);
    }

    public static BatchConsumer createBatchConsumer(Properties properties) {
        return onsFactory.createBatchConsumer(properties);
    }

    public static OrderConsumer createOrderedConsumer(Properties properties) {
        return onsFactory.createOrderedConsumer(properties);
    }

    public static PullConsumer createPullConsumer(Properties properties) {
        return onsFactory.createPullConsumer(properties);
    }

    static {
        try {
            Class<?> factoryClass = ONSFactory.class.getClassLoader().loadClass("com.aliyun.openservices.ons.api.impl.ONSFactoryNotifyAndMetaQImpl");
            onsFactory = (ONSFactoryAPI)factoryClass.newInstance();
        }
        catch (Throwable e) {
            try {
                Class<?> factoryClass = ONSFactory.class.getClassLoader().loadClass("com.aliyun.openservices.ons.client.ONSFactoryImpl");
                onsFactory = (ONSFactoryAPI)factoryClass.newInstance();
            }
            catch (Throwable e1) {
                e.printStackTrace();
                e1.printStackTrace();
            }
        }
    }
}

