/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.helper;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.factory.MQClientInstance;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.MixAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageConst;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageExt;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.route.QueueData;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.route.TopicRouteData;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;

/**
 * inner class
 */
public class TopicSysFlagSetInnerHelper {

    private static final InternalLogger log = ClientLogger.getLog();

    /**
     * set topicSysFlag
     * 
     * @param messageExt
     * @param mQClientFactory
     */
    public static void setTopicSysFlag(MessageExt messageExt, Integer topicSysFlagFromHeader, MQClientInstance mQClientFactory) {
        if (!messageExt.getTopic().startsWith(MixAll.RETRY_GROUP_TOPIC_PREFIX)
            && topicSysFlagFromHeader != null) {
            // set topicSysFlag by responseHeader from broker
            messageExt.setTopicSysFlag(topicSysFlagFromHeader);
        } else {
            // set topicSysFlag by topicRouterData from client cache for retry message or null from header
            String originTopic;
            if (!messageExt.getTopic().startsWith(MixAll.RETRY_GROUP_TOPIC_PREFIX)) {
                originTopic = messageExt.getTopic();
            } else {
                originTopic = messageExt.getProperty(MessageConst.PROPERTY_RETRY_TOPIC);
            }
            // set topicSysFlag by topicRouterData from client cache
            if (originTopic == null) {
                log.warn("[SetTopicSysFlag] NOT FOUND PROPERTY_RETRY_TOPIC for " + messageExt.getTopic() + " "
                         + messageExt.getMsgId());
            } else {
                TopicRouteData topicRouteData = mQClientFactory.getTopicRouteTable().get(originTopic);
                if (topicRouteData == null) {
                    log.warn(
                        "[SetTopicSysFlag]NOT FOUND topicRouteData for " + originTopic + " " + messageExt.getMsgId());
                } else if (topicRouteData.getQueueDatas().size() == 0) {
                    log.warn(
                        "[SetTopicSysFlag]NOT FOUND getQueueDatas for " + originTopic + " " + messageExt.getMsgId());
                } else {
                    QueueData queueData = topicRouteData.getQueueDatas().get(0);
                    if (queueData == null) {
                        log.warn("[SetTopicSysFlag] NULL QueueData for " + originTopic + " " + messageExt.getMsgId());
                    } else {
                        messageExt.setTopicSysFlag(queueData.getTopicSynFlag());
                    }
                }
            }
        }
    }
}
