/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageAccessor;
import com.aliyun.openservices.ons.api.spi.InvocationContext;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.util.List;

public class ONSUnitUtils {
    private static final int FLAG_UNIT = 1;
    private static final String MSG_PROP_UNIT_ORIUNIT = "MSHA.UNIT.ORIUNIT";
    private static final String MSG_PROP_UNIT_TYPE = "MSHA.UNIT.TYPE";
    private static final String MSG_PROP_UNIT_KEY = "MSHA.UNIT.KEY";
    private static final String PROPERTY_TRANSIENT_TOPIC_CONFIG = "__RMQ.TRANSIENT.TOPIC_SYS_FLAG";
    private static final String PROPERTY_TRANSIENT_GROUP_CONFIG = "__RMQ.TRANSIENT.GROUP_SYS_FLAG";
    private static final String PROPERTY_TRANSIENT_MSHA_RETRY = "__RMQ.TRANSIENT.MSHA_RETRY";
    private static final String PROPERTY_RETRY_TOPIC = "RETRY_TOPIC";
    public static final String CONTEXT_ATTR_TOPIC_UNIT_FLAG = "CONTEXT.TOPIC_UNIT_FLAG";

    public static String getUnitOriUnit(Message msg) {
        return msg.getUserProperties(MSG_PROP_UNIT_ORIUNIT);
    }

    public static String getUnitType(Message msg) {
        return msg.getUserProperties(MSG_PROP_UNIT_TYPE);
    }

    public static String getUnitKey(Message msg) {
        return msg.getUserProperties(MSG_PROP_UNIT_KEY);
    }

    public static void setUnitProperties(Message msg, String oriUnitId, String unitType, String unitKey) {
        msg.putUserProperties(MSG_PROP_UNIT_ORIUNIT, oriUnitId);
        msg.putUserProperties(MSG_PROP_UNIT_TYPE, unitType);
        msg.putUserProperties(MSG_PROP_UNIT_KEY, unitKey);
    }

    public static boolean isUnitTopic(InvocationContext context) {
        Boolean contextTopicFlag = (Boolean)context.getAttributes().get(CONTEXT_ATTR_TOPIC_UNIT_FLAG);
        Optional<List<Message>> messages = context.getMessages();
        if (!messages.isPresent() || ((List)messages.get()).size() == 0) {
            return contextTopicFlag == null ? false : contextTopicFlag;
        }
        String msgTopicFlag = MessageAccessor.getSystemProperties((Message)((List)messages.get()).get(0), PROPERTY_TRANSIENT_TOPIC_CONFIG);
        if (msgTopicFlag != null && msgTopicFlag.length() > 0) {
            return ONSUnitUtils.hasUnitFlag(Integer.parseInt(msgTopicFlag));
        }
        return contextTopicFlag == null ? false : contextTopicFlag;
    }

    public static boolean isUnitGroup(InvocationContext context) {
        Optional<List<Message>> messages = context.getMessages();
        if (!messages.isPresent() || ((List)messages.get()).size() == 0) {
            return false;
        }
        String msgGroupFlag = MessageAccessor.getSystemProperties((Message)((List)messages.get()).get(0), PROPERTY_TRANSIENT_GROUP_CONFIG);
        if (Strings.isNullOrEmpty((String)msgGroupFlag)) {
            return false;
        }
        return ONSUnitUtils.hasUnitFlag(Integer.parseInt(msgGroupFlag));
    }

    public static void setUnitTopic(InvocationContext context, boolean isUnitTopic) {
        context.getAttributes().put(CONTEXT_ATTR_TOPIC_UNIT_FLAG, isUnitTopic);
    }

    public static boolean isRetryMsg(Message message) {
        return !Strings.isNullOrEmpty((String)message.getSystemProperties(PROPERTY_RETRY_TOPIC));
    }

    public static void setMSHAUnitRetry(Message message) {
        message.putSystemProperties(PROPERTY_TRANSIENT_MSHA_RETRY, String.valueOf(Boolean.TRUE));
    }

    public static String getMSHAUnitRetry(Message message) {
        return message.getSystemProperties(PROPERTY_TRANSIENT_MSHA_RETRY);
    }

    private static boolean hasUnitFlag(int sysFlag) {
        return (sysFlag & 1) == 1;
    }
}

