/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.loghub.client.metrics;

import com.aliyun.openservices.log.Client;
import com.aliyun.openservices.log.common.LogItem;
import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.log.request.PutLogsRequest;
import com.aliyun.openservices.loghub.client.metrics.LogDimension;
import com.aliyun.openservices.loghub.client.metrics.LogMetricConfig;
import com.aliyun.openservices.loghub.client.metrics.MetricDimension;
import com.aliyun.openservices.loghub.client.metrics.MetricReadRecord;
import com.aliyun.openservices.loghub.client.metrics.MetricWriteRecord;
import com.aliyun.openservices.loghub.client.metrics.kv.LogKey;
import com.aliyun.openservices.loghub.client.metrics.kv.LogValue;
import com.aliyun.openservices.loghub.client.metrics.kv.MetricKey;
import com.aliyun.openservices.loghub.client.metrics.kv.MetricType;
import com.aliyun.openservices.loghub.client.metrics.kv.MetricValue;
import com.aliyun.openservices.loghub.client.metrics.kv.Window;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogMetricPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(LogMetricPublisher.class);
    private static final int DEFAULT_MINUTE_PERIOD = 1;
    private static final int PRESET_AMOUNT = 3;
    private static final int RETRY_COUNT = 5;
    private static final int MAX_GROUP_SIZE = 4000;
    private static final int CLEAR_PERIOD = 259200;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    private final ExecutorService executorService = Executors.newFixedThreadPool(1);
    private Map<LogKey, LogValue> slsLog = new ConcurrentHashMap<LogKey, LogValue>();
    private Map<MetricKey, MetricValue> slsMetric = new ConcurrentHashMap<MetricKey, MetricValue>();
    private Set<LogDimension> logDimensions = new HashSet<LogDimension>();
    private Set<MetricDimension> metricDimensions = new HashSet<MetricDimension>();
    private Map<MetricDimension, AtomicLong> metricDimsStat = new ConcurrentHashMap<MetricDimension, AtomicLong>();
    private Client client;
    private LogMetricConfig config;
    private long lastClearTime = 0L;
    private long startTime = 0L;
    private int minutePeriod = 1;
    private int delaySeconds = 5;
    private AtomicBoolean isShutDown = new AtomicBoolean(false);

    public LogMetricPublisher(LogMetricConfig config, Set<LogDimension> logDimensions, Set<MetricDimension> metricDimensions) {
        this(config, 1, logDimensions, metricDimensions);
    }

    public LogMetricPublisher(LogMetricConfig config, int minutePeriod, Set<LogDimension> logDimensions, Set<MetricDimension> metricDimensions) {
        if (config == null) {
            throw new NullPointerException("LogMetric Config Can't Be Null");
        }
        if (minutePeriod < 1) {
            throw new IllegalArgumentException("LogMetric minPeriod Must Be Greater or Equal than 1");
        }
        SimpleDateFormat dataFormat = new SimpleDateFormat("yyyyMMddHHmm");
        try {
            this.startTime = dataFormat.parse(dataFormat.format(new Date())).getTime() / 1000L;
            this.delaySeconds = System.currentTimeMillis() / 1000L - this.startTime > (long)this.delaySeconds ? 0 : this.delaySeconds;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.config = config;
        this.minutePeriod = minutePeriod;
        this.lastClearTime = this.startTime;
        long timeIndex = this.getCurrTimeIndex();
        if (logDimensions != null && !logDimensions.isEmpty()) {
            this.addLogDimensions(timeIndex, logDimensions);
        }
        if (metricDimensions != null && !metricDimensions.isEmpty()) {
            this.addMetricDimensions(timeIndex, metricDimensions);
        }
        this.client = new Client(config.getEndpoint(), config.getAccessKeyId(), config.getAccessKeySecret());
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                long timeIndex = LogMetricPublisher.this.getCurrTimeIndex();
                LogMetricPublisher.this.clearExpireDimensions();
                LogMetricPublisher.this.publishLogMetric(timeIndex, true, true);
                LogMetricPublisher.this.presetLogBuckets(timeIndex, 3);
                LogMetricPublisher.this.presetMetricBuckets(timeIndex, 3);
            }
        }, minutePeriod * 60 + this.delaySeconds, minutePeriod * 60, TimeUnit.SECONDS);
    }

    public void addLog(String level, String code, String message) {
        long[] wTimes;
        long timeIndex = this.getCurrTimeIndex();
        LogKey logKey = new LogKey(timeIndex, (wTimes = this.getSpanOfTimeIndex(timeIndex))[0], wTimes[1], level, code);
        LogValue logValue = this.slsLog.get(logKey);
        if (logValue == null) {
            LOG.info("LogMetric LogValue Is Null,LogKey Is:{}", (Object)logKey.toString());
            this.addLogDimension(timeIndex, new LogDimension(level, code));
            logValue = this.slsLog.get(logKey);
        }
        if (logValue != null) {
            logValue.incrementCount();
            logValue.setMessage(message);
        }
    }

    public void addReadMetric(String project, String logstore, String consumerGroup, String consumer, String shard, MetricReadRecord metricReadRecord) {
        long[] wTimes;
        long timeIndex = this.getCurrTimeIndex();
        MetricKey metricKey = new MetricKey(timeIndex, (wTimes = this.getSpanOfTimeIndex(timeIndex))[0], wTimes[1], project, logstore, consumerGroup, consumer, shard, MetricType.SOURCE_METRIC);
        MetricValue metricValue = this.slsMetric.get(metricKey);
        if (metricValue == null) {
            LOG.info("LogMetric MetricValue Is Null,MetricKey Is:{}", (Object)metricKey.toString());
            this.addMetricDimension(timeIndex, new MetricDimension(project, logstore, consumerGroup, consumer, shard, MetricType.SOURCE_METRIC));
            metricValue = this.slsMetric.get(metricKey);
        }
        if (metricValue != null) {
            metricValue.setFetchedDelay(metricReadRecord.getFetchedDelay());
            metricValue.addFetchedBytes(metricReadRecord.getFetchedBytes());
            metricValue.addFetchedCount(metricReadRecord.getFetchedCount());
            metricValue.addFetchedMillis(metricReadRecord.getFetchedMillis());
        }
        this.metricDimsStat(project, logstore, consumerGroup, consumer, shard, MetricType.SOURCE_METRIC);
    }

    public void addWriteMetric(String project, String logstore, String consumerGroup, String consumer, String shard, MetricWriteRecord metricWriteRecord) {
        long[] wTimes;
        long timeIndex = this.getCurrTimeIndex();
        MetricKey metricKey = new MetricKey(timeIndex, (wTimes = this.getSpanOfTimeIndex(timeIndex))[0], wTimes[1], project, logstore, consumerGroup, consumer, shard, MetricType.SINK_METRIC);
        MetricValue metricValue = this.slsMetric.get(metricKey);
        if (metricValue == null) {
            LOG.info("LogMetric MetricValue Is Null,MetricKey Is:{}", (Object)metricKey.toString());
            this.addMetricDimension(timeIndex, new MetricDimension(project, logstore, consumerGroup, consumer, shard, MetricType.SINK_METRIC));
            metricValue = this.slsMetric.get(metricKey);
        }
        if (metricValue != null) {
            metricValue.addDelivered(metricWriteRecord.getDelivered());
            metricValue.addFailed(metricWriteRecord.getFailed());
            metricValue.addDropped(metricWriteRecord.getDropped());
            metricValue.setProcessedDelay(metricWriteRecord.getProcessedDelay());
            metricValue.addWriteCount(metricWriteRecord.getWriteCount());
            metricValue.addWriteBytes(metricWriteRecord.getWriteBytes());
            metricValue.addWriteMillis(metricWriteRecord.getWriteMillis());
        }
        this.metricDimsStat(project, logstore, consumerGroup, consumer, shard, MetricType.SINK_METRIC);
    }

    public void addLogDimension(LogDimension logDimension) {
        this.addLogDimension(this.getCurrTimeIndex(), logDimension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogDimension(long timeIndex, LogDimension logDimension) {
        Set<LogDimension> set = this.logDimensions;
        synchronized (set) {
            this.logDimensions.add(logDimension);
            this.presetLogBuckets(timeIndex, 3);
        }
    }

    public void addLogDimensions(Set<LogDimension> logDimensions) {
        this.addLogDimensions(this.getCurrTimeIndex(), logDimensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogDimensions(long timeIndex, Set<LogDimension> logDimensions) {
        Set<LogDimension> set = this.logDimensions;
        synchronized (set) {
            this.logDimensions.addAll(logDimensions);
            this.presetLogBuckets(timeIndex, 3);
        }
    }

    public void addMetricDimension(MetricDimension metricDimension) {
        this.addMetricDimension(this.getCurrTimeIndex(), metricDimension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMetricDimension(long timeIndex, MetricDimension metricDimension) {
        Set<MetricDimension> set = this.metricDimensions;
        synchronized (set) {
            this.metricDimensions.add(metricDimension);
            this.metricDimsStat.putIfAbsent(metricDimension, new AtomicLong(0L));
            this.presetMetricBuckets(timeIndex, 3);
        }
    }

    public void addMetricDimensions(Set<MetricDimension> metricDimensions) {
        this.addMetricDimensions(this.getCurrTimeIndex(), metricDimensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMetricDimensions(long timeIndex, Set<MetricDimension> metricDimensions) {
        Set<MetricDimension> set = this.metricDimensions;
        synchronized (set) {
            this.metricDimensions.addAll(metricDimensions);
            for (MetricDimension metricDimension : metricDimensions) {
                this.metricDimsStat.putIfAbsent(metricDimension, new AtomicLong(0L));
            }
            this.presetMetricBuckets(timeIndex, 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMetricDimension(MetricDimension metricDimension) {
        Set<MetricDimension> set = this.metricDimensions;
        synchronized (set) {
            this.metricDimensions.remove(metricDimension);
            this.presetMetricBuckets(this.getCurrTimeIndex(), 3);
        }
    }

    public void shutdown() {
        if (this.isShutDown.compareAndSet(false, true)) {
            this.scheduledExecutorService.shutdown();
            try {
                this.scheduledExecutorService.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
            this.publishLogMetric(false, false);
        }
    }

    private void publishLogMetric(boolean delay, boolean async) {
        this.publishLogMetric(this.getCurrTimeIndex(), delay, async);
    }

    private void publishLogMetric(long timeIndex, boolean delay, boolean async) {
        LOG.debug("LogMetric Current TimeIndex Is:{},Delay:{}", (Object)timeIndex, (Object)delay);
        ArrayList<LogItem> logGroup = new ArrayList<LogItem>();
        Iterator<Map.Entry<LogKey, LogValue>> logEntries = this.slsLog.entrySet().iterator();
        while (logEntries.hasNext()) {
            Map.Entry<LogKey, LogValue> logEntry = logEntries.next();
            if (logEntry.getKey().getTimeIndex() > timeIndex - (long)(delay ? 1 : 0)) continue;
            if (logEntry.getValue().getCount() > 0) {
                logGroup.add(this.createLogItem(logEntry.getKey(), logEntry.getValue()));
            }
            logEntries.remove();
            LOG.debug("LogMetric SlsLog Remove:{}", (Object)logEntry.getKey().toString());
        }
        Iterator<Map.Entry<MetricKey, MetricValue>> metricEntries = this.slsMetric.entrySet().iterator();
        while (metricEntries.hasNext()) {
            Map.Entry<MetricKey, MetricValue> metricEntry = metricEntries.next();
            if (metricEntry.getKey().getTimeIndex() > timeIndex - (long)(delay ? 1 : 0)) continue;
            MetricType metricType = metricEntry.getKey().getMetricType();
            if (metricType == MetricType.SOURCE_METRIC) {
                logGroup.add(this.createMetricItem(MetricType.SOURCE_METRIC, metricEntry.getKey(), metricEntry.getValue()));
            } else if (metricType == MetricType.SINK_METRIC) {
                logGroup.add(this.createMetricItem(MetricType.SINK_METRIC, metricEntry.getKey(), metricEntry.getValue()));
            }
            metricEntries.remove();
            LOG.debug("LogMetric SlsMetric Remove:{}", (Object)metricEntry.getKey().toString());
        }
        if (!logGroup.isEmpty()) {
            List splits = LogMetricPublisher.split(logGroup);
            for (List split : splits) {
                final PutLogsRequest putReq = new PutLogsRequest(this.config.getProject(), this.config.getLogstore(), this.config.getTopic(), this.config.getSource(), split);
                putReq.SetTags(this.config.getTags());
                if (async) {
                    this.executorService.execute(new Runnable(){

                        @Override
                        public void run() {
                            LogMetricPublisher.this.retryPutLogs(LogMetricPublisher.this.client, putReq);
                        }
                    });
                    continue;
                }
                this.retryPutLogs(this.client, putReq);
            }
        }
    }

    private long[] getSpanOfTimeIndex(long timeIndex) {
        long windowStartTime = timeIndex * (long)(60 * this.minutePeriod) + this.startTime;
        long windowEndTime = windowStartTime + (long)(60 * this.minutePeriod) - 1L;
        return new long[]{windowStartTime, windowEndTime};
    }

    private long getCurrTimeIndex() {
        return (System.currentTimeMillis() / 1000L - this.startTime) / (long)(60 * this.minutePeriod);
    }

    private void presetLogBuckets(int amount) {
        long currTimeIndex = this.getCurrTimeIndex();
        this.presetLogBuckets(currTimeIndex, amount);
    }

    private void presetLogBuckets(long currTimeIndex, int amount) {
        for (int i = 0; i < amount; ++i) {
            long timeIndex = currTimeIndex + (long)i;
            long[] windowTimes = this.getSpanOfTimeIndex(timeIndex);
            Window window = new Window(timeIndex, windowTimes[0], windowTimes[1]);
            this.presetLogBucket(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void presetLogBucket(Window window) {
        Set<LogDimension> set = this.logDimensions;
        synchronized (set) {
            if (this.logDimensions != null && !this.logDimensions.isEmpty()) {
                for (LogDimension dimension : this.logDimensions) {
                    LogKey logKey = new LogKey();
                    logKey.mixWindow(window);
                    logKey.mixDimension(dimension);
                    if (this.slsLog.putIfAbsent(logKey, new LogValue()) != null) continue;
                    LOG.debug("LogMetric Preset LogKey:{}", (Object)logKey.toString());
                }
            }
        }
    }

    private void presetMetricBuckets(int amount) {
        long currTimeIndex = this.getCurrTimeIndex();
        this.presetMetricBuckets(currTimeIndex, amount);
    }

    private void presetMetricBuckets(long currTimeIndex, int amount) {
        for (int i = 0; i < amount; ++i) {
            long timeIndex = currTimeIndex + (long)i;
            long[] windowTimes = this.getSpanOfTimeIndex(timeIndex);
            Window window = new Window(timeIndex, windowTimes[0], windowTimes[1]);
            this.presetMetricBucket(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void presetMetricBucket(Window window) {
        Set<MetricDimension> set = this.metricDimensions;
        synchronized (set) {
            if (this.metricDimensions != null && !this.metricDimensions.isEmpty()) {
                for (MetricDimension dimension : this.metricDimensions) {
                    MetricKey metricKey = new MetricKey();
                    metricKey.mixWindow(window);
                    metricKey.mixDimension(dimension);
                    if (this.slsMetric.putIfAbsent(metricKey, new MetricValue()) != null) continue;
                    LOG.debug("LogMetric Preset MetricKey:{}", (Object)metricKey.toString());
                }
            }
        }
    }

    private void metricDimsStat(String project, String logstore, String consumerGroup, String consumer, String shard, MetricType metricType) {
        MetricDimension metricDimension = new MetricDimension(project, logstore, consumerGroup, consumer, shard, metricType);
        AtomicLong amount = this.metricDimsStat.get(metricDimension);
        if (amount != null) {
            amount.incrementAndGet();
        }
    }

    private void clearExpireDimensions() {
        long now = System.currentTimeMillis() / 1000L;
        if (now - this.lastClearTime > 259200L) {
            Iterator<Map.Entry<MetricDimension, AtomicLong>> metricDimsStatEntries = this.metricDimsStat.entrySet().iterator();
            while (metricDimsStatEntries.hasNext()) {
                Map.Entry<MetricDimension, AtomicLong> metricDimsStatEntry = metricDimsStatEntries.next();
                if (metricDimsStatEntry.getValue().get() <= 0L) {
                    this.removeMetricDimension(metricDimsStatEntry.getKey());
                    metricDimsStatEntries.remove();
                    LOG.info("LogMetric Clear Dimension:{}", (Object)metricDimsStatEntry.getKey().toString());
                    continue;
                }
                metricDimsStatEntry.getValue().getAndSet(0L);
            }
            this.lastClearTime = now;
        }
    }

    private LogItem createLogItem(LogKey logKey, LogValue logValue) {
        LogItem logItem = new LogItem((int)logKey.getStartTime());
        logItem.PushBack("type", "log");
        logItem.PushBack("start", String.valueOf(logKey.getStartTime()));
        logItem.PushBack("end", String.valueOf(logKey.getEndTime()));
        logItem.PushBack("level", logKey.getLevel());
        logItem.PushBack("code", logKey.getCode());
        logItem.PushBack("count", String.valueOf(logValue.getCount()));
        logItem.PushBack("message", logValue.getMessage());
        return logItem;
    }

    private LogItem createMetricItem(MetricType metricType, MetricKey metricKey, MetricValue metricValue) {
        LogItem logItem = new LogItem((int)metricKey.getStartTime());
        logItem.PushBack("type", metricType.name().toLowerCase());
        logItem.PushBack("start", String.valueOf(metricKey.getStartTime()));
        logItem.PushBack("end", String.valueOf(metricKey.getEndTime()));
        logItem.PushBack("project", metricKey.getProject());
        logItem.PushBack("logstore", metricKey.getLogstore());
        logItem.PushBack("consumerGroup", metricKey.getConsumerGroup());
        logItem.PushBack("consumer", metricKey.getConsumer());
        if (metricType == MetricType.SOURCE_METRIC) {
            logItem.PushBack("shard", metricKey.getShard());
            logItem.PushBack("fetchedDelay", String.valueOf(metricValue.getFetchedDelay()));
            logItem.PushBack("fetchedBytes", String.valueOf(metricValue.getFetchedBytes()));
            logItem.PushBack("fetchedCount", String.valueOf(metricValue.getFetchedCount()));
            logItem.PushBack("fetchedMillis", String.valueOf(metricValue.getFetchedMillis()));
        } else if (metricType == MetricType.SINK_METRIC) {
            logItem.PushBack("delivered", String.valueOf(metricValue.getDelivered()));
            logItem.PushBack("dropped", String.valueOf(metricValue.getDropped()));
            logItem.PushBack("failed", String.valueOf(metricValue.getFailed()));
            logItem.PushBack("writeCount", String.valueOf(metricValue.getWriteCount()));
            logItem.PushBack("writeBytes", String.valueOf(metricValue.getWriteBytes()));
            logItem.PushBack("writeMillis", String.valueOf(metricValue.getWriteMillis()));
        }
        return logItem;
    }

    private void retryPutLogs(Client client, PutLogsRequest putReq) {
        int retryNum = 0;
        while (retryNum < 5) {
            try {
                client.PutLogs(putReq);
                return;
            }
            catch (LogException e) {
                if (!"LogStoreNotExist".equals(e.GetErrorCode()) && !"ProjectNotExist".equals(e.GetErrorCode())) {
                    LOG.error("LogMetric PutLogs Exception", (Throwable)e);
                }
                if (("RequestError".equals(e.GetErrorCode()) || "InternalServerError".equals(e.GetErrorCode())) && ++retryNum < 5) {
                    try {
                        Thread.sleep(200L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        LOG.error("LogMetric PutLogs InterruptedException", (Throwable)ex);
                    }
                }
                return;
            }
        }
    }

    private static <T> List<List<T>> split(List<T> logGroup) {
        ArrayList<List<T>> splits = new ArrayList<List<T>>();
        if (logGroup.size() > 4000) {
            for (int i = 0; i < logGroup.size(); i += 4000) {
                int end = i + 4000 < logGroup.size() ? i + 4000 : logGroup.size();
                splits.add(logGroup.subList(i, end));
            }
        } else {
            splits.add(logGroup);
        }
        return splits;
    }
}

