/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.loghub.client;

import com.aliyun.openservices.loghub.client.ITask;
import com.aliyun.openservices.loghub.client.InitTaskResult;
import com.aliyun.openservices.loghub.client.LogHubClientAdapter;
import com.aliyun.openservices.loghub.client.TaskResult;
import com.aliyun.openservices.loghub.client.config.LogHubCursorPosition;
import com.aliyun.openservices.loghub.client.interfaces.ILogHubProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitializeTask
implements ITask {
    private static final Logger LOG = LoggerFactory.getLogger(InitializeTask.class);
    private LogHubClientAdapter loghubClient;
    private ILogHubProcessor processor;
    private int shardId;
    private LogHubCursorPosition position;
    private long startTime;

    public InitializeTask(ILogHubProcessor processor, LogHubClientAdapter loghubClient, int shardId, LogHubCursorPosition position, long startTime) {
        this.processor = processor;
        this.loghubClient = loghubClient;
        this.shardId = shardId;
        this.position = position;
        this.startTime = startTime;
    }

    @Override
    public TaskResult call() {
        try {
            this.processor.initialize(this.shardId);
            boolean isCursorPersistent = false;
            String checkPoint = this.loghubClient.GetCheckPoint(this.shardId);
            String cursor = null;
            if (checkPoint != null && checkPoint.length() > 0) {
                isCursorPersistent = true;
                cursor = checkPoint;
            } else {
                cursor = this.loghubClient.getCursor(this.shardId, this.position, this.startTime);
            }
            return new InitTaskResult(cursor, isCursorPersistent);
        }
        catch (Exception e) {
            LOG.error("Error fetching initial position", (Throwable)e);
            return new TaskResult(e);
        }
    }
}

