/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.common.comm;

import com.aliyun.common.comm.ExecutionContext;
import com.aliyun.common.comm.HttpMesssage;
import com.aliyun.common.comm.RequestMessage;
import com.aliyun.common.comm.ResponseHandler;
import com.aliyun.common.comm.ResponseMessage;
import com.aliyun.common.parser.ResultParseException;
import com.aliyun.common.parser.ResultParser;
import com.aliyun.common.utils.CodingUtils;
import com.aliyun.common.utils.HttpUtil;
import com.aliyun.common.utils.ResourceManager;
import com.aliyun.openservices.ClientConfiguration;
import com.aliyun.openservices.ClientException;
import com.aliyun.openservices.HttpMethod;
import com.aliyun.openservices.ServiceException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NoHttpResponseException;

public abstract class ServiceClient {
    private static final int DEFAULT_RETRY_PAUSE_SCALE = 300;
    private static final Log log = LogFactory.getLog(ServiceClient.class);
    private static ResourceManager rm = ResourceManager.getInstance("common");
    private ClientConfiguration config;

    protected ServiceClient(ClientConfiguration config) {
        this.config = config;
    }

    public <T> T sendRequest(RequestMessage request, ExecutionContext context, ResultParser parser) throws ServiceException, ClientException {
        Object object;
        CodingUtils.assertParameterNotNull(parser, "parser");
        ResponseMessage response = this.sendRequest(request, context);
        try {
            this.handleResponse(response, context.getResponseHandlers());
            object = parser.getObject(response);
        }
        catch (ResultParseException e) {
            throw new ClientException(rm.getString("FailedToParseResponse"), e);
        }
        finally {
            try {
                response.close();
            }
            catch (IOException e) {}
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseMessage sendRequest(RequestMessage request, ExecutionContext context) throws ServiceException, ClientException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertParameterNotNull(context, "context");
        try {
            ResponseMessage responseMessage = this.sendRequestImpl(request, context);
            return responseMessage;
        }
        finally {
            try {
                request.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ResponseMessage sendRequestImpl(RequestMessage request, ExecutionContext context) throws ClientException, ServiceException {
        if (context.getSigner() != null) {
            context.getSigner().sign(request);
        }
        int retries = 0;
        ResponseMessage response = null;
        while (true) {
            try {
                if (retries > 0) {
                    this.pause(retries);
                    InputStream content = request.getContent();
                    if (content != null && content.markSupported()) {
                        content.reset();
                    }
                }
                ++retries;
                response = null;
                response = this.sendRequestCore(this.buildRequest(request, context), context);
                this.handleResponse(response, context.getResponseHandlers());
                return response;
            }
            catch (ServiceException e) {
                log.debug((Object)("Unable to execute the request due a service error: " + e.getMessage()));
                this.closeResponseSilently(response);
                if (this.shouldRetry(request, e, response != null ? response.getStatusCode() : 0, retries)) continue;
                throw e;
            }
            catch (Exception e) {
                log.debug((Object)("Unable to execute the request due to exception: [" + e.getClass().getName() + "] " + e.getMessage()));
                this.closeResponseSilently(response);
                if (!this.shouldRetry(request, e, 0, retries)) throw new ClientException(rm.getFormattedString("ConnectionError", e.getMessage()), e);
                continue;
            }
            break;
        }
    }

    protected abstract ResponseMessage sendRequestCore(Request var1, ExecutionContext var2) throws Exception;

    private Request buildRequest(RequestMessage requestMessage, ExecutionContext context) throws ClientException {
        boolean putParamsInUri;
        String paramString;
        Request request = new Request();
        request.setMethod(requestMessage.getMethod());
        request.setHeaders(requestMessage.getHeaders());
        if (request.getHeaders() != null) {
            HttpUtil.convertHeaderCharsetToIso88591(request.getHeaders());
        }
        String delimiter = "/";
        String uri = requestMessage.getEndpoint().toString();
        if (!(uri.endsWith("/") || requestMessage.getResourcePath() != null && requestMessage.getResourcePath().startsWith("/"))) {
            uri = uri + "/";
        }
        if (requestMessage.getResourcePath() != null) {
            uri = uri + requestMessage.getResourcePath();
        }
        try {
            paramString = HttpUtil.paramToQueryString(requestMessage.getParameters(), context.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)rm.getFormattedString("EncodingFailed", e.getMessage()));
        }
        boolean requestHasNoPayload = requestMessage.getContent() != null;
        boolean requestIsPost = requestMessage.getMethod() == HttpMethod.POST;
        boolean bl = putParamsInUri = !requestIsPost || requestHasNoPayload;
        if (paramString != null && putParamsInUri) {
            uri = uri + "?" + paramString;
        }
        request.setUrl(uri);
        if (requestIsPost && requestMessage.getContent() == null && paramString != null) {
            try {
                byte[] buf = paramString.getBytes(context.getCharset());
                ByteArrayInputStream content = new ByteArrayInputStream(buf);
                request.setContent(content);
                request.setContentLength(buf.length);
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)rm.getFormattedString("EncodingFailed", e.getMessage()));
            }
        } else {
            request.setContent(requestMessage.getContent());
            request.setContentLength(requestMessage.getContentLength());
        }
        return request;
    }

    private void handleResponse(ResponseMessage response, List<ResponseHandler> responseHandlers) throws ServiceException, ClientException {
        for (ResponseHandler h : responseHandlers) {
            h.handle(response);
        }
    }

    private void pause(int retries) throws ClientException {
        int scale = 300;
        long delay = (long)Math.pow(2.0, retries) * (long)scale;
        log.debug((Object)("Retriable error detected, will retry in " + delay + "ms, attempt number: " + retries));
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            throw new ClientException(e.getMessage(), e);
        }
    }

    private boolean shouldRetry(RequestMessage request, Exception exception, int statusCode, int retries) {
        if (retries > this.config.getMaxErrorRetry()) {
            return false;
        }
        if (!request.isRepeatable()) {
            return false;
        }
        if (exception instanceof SocketException || exception instanceof SocketTimeoutException || exception instanceof NoHttpResponseException) {
            log.debug((Object)("Retrying on " + exception.getClass().getName() + ": " + exception.getMessage()));
            return true;
        }
        if (statusCode == 500 || statusCode == 503) {
            log.debug((Object)("Retrying on " + exception.getClass().getName() + ": " + exception.getMessage()));
            return true;
        }
        return false;
    }

    private void closeResponseSilently(ResponseMessage response) {
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class Request
    extends HttpMesssage {
        private String uri;
        private HttpMethod method;

        public String getUri() {
            return this.uri;
        }

        public void setUrl(String uri) {
            this.uri = uri;
        }

        public HttpMethod getMethod() {
            return this.method;
        }

        public void setMethod(HttpMethod method) {
            this.method = method;
        }
    }
}

