/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.OdpsType;
import com.aliyun.odps.type.ArrayTypeInfo;
import com.aliyun.odps.type.MapTypeInfo;
import com.aliyun.odps.type.PrimitiveTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoFactory;
import java.util.ArrayList;
import java.util.List;

public final class Column {
    private String name;
    private OdpsType type;
    private TypeInfo typeInfo;
    private String comment;
    private String label;
    private List<OdpsType> genericOdpsTypeList;

    @Deprecated
    public Column(String name, OdpsType type, String comment) {
        this(name, type, comment, null, null);
    }

    public Column(String name, TypeInfo typeInfo, String comment) {
        this(name, typeInfo, comment, null);
    }

    public Column(String name, TypeInfo typeInfo) {
        this(name, typeInfo, null);
    }

    Column(String name, TypeInfo typeInfo, String comment, String label) {
        this.name = name;
        this.comment = comment;
        this.typeInfo = typeInfo;
        this.label = label;
        this.type = typeInfo.getOdpsType();
        this.initGenericOdpsTypeList();
    }

    private void initGenericOdpsTypeList() {
        switch (this.type) {
            case ARRAY: {
                this.genericOdpsTypeList = new ArrayList<OdpsType>();
                this.genericOdpsTypeList.add(((ArrayTypeInfo)this.typeInfo).getElementTypeInfo().getOdpsType());
                break;
            }
            case MAP: {
                this.genericOdpsTypeList = new ArrayList<OdpsType>();
                MapTypeInfo mapTypeInfo = (MapTypeInfo)this.typeInfo;
                this.genericOdpsTypeList.add(mapTypeInfo.getKeyTypeInfo().getOdpsType());
                this.genericOdpsTypeList.add(mapTypeInfo.getValueTypeInfo().getOdpsType());
                break;
            }
        }
    }

    Column(String name, OdpsType type, String comment, String label, List<OdpsType> genericOdpsTypeList) {
        this.name = name;
        this.comment = comment;
        this.label = label;
        this.type = type;
        this.genericOdpsTypeList = genericOdpsTypeList;
        this.initTypeInfo();
    }

    public Column(String name, OdpsType type) {
        this(name, type, null);
    }

    private void initTypeInfo() {
        switch (this.type) {
            case ARRAY: {
                this.initArrayTypeInfo();
                break;
            }
            case MAP: {
                this.initMapTypeInfo();
                break;
            }
            case VARCHAR: {
                throw new IllegalArgumentException("The length of " + (Object)((Object)this.type) + " must be specified, pls use TypeInfoFactory.getVarcharTypeInfo to new Column.");
            }
            case CHAR: {
                throw new IllegalArgumentException("The length of " + (Object)((Object)this.type) + " must be specified, pls use TypeInfoFactory.getCharTypeInfo to new Column.");
            }
            default: {
                if (this.typeInfo != null) break;
                this.typeInfo = TypeInfoFactory.getPrimitiveTypeInfo(this.type);
            }
        }
    }

    private void initMapTypeInfo() {
        if (this.genericOdpsTypeList == null) {
            return;
        }
        if (this.genericOdpsTypeList.size() < 2) {
            throw new IllegalArgumentException("Error genericOdpsTypeList for Map.");
        }
        PrimitiveTypeInfo keyType = TypeInfoFactory.getPrimitiveTypeInfo(this.genericOdpsTypeList.get(0));
        PrimitiveTypeInfo valueType = TypeInfoFactory.getPrimitiveTypeInfo(this.genericOdpsTypeList.get(1));
        this.typeInfo = TypeInfoFactory.getMapTypeInfo(keyType, valueType);
    }

    private void initArrayTypeInfo() {
        if (this.genericOdpsTypeList == null) {
            return;
        }
        if (this.genericOdpsTypeList.size() < 1) {
            throw new IllegalArgumentException("Error genericOdpsTypeList for Array.");
        }
        PrimitiveTypeInfo valueType = TypeInfoFactory.getPrimitiveTypeInfo(this.genericOdpsTypeList.get(0));
        this.typeInfo = TypeInfoFactory.getArrayTypeInfo(valueType);
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public OdpsType getType() {
        return this.type;
    }

    public TypeInfo getTypeInfo() {
        if (this.typeInfo == null) {
            throw new IllegalArgumentException("Failed to get TypeInfo for " + this.type.toString() + ", please set generic type list first.");
        }
        return this.typeInfo;
    }

    public String getComment() {
        return this.comment;
    }

    @Deprecated
    public Long getLabel() {
        if (this.label == null) {
            return null;
        }
        try {
            return Long.parseLong(this.label);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public String getCategoryLabel() {
        return this.label;
    }

    public List<OdpsType> getGenericTypeList() {
        return this.genericOdpsTypeList;
    }

    public void setGenericTypeList(List<OdpsType> genericOdpsTypeList) {
        this.genericOdpsTypeList = genericOdpsTypeList;
        this.initTypeInfo();
    }
}

