/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc.utils.transformer.to.jdbc;

import com.aliyun.odps.jdbc.utils.transformer.to.jdbc.AbstractToJdbcTransformer;
import com.aliyun.odps.jdbc.utils.transformer.to.jdbc.ToJdbcBigDecimalTransformer;
import com.aliyun.odps.jdbc.utils.transformer.to.jdbc.ToJdbcBooleanTransformer;
import com.aliyun.odps.jdbc.utils.transformer.to.jdbc.ToJdbcByteArrayTransformer;
import com.aliyun.odps.jdbc.utils.transformer.to.jdbc.ToJdbcByteTransformer;
import com.aliyun.odps.jdbc.utils.transformer.to.jdbc.ToJdbcDateToJdbcDateTypeTransformer;
import com.aliyun.odps.jdbc.utils.transformer.to.jdbc.ToJdbcDoubleTransformer;
import com.aliyun.odps.jdbc.utils.transformer.to.jdbc.ToJdbcFloatTransformer;
import com.aliyun.odps.jdbc.utils.transformer.to.jdbc.ToJdbcIntTransformer;
import com.aliyun.odps.jdbc.utils.transformer.to.jdbc.ToJdbcLongTransformer;
import com.aliyun.odps.jdbc.utils.transformer.to.jdbc.ToJdbcShortTransformer;
import com.aliyun.odps.jdbc.utils.transformer.to.jdbc.ToJdbcStringTransformer;
import com.aliyun.odps.jdbc.utils.transformer.to.jdbc.ToJdbcTimeTransfomer;
import com.aliyun.odps.jdbc.utils.transformer.to.jdbc.ToJdbcTimestampTransformer;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class ToJdbcTransformerFactory {
    private static final ToJdbcByteTransformer BYTE_TRANSFORMER = new ToJdbcByteTransformer();
    private static final ToJdbcShortTransformer SHORT_TRANSFORMER = new ToJdbcShortTransformer();
    private static final ToJdbcIntTransformer INT_TRANSFORMER = new ToJdbcIntTransformer();
    private static final ToJdbcLongTransformer LONG_TRANSFORMER = new ToJdbcLongTransformer();
    private static final ToJdbcFloatTransformer FLOAT_TRANSFORMER = new ToJdbcFloatTransformer();
    private static final ToJdbcDoubleTransformer DOUBLE_TRANSFORMER = new ToJdbcDoubleTransformer();
    private static final ToJdbcBigDecimalTransformer BIG_DECIMAL_TRANSFORMER = new ToJdbcBigDecimalTransformer();
    private static final ToJdbcStringTransformer STRING_TRANSFORMER = new ToJdbcStringTransformer();
    private static final ToJdbcByteArrayTransformer BYTE_ARRAY_TRANSFORMER = new ToJdbcByteArrayTransformer();
    private static final ToJdbcDateToJdbcDateTypeTransformer DATE_TRANSFORMER = new ToJdbcDateToJdbcDateTypeTransformer();
    private static final ToJdbcTimeTransfomer TIME_TRANSFORMER = new ToJdbcTimeTransfomer();
    private static final ToJdbcTimestampTransformer TIMESTAMP_TRANSFORMER = new ToJdbcTimestampTransformer();
    private static final ToJdbcBooleanTransformer BOOLEAN_TRANSFORMER = new ToJdbcBooleanTransformer();
    private static final Map<Class, AbstractToJdbcTransformer> JDBC_CLASS_TO_TRANSFORMER = new HashMap<Class, AbstractToJdbcTransformer>();

    static {
        JDBC_CLASS_TO_TRANSFORMER.put(Byte.TYPE, BYTE_TRANSFORMER);
        JDBC_CLASS_TO_TRANSFORMER.put(Short.TYPE, SHORT_TRANSFORMER);
        JDBC_CLASS_TO_TRANSFORMER.put(Integer.TYPE, INT_TRANSFORMER);
        JDBC_CLASS_TO_TRANSFORMER.put(Long.TYPE, LONG_TRANSFORMER);
        JDBC_CLASS_TO_TRANSFORMER.put(Float.TYPE, FLOAT_TRANSFORMER);
        JDBC_CLASS_TO_TRANSFORMER.put(Double.TYPE, DOUBLE_TRANSFORMER);
        JDBC_CLASS_TO_TRANSFORMER.put(BigDecimal.class, BIG_DECIMAL_TRANSFORMER);
        JDBC_CLASS_TO_TRANSFORMER.put(String.class, STRING_TRANSFORMER);
        JDBC_CLASS_TO_TRANSFORMER.put(byte[].class, BYTE_ARRAY_TRANSFORMER);
        JDBC_CLASS_TO_TRANSFORMER.put(Date.class, DATE_TRANSFORMER);
        JDBC_CLASS_TO_TRANSFORMER.put(Time.class, TIME_TRANSFORMER);
        JDBC_CLASS_TO_TRANSFORMER.put(Timestamp.class, TIMESTAMP_TRANSFORMER);
        JDBC_CLASS_TO_TRANSFORMER.put(Boolean.TYPE, BOOLEAN_TRANSFORMER);
    }

    private ToJdbcTransformerFactory() {
    }

    public static AbstractToJdbcTransformer getTransformer(Class jdbcCls) throws SQLException {
        AbstractToJdbcTransformer transformer = JDBC_CLASS_TO_TRANSFORMER.get(jdbcCls);
        if (transformer == null) {
            throw new SQLException("Not supported JDBC class: " + jdbcCls.getName());
        }
        return transformer;
    }
}

