/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc.utils;

import com.aliyun.odps.utils.StringUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class Utils {
    public static String retrieveVersion(String key) {
        Properties prop = new Properties();
        try {
            prop.load(Utils.class.getResourceAsStream("/version.properties"));
            return prop.getProperty(key);
        }
        catch (IOException iOException) {
            return "unknown";
        }
    }

    public static boolean matchPattern(String s, String pattern) {
        if (StringUtils.isNullOrEmpty((String)pattern)) {
            return true;
        }
        if (pattern.contains("%") || pattern.contains("_")) {
            String wildcard = pattern.replaceAll("(?<!\\\\)%", "\\\\w*").replaceAll("(?<!\\\\)_", "\\\\w");
            if (!s.matches(wildcard = wildcard.replace("\\%", "%").replace("\\_", "_"))) {
                return false;
            }
        } else if (!s.equals(pattern)) {
            return false;
        }
        return true;
    }

    public static int getSinkCountFromTaskSummary(String jsonSummary) {
        JsonObject outputs;
        int ret;
        block5: {
            if (StringUtils.isNullOrEmpty((String)jsonSummary)) {
                return -1;
            }
            ret = 0;
            JsonObject summary = new JsonParser().parse(jsonSummary).getAsJsonObject();
            outputs = summary.getAsJsonObject("Outputs");
            if (!"{}".equals(outputs.toString())) break block5;
            return -1;
        }
        try {
            for (Map.Entry entry : outputs.entrySet()) {
                ret += ((JsonElement)entry.getValue()).getAsJsonArray().get(0).getAsInt();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

